/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.sword;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.particle.CrossDustParticleOptions;
import org.confluence.mod.common.entity.projectile.sword.SwordProjectile;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.integration.terra_entity.trail.TerraSwordTrail;
import org.confluence.terraentity.api.entity.IOBBProjectile;
import org.confluence.terraentity.entity.ai.keyframe.Keyframe;
import org.confluence.terraentity.entity.ai.keyframe.animation.Vec3KeyframeAnimation;
import org.confluence.terraentity.utils.OBB;
import org.confluence.terraentity.utils.TEUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;

public class NightEdgeProjectile
extends SwordProjectile
implements IOBBProjectile {
    Vec3KeyframeAnimation posAnimation;
    Vec3KeyframeAnimation rotAnimation;
    public TerraSwordTrail trail;

    public NightEdgeProjectile(EntityType<? extends SwordProjectile> entityType, Level pLevel) {
        super(entityType, pLevel);
        this.canPenalize = true;
        this.hitCount = 9999;
        this.posAnimation = new Vec3KeyframeAnimation(List.of(new Keyframe(0.0, -1.2, -0.5, 1.0), new Keyframe(3.0, -1.2, 0.5, 1.0), new Keyframe(6.0, 1.2, 0.5, 1.0), new Keyframe(9.0, 1.2, -0.5, 1.0), new Keyframe(12.0, -1.2)), List.of(new Keyframe(0.0, 0.3), new Keyframe(3.0, -0.4), new Keyframe(6.0, -0.8), new Keyframe(9.0, -0.4), new Keyframe(12.0, 0.3)), List.of(new Keyframe(0.0, -2.0, 1.0, 1.0), new Keyframe(3.0, 1.0, 1.0, 1.0), new Keyframe(6.0, 1.0, -1.0, 1.0), new Keyframe(9.0, -2.0, -1.0, 1.0), new Keyframe(12.0, -2.0)));
        this.rotAnimation = Vec3KeyframeAnimation.builder().addKeyframe(new Keyframe(0.0, 0.0, 0.0, 1.0, 0.0, 1.0), new Vec3(0.0, 135.0, 120.0)).addKeyframe(new Keyframe(3.0, 0.0, 0.0, 1.0, 0.0, 1.0), new Vec3(0.0, 45.0, 120.0)).addKeyframe(new Keyframe(6.0, 0.0, 0.0, 1.0, 0.0, 1.0), new Vec3(0.0, -45.0, 120.0)).addKeyframe(new Keyframe(9.0, 0.0, 0.0, 1.0, 0.0, 1.0), new Vec3(0.0, -135.0, 120.0)).addKeyframe(new Keyframe(12.0, 0.0, 0.0, 1.0, 0.0, 1.0), new Vec3(0.0, -225.0, 120.0)).build();
        this.trail = new TerraSwordTrail(3.0f, 0.3f, 0x121212);
        this.setExistTime(11);
    }

    @Override
    public DamageSource damageSource() {
        return ModDamageTypes.of(this.level(), (ResourceKey<DamageType>)DamageTypes.MOB_ATTACK, (Entity)this, this.getOwner());
    }

    @NotNull
    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate(3.0);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.0;
    }

    public boolean isControlledByLocalInstance() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.isClientSide) {
            this.trail.generateTrail(this, this.tickCount);
        }
        if (level.isClientSide() && this.tickCount <= 14 && level.random.nextBoolean()) {
            Vec3 pos = this.position().offsetRandom(level.random, 0.3f);
            Entity owner = this.getOwner();
            if (owner != null) {
                Vec3 facing = TEUtils.rotToDir((float)owner.getYHeadRot(), (float)owner.getXRot()).scale(0.05);
                Vector4f curve = new Vector4f(0.0f, 1.0f, 1.0f, 1.0f);
                boolean dark = level.random.nextBoolean();
                CrossDustParticleOptions lightParticle = new CrossDustParticleOptions(false, dark ? -11071747 : -1777409, dark ? -12509533 : -3843073, facing.toVector3f(), curve, level.random.nextFloat() * 0.15f + 0.15f, 10, 60, curve, true, true, true, false);
                level.addParticle((ParticleOptions)lightParticle, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
            Vector4f curve = new Vector4f(0.0f, 0.7f, 0.9f, 1.0f);
            CrossDustParticleOptions darkParticle = new CrossDustParticleOptions(level.random.nextBoolean(), 1725798911, 2138132098, Vec3.ZERO.offsetRandom(level.random, level.random.nextFloat() * 0.005f + 0.01f).toVector3f(), curve, level.random.nextFloat() * 0.6f + 0.4f, 30, level.random.nextInt(-40, 40), curve, true, true, false, false);
            level.addParticle((ParticleOptions)darkParticle, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
        }
        this.setDeltaMovement(Vec3.ZERO);
        this.updateObb();
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
    }

    public float lengthScale() {
        return 6.0f;
    }

    public OBB buildOBB() {
        return super.buildOBB().inflate(0.5);
    }

    public Vec3 getModelPosition(int time) {
        return this.posAnimation.cal((double)time);
    }

    public Vec3 getModelPosition(float time) {
        return this.posAnimation.cal((double)time);
    }

    public float updateXRot(int time) {
        return (float)this.rotAnimation.cal((double)time).x();
    }

    public float updateYRot(int time) {
        return (float)this.rotAnimation.cal((double)time).y();
    }

    public float updateZRot(float time) {
        return (float)this.rotAnimation.cal((double)time).z();
    }
}

