/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.event.game.entity;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.api.event.MinecartAbilityEvent;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.attachment.PlayerSpecialData;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.armor.ModArmorBonus;
import org.confluence.mod.mixed.ILivingEntity;
import org.confluence.mod.util.AchievementUtils;

@EventBusSubscriber(modid="confluence")
public final class EntityEvents {
    @SubscribeEvent
    public static void mount(EntityMountEvent event) {
        Entity entity;
        Entity beingMounted = event.getEntityBeingMounted();
        if (beingMounted.isRemoved() || !((entity = event.getEntityMounting()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (beingMounted instanceof LivingEntity) {
            AchievementUtils.awardAchievement(player, "the_cavalry");
        }
        if (((Boolean)CommonConfigs.RIGHT_CLICK_RIDE_MINECART.get()).booleanValue() && event.isDismounting() && beingMounted instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)beingMounted;
            MinecartAbilityEvent.DismountOnMinecart e = (MinecartAbilityEvent.DismountOnMinecart)NeoForge.EVENT_BUS.post((Event)new MinecartAbilityEvent.DismountOnMinecart((Player)player, minecart));
            ItemStack itemStack = e.getMinecartItem();
            if (e.isCanceled() || itemStack == null) {
                return;
            }
            ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)player);
            if (extraInventory.getMinecart(false).isEmpty()) {
                extraInventory.setEquipment(2, itemStack, false);
            } else {
                player.addItem(itemStack);
            }
            player.vehicle = null;
            minecart.removePassenger((Entity)player);
            minecart.discard();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void invulnerabilityCheck(EntityInvulnerabilityCheckEvent event) {
        Player player;
        Entity entity;
        Entity entity2;
        if (event.isInvulnerable() || !((entity2 = event.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity2;
        if (ILivingEntity.of(living).confluence$getExtraInvulnerableTicks() > 0) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.is(DamageTypes.FELL_OUT_OF_WORLD) || damageSource.is(DamageTypes.GENERIC_KILL)) {
            return;
        }
        if (damageSource.is(ModDamageTypes.BOULDER) && living.getType().is(Tags.EntityTypes.BOSSES)) {
            event.setInvulnerable(true);
        } else if ((damageSource.getEntity() == null || !damageSource.getEntity().getType().is(Tags.EntityTypes.BOSSES)) && living.hasEffect(ModEffects.SHIMMER)) {
            event.setInvulnerable(true);
        } else if (damageSource.is(DamageTypeTags.IS_FIRE)) {
            Player player2;
            if (living.hasEffect(ModEffects.OBSIDIAN_SKIN) || living instanceof Player && ModArmorBonus.hasType(player2 = (Player)living, ModArmorBonus.LAVA$IMMUNE)) {
                living.clearFire();
                event.setInvulnerable(true);
            }
        } else if (!living.getType().is(ModTags.EntityTypes.CRITTER_COMPANIONSHIP_BLACKLIST) && (entity = damageSource.getEntity()) instanceof Player && !PlayerSpecialData.of(player = (Player)entity).isCouldHurtCritters() && (LibUtils.isAnimal((LivingEntity)living) || living.getType().is(ModTags.EntityTypes.CRITTER_COMPANIONSHIP_WHITELIST))) {
            event.setInvulnerable(true);
        }
    }
}

