/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.gameevent;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import org.confluence.lib.common.data.saved.IGlobalData;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.NaturalSpawnerUtil;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.gameevent.CustomGameEventRegisterEvent;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.gameevent.BloodMoonGameEvent;
import org.confluence.mod.common.gameevent.FrostMoonGameEvent;
import org.confluence.mod.common.gameevent.GameEvent;
import org.confluence.mod.common.gameevent.GoblinArmyGameEvent;
import org.confluence.mod.common.gameevent.LanternNightGameEvent;
import org.confluence.mod.common.gameevent.MeteorShowerGameEvent;
import org.confluence.mod.common.gameevent.PumpkinMoonGameEvent;
import org.confluence.mod.common.gameevent.SlimeRainGameEvent;
import org.confluence.mod.common.gameevent.SpecificMoonGameEvent;
import org.confluence.mod.network.s2c.GameEventSyncPacketS2C;
import org.jetbrains.annotations.Nullable;

public final class GameEventSystem
implements IGlobalData {
    public static final GameEventSystem INSTANCE = new GameEventSystem();
    public static final ResourceKey<GameEvent> ALL_EVENT_KEY = GameEvent.createKey(Confluence.asResource("all_event"));
    private final Map<ResourceKey<? extends GameEvent>, GameEvent> events = (Map)Util.make(new IdentityHashMap(), map -> {
        map.put(SlimeRainGameEvent.KEY, SlimeRainGameEvent.INSTANCE);
        map.put(BloodMoonGameEvent.KEY, BloodMoonGameEvent.INSTANCE);
        map.put(GoblinArmyGameEvent.KEY, GoblinArmyGameEvent.INSTANCE);
        map.put(MeteorShowerGameEvent.KEY, MeteorShowerGameEvent.INSTANCE);
        map.put(LanternNightGameEvent.KEY, LanternNightGameEvent.INSTANCE);
        map.put(SpecificMoonGameEvent.KEY, SpecificMoonGameEvent.INSTANCE);
        map.put(FrostMoonGameEvent.KEY, FrostMoonGameEvent.INSTANCE);
        map.put(PumpkinMoonGameEvent.KEY, PumpkinMoonGameEvent.INSTANCE);
        ModLoader.postEvent((Event)new CustomGameEventRegisterEvent((Map<ResourceKey<? extends GameEvent>, GameEvent>)map));
    });
    private transient int startedEventAmount;
    private transient int startedNonEnvEventAmount;
    public static final Map<ResourceKey<? extends GameEvent>, GameEvent> INVASION_EVENTS = (Map)Util.make(new IdentityHashMap(), map -> {
        map.put(GoblinArmyGameEvent.KEY, GoblinArmyGameEvent.INSTANCE);
        map.put(FrostMoonGameEvent.KEY, FrostMoonGameEvent.INSTANCE);
    });

    private GameEventSystem() {
    }

    public void syncAll(ServerPlayer player) {
        ArrayList<ResourceKey<? extends GameEvent>> started = new ArrayList<ResourceKey<? extends GameEvent>>(this.events.size());
        for (GameEvent event : this.getAllEventInstances()) {
            if (!event.started()) continue;
            started.add(event.key());
        }
        GameEventSyncPacketS2C.sentToClient(player, true, started);
        GoblinArmyGameEvent.INSTANCE.syncProgress();
    }

    public void clearAll(ServerPlayer player) {
        GameEventSyncPacketS2C.sentToClient(player, false, ALL_EVENT_KEY);
    }

    public void open(MinecraftServer server) {
        for (GameEvent event : this.getAllEventInstances()) {
            event.open(server);
        }
    }

    public void close(MinecraftServer server) {
        for (GameEvent event : this.getAllEventInstances()) {
            event.close(server);
        }
    }

    public void tick() {
        int started = 0;
        int nonEnv = 0;
        for (GameEvent event : this.getAllEventInstances()) {
            event.tick();
            if (event.started()) {
                ++started;
                if (event.isNonEnvEvent()) {
                    ++nonEnv;
                }
                if (!event.canEnd()) continue;
                event.onEnd();
                KillBoard.INSTANCE.defeat(event.key());
                GameEventSyncPacketS2C.sendToAll(false, event.key());
                continue;
            }
            if (!event.canStart()) continue;
            event.onStart();
            GameEventSyncPacketS2C.sendToAll(true, event.key());
        }
        this.startedEventAmount = started;
        this.startedNonEnvEventAmount = nonEnv;
    }

    public void countKilled(LivingEntity living) {
        for (GameEvent event : this.getAllEventInstances()) {
            event.countKilled(living);
        }
    }

    @Nullable
    public <E extends GameEvent> E getEventInstance(ResourceKey<E> key) {
        return (E)this.events.get(key);
    }

    public boolean isEventStarted(ResourceKey<? extends GameEvent> key) {
        GameEvent event = this.getEventInstance(key);
        return event != null && event.started();
    }

    public Collection<GameEvent> getAllEventInstances() {
        return this.events.values();
    }

    public Map<ResourceKey<? extends GameEvent>, GameEvent> getEvents() {
        return this.events;
    }

    public int getStartedEventAmount(boolean nonEnv, boolean reCal) {
        if (reCal) {
            int started = 0;
            int nonEnvA = 0;
            for (GameEvent event : this.getAllEventInstances()) {
                if (!event.started()) continue;
                ++started;
                if (!event.isNonEnvEvent()) continue;
                ++nonEnvA;
            }
            this.startedEventAmount = started;
            this.startedNonEnvEventAmount = nonEnvA;
        }
        return nonEnv ? this.startedNonEnvEventAmount : this.startedEventAmount;
    }

    public void decode(CompoundTag tag) {
        for (Map.Entry<ResourceKey<? extends GameEvent>, GameEvent> entry : this.events.entrySet()) {
            entry.getValue().decode(tag.getCompound(entry.getKey().location().toString()));
        }
    }

    public void encode(CompoundTag tag) {
        for (Map.Entry<ResourceKey<? extends GameEvent>, GameEvent> entry : this.events.entrySet()) {
            CompoundTag nbt = new CompoundTag();
            entry.getValue().encode(nbt);
            tag.put(entry.getKey().location().toString(), (Tag)nbt);
        }
    }

    public String serializeKey() {
        return "confluence:game_event_system";
    }

    public static boolean isInvasionEvent(ResourceKey<? extends GameEvent> key) {
        return INVASION_EVENTS.containsKey(key);
    }

    public static boolean anyInvasionStarted() {
        for (GameEvent event : INVASION_EVENTS.values()) {
            if (!event.started()) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldDenyNatureSpawn() {
        return GameEventSystem.anyInvasionStarted();
    }

    public static void removeUnTracked(Set<Entity> spawned, ServerLevel level) {
        spawned.removeIf(entity -> {
            if (LibUtils.getChunkIfLoaded((ServerChunkCache)level.getChunkSource(), (ChunkPos)entity.chunkPosition()) == null) {
                entity.discard();
                return true;
            }
            return entity.isRemoved();
        });
    }

    public static void customSpawner(GameEvent event, ServerLevel level, Set<Entity> spawned, int base, int perPlayer, float intervalFactor, WeightedRandomList<MobSpawnSettings.SpawnerData> spawnerDataList, String entityTag, boolean setTarget) {
        Long2ObjectMap map = NaturalSpawnerUtil.getDimensionChunkSpawnData((ResourceKey)level.dimension());
        if (map == null) {
            event.forceEnd();
            return;
        }
        GameEventSystem.removeUnTracked(spawned, level);
        List players = level.players();
        if (spawned.size() >= base + players.size() * perPlayer) {
            return;
        }
        for (ServerPlayer player : players) {
            Optional random;
            int interval;
            NaturalSpawnerUtil.ChunkSpawnData data = (NaturalSpawnerUtil.ChunkSpawnData)map.getOrDefault(player.chunkPosition().toLong(), (Object)NaturalSpawnerUtil.ChunkSpawnData.DEFAULT);
            double speed = data.speedMultiplier();
            if (speed <= 0.0 || level.random.nextInt(interval = Mth.floor((double)((double)(20.0f * intervalFactor) / speed))) != 0 || (random = spawnerDataList.getRandom(level.random)).isEmpty()) continue;
            Vec3 position = player.position();
            MobSpawnSettings.SpawnerData spawnerData = (MobSpawnSettings.SpawnerData)random.get();
            int count = data.getCount(level.random.nextIntBetweenInclusive(spawnerData.minCount, spawnerData.maxCount));
            for (int j = 0; j < count; ++j) {
                BlockPos pos;
                Entity entity;
                double x = Mth.nextDouble((RandomSource)level.random, (double)(position.x - 32.0), (double)(position.x + 32.0));
                double z = Mth.nextDouble((RandomSource)level.random, (double)(position.z - 32.0), (double)(position.z + 32.0));
                int cx = SectionPos.blockToSectionCoord((double)x);
                int cz = SectionPos.blockToSectionCoord((double)z);
                if (LibUtils.getChunkIfLoaded((ServerChunkCache)level.getChunkSource(), (int)cx, (int)cz) == null || (entity = spawnerData.type.spawn(level, pos = NaturalSpawner.getTopNonCollidingPos((LevelReader)level, (EntityType)spawnerData.type, (int)Mth.floor((double)x), (int)Mth.floor((double)z)), MobSpawnType.EVENT)) == null) continue;
                entity.addTag(entityTag);
                spawned.add(entity);
                if (!setTarget || !(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                if (!player.canBeSeenAsEnemy()) continue;
                mob.setTarget((LivingEntity)player);
            }
        }
    }
}

