/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.gameevent;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.confluence.lib.api.entity.Boss;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.gameevent.BloodMoonGameEvent;
import org.confluence.mod.common.gameevent.GameEvent;
import org.confluence.mod.util.DateUtils;
import org.confluence.mod.util.OverworldUtils;

public final class LanternNightGameEvent
implements GameEvent {
    public static final ResourceKey<LanternNightGameEvent> KEY = GameEvent.createKey(Confluence.asResource("lantern_night"));
    public static final LanternNightGameEvent INSTANCE = new LanternNightGameEvent();
    private static final AttributeModifier MODIFIER = new AttributeModifier(Confluence.asResource("lantern_night"), 0.3, AttributeModifier.Operation.ADD_VALUE);
    private transient MinecraftServer server;
    private transient ServerLevel level;
    private transient boolean forceStart;
    private transient boolean forceEnd;
    private boolean started;
    private boolean scheduled;
    private int cooldown;

    private LanternNightGameEvent() {
    }

    @Override
    public void open(MinecraftServer server) {
        this.server = server;
        this.level = OverworldUtils.getLevel(server);
    }

    @Override
    public void close(MinecraftServer server) {
        this.server = null;
        this.level = null;
    }

    @Override
    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.started && this.level.getGameTime() % 20L == 5L) {
            for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
                AttributeInstance instance = player.getAttribute(Attributes.LUCK);
                if (instance == null) continue;
                if (player.level().dimension() == OverworldUtils.dimension()) {
                    instance.addOrUpdateTransientModifier(MODIFIER);
                    continue;
                }
                instance.removeModifier(MODIFIER);
            }
        }
    }

    public void schedule() {
        this.scheduled = true;
    }

    @Override
    public boolean canStart() {
        if (this.forceStart) {
            return true;
        }
        boolean canStart = false;
        if (LibDateUtils.getDayTime((Level)this.level) == LibDateUtils._19$30 && this.cooldown <= 0) {
            if (this.scheduled) {
                canStart = true;
            } else if (DateUtils.isYuanXiao(DateUtils.getLunar())) {
                canStart = true;
            } else if (KillBoard.INSTANCE.getGamePhase().isGraduated() && this.level.random.nextInt(14) == 0) {
                this.cooldown = this.level.random.nextIntBetweenInclusive(120000, 240000);
                canStart = true;
            }
        }
        if (canStart) {
            return !BloodMoonGameEvent.INSTANCE.started() && Boss.noBossInWorld((ServerLevel)this.level);
        }
        return false;
    }

    @Override
    public boolean canEnd() {
        if (this.forceEnd) {
            return true;
        }
        return LibDateUtils.isWithinDayTime((int)LibDateUtils._04$30, (int)LibDateUtils._19$30, (Level)this.level);
    }

    @Override
    public void onStart() {
        this.forceStart = false;
        this.scheduled = false;
        this.started = true;
    }

    @Override
    public void onEnd() {
        this.forceEnd = false;
        this.started = false;
        for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
            AttributeInstance instance = player.getAttribute(Attributes.LUCK);
            if (instance == null) continue;
            instance.removeModifier(MODIFIER);
        }
    }

    @Override
    public boolean started() {
        return this.started;
    }

    @Override
    public boolean forceStart() {
        if (LibDateUtils.isWithinDayTime((int)LibDateUtils._19$30, (int)LibDateUtils._04$30, (Level)this.level)) {
            this.forceStart = true;
            return true;
        }
        return false;
    }

    @Override
    public void forceEnd() {
        if (this.started) {
            this.forceEnd = true;
        }
    }

    @Override
    public void decode(CompoundTag tag) {
        this.started = tag.getBoolean("Started");
        this.scheduled = tag.getBoolean("Scheduled");
        this.cooldown = tag.getInt("Cooldown");
    }

    @Override
    public void encode(CompoundTag tag) {
        tag.putBoolean("Started", this.started);
        tag.putBoolean("Scheduled", this.scheduled);
        tag.putInt("Cooldown", this.cooldown);
    }

    public ResourceKey<LanternNightGameEvent> key() {
        return KEY;
    }

    @Override
    public boolean isNonEnvEvent() {
        return false;
    }
}

