/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.confluence.mod.Confluence;
import org.confluence.terraentity.init.TETags;
import org.jetbrains.annotations.Nullable;

public final class ModDamageTypes {
    public static final ResourceKey<DamageType> ACID_VENOM = ModDamageTypes.register("acid_venom");
    public static final ResourceKey<DamageType> BOULDER = ModDamageTypes.register("boulder");
    public static final ResourceKey<DamageType> BYPASS_NPC_INVULNERABLE_TO_PLAYER = ModDamageTypes.register("bypass_npc_invulnerable_to_player");
    public static final ResourceKey<DamageType> CURSED_INFERNO = ModDamageTypes.register("cursed_inferno");
    public static final ResourceKey<DamageType> DARKNESS = ModDamageTypes.register("darkness");
    public static final ResourceKey<DamageType> FALLING_STAR = ModDamageTypes.register("falling_star");
    public static final ResourceKey<DamageType> MAGICAL_PROJECTILE = ModDamageTypes.register("magical_projectile");
    public static final ResourceKey<DamageType> SWORD_PROJECTILE = ModDamageTypes.register("sword_projectile");

    private static ResourceKey<DamageType> register(String id) {
        return Confluence.asResourceKey(Registries.DAMAGE_TYPE, id);
    }

    public static DamageSource of(Level level, ResourceKey<DamageType> key) {
        return ModDamageTypes.of(level, key, null, null);
    }

    public static DamageSource of(Level level, ResourceKey<DamageType> key, @Nullable Entity causing) {
        return ModDamageTypes.of(level, key, causing, causing);
    }

    public static DamageSource of(Level level, ResourceKey<DamageType> key, @Nullable Entity direct, @Nullable Entity causing) {
        return level.damageSources().source(key, direct, causing);
    }

    public static void bootstrap(BootstrapContext<DamageType> context) {
        TETags.DamageTypes.createDamageTypes(context);
        ModDamageTypes.damageType(context, ACID_VENOM, DamageScaling.ALWAYS, 10.0f);
        ModDamageTypes.damageType(context, BOULDER, DamageScaling.ALWAYS, 5.0f);
        ModDamageTypes.damageType(context, BYPASS_NPC_INVULNERABLE_TO_PLAYER, DamageScaling.ALWAYS, 10.0f);
        ModDamageTypes.damageType(context, CURSED_INFERNO, DamageScaling.ALWAYS, 10.0f, DamageEffects.BURNING);
        ModDamageTypes.damageType(context, DARKNESS, DamageScaling.ALWAYS, 20.0f);
        ModDamageTypes.damageType(context, FALLING_STAR, DamageScaling.ALWAYS, 10.0f);
        ModDamageTypes.damageType(context, MAGICAL_PROJECTILE, DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f);
        ModDamageTypes.damageType(context, SWORD_PROJECTILE, DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f);
    }

    private static void damageType(BootstrapContext<DamageType> context, ResourceKey<DamageType> key, DamageScaling scaling, float exhaustion, DamageEffects effects, DeathMessageType deathMessageType) {
        context.register(key, (Object)new DamageType(key.location().getPath(), scaling, exhaustion, effects, deathMessageType));
    }

    private static void damageType(BootstrapContext<DamageType> context, ResourceKey<DamageType> key, DamageScaling scaling, float exhaustion, DamageEffects effects) {
        ModDamageTypes.damageType(context, key, scaling, exhaustion, effects, DeathMessageType.DEFAULT);
    }

    private static void damageType(BootstrapContext<DamageType> context, ResourceKey<DamageType> key, DamageScaling scaling, float exhaustion) {
        ModDamageTypes.damageType(context, key, scaling, exhaustion, DamageEffects.HURT, DeathMessageType.DEFAULT);
    }
}

