/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.mod.common.particle.DamageIndicatorOptions;
import org.confluence.mod.common.particle.WholeItemParticleOptions;

public final class ModParticleTypes {
    public static final DeferredRegister<ParticleType<?>> TYPES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"confluence");
    public static final Supplier<ParticleType<DamageIndicatorOptions>> DAMAGE_INDICATOR = ModParticleTypes.register("damage_indicator", true, DamageIndicatorOptions.CODEC, DamageIndicatorOptions.STREAM_CODEC);
    public static final Supplier<ParticleType<WholeItemParticleOptions>> WHOLE_ITEM = ModParticleTypes.register("whole_item", true, WholeItemParticleOptions.CODEC, WholeItemParticleOptions.STREAM_CODEC);
    public static final Supplier<SimpleParticleType> LEAVES = ModParticleTypes.register("leaves", true);
    public static final Supplier<SimpleParticleType> RED_SAND = ModParticleTypes.register("red_sand", true);
    public static final Supplier<SimpleParticleType> SAND = ModParticleTypes.register("sand", true);
    public static final Supplier<SimpleParticleType> SNOW = ModParticleTypes.register("snow", true);
    public static final Supplier<SimpleParticleType> YELLOW_WILLOW = ModParticleTypes.register("yellow_willow", true);
    public static final Supplier<SimpleParticleType> LIGHT_BANE = ModParticleTypes.register("lights_bane", true);
    public static final Supplier<SimpleParticleType> LIGHT_BANE_DUST = ModParticleTypes.register("lights_bane_dust", true);
    public static final Supplier<SimpleParticleType> LIGHT_BANE_FADE = ModParticleTypes.register("lights_bane_fade", true);
    public static final Supplier<SimpleParticleType> ECTO_MIST = ModParticleTypes.register("ecto_mist", true);

    private static <T extends ParticleOptions> Supplier<ParticleType<T>> register(String id, boolean overrideLimiter, final MapCodec<T> mapCodec, final StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        return TYPES.register(id, () -> new ParticleType<T>(overrideLimiter){

            public MapCodec<T> codec() {
                return mapCodec;
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return streamCodec;
            }
        });
    }

    private static Supplier<SimpleParticleType> register(String id, boolean overrideLimiter) {
        return TYPES.register(id, () -> new SimpleParticleType(overrideLimiter));
    }

    private static <T extends ParticleOptions> Supplier<ParticleType<T>> register(String name, boolean overrideLimitter, final Function<ParticleType<T>, MapCodec<T>> codecGetter, final Function<ParticleType<T>, StreamCodec<? super RegistryFriendlyByteBuf, T>> streamCodecGetter) {
        return TYPES.register(name, () -> new ParticleType<T>(overrideLimitter){

            public MapCodec<T> codec() {
                return (MapCodec)codecGetter.apply(this);
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return (StreamCodec)streamCodecGetter.apply(this);
            }
        });
    }
}

