/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.StartupConfigs;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.BaitItems;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.mod.common.init.item.FoodItems;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.init.item.PotionItems;
import org.confluence.mod.common.recipe.AlchemyTableRecipe;
import org.confluence.mod.common.recipe.AltarRecipe;
import org.confluence.mod.common.recipe.CookingPotRecipe;
import org.confluence.mod.common.recipe.CrystalBallRecipe;
import org.confluence.mod.common.recipe.DyeVatRecipe;
import org.confluence.mod.common.recipe.FletchingTableRecipe;
import org.confluence.mod.common.recipe.HardmodeAnvilRecipe;
import org.confluence.mod.common.recipe.HardmodeForgeRecipe;
import org.confluence.mod.common.recipe.HeavyWorkBenchRecipe;
import org.confluence.mod.common.recipe.HellforgeRecipe;
import org.confluence.mod.common.recipe.ItemTransmutationRecipe;
import org.confluence.mod.common.recipe.LoomRecipe;
import org.confluence.mod.common.recipe.SawmillRecipe;
import org.confluence.mod.common.recipe.SkyMillRecipe;
import org.confluence.mod.common.recipe.SolidifierRecipe;
import org.confluence.mod.common.recipe.special.BoomBunnyRecipe;

public final class ModRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"confluence");
    public static final DeferredRegister<RecipeType<?>> TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"confluence");
    public static final Supplier<RecipeType<AltarRecipe>> ALTAR_TYPE = ModRecipes.registerType("altar");
    public static final Supplier<RecipeSerializer<?>> ALTAR_SERIALIZER = SERIALIZERS.register("altar", AltarRecipe.Serializer::new);
    public static final Supplier<RecipeType<SkyMillRecipe>> SKY_MILL_TYPE = ModRecipes.registerType("sky_mill");
    public static final Supplier<RecipeSerializer<?>> SKY_MILL_SERIALIZER = SERIALIZERS.register("sky_mill", SkyMillRecipe.Serializer::new);
    public static final Supplier<RecipeType<HeavyWorkBenchRecipe>> HEAVY_WORK_BENCH_TYPE = ModRecipes.registerType("heavy_work_bench");
    public static final Supplier<RecipeSerializer<?>> HEAVY_WORK_BENCH_SERIALIZER = SERIALIZERS.register("heavy_work_bench", HeavyWorkBenchRecipe.Serializer::new);
    public static final Supplier<RecipeType<HellforgeRecipe>> HELLFORGE_TYPE = ModRecipes.registerType("hellforge");
    public static final Supplier<RecipeSerializer<?>> HELLFORGE_SERIALIZER = SERIALIZERS.register("hellforge", HellforgeRecipe.Serializer::new);
    public static final Supplier<RecipeType<FletchingTableRecipe>> FLETCHING_TABLE_TYPE = ModRecipes.registerType("fletching_table");
    public static final Supplier<RecipeSerializer<?>> FLETCHING_TABLE_SERIALIZER = SERIALIZERS.register("fletching_table", FletchingTableRecipe.Serializer::new);
    public static final Supplier<RecipeType<AlchemyTableRecipe>> ALCHEMY_TABLE_TYPE = ModRecipes.registerType("alchemy_table");
    public static final Supplier<RecipeSerializer<?>> ALCHEMY_TABLE_SERIALIZER = SERIALIZERS.register("alchemy_table", AlchemyTableRecipe.Serializer::new);
    public static final Supplier<RecipeType<CookingPotRecipe>> COOKING_POT_TYPE = ModRecipes.registerType("cooking_pot");
    public static final Supplier<RecipeSerializer<?>> COOKING_POT_SERIALIZER = SERIALIZERS.register("cooking_pot", CookingPotRecipe.Serializer::new);
    public static final Supplier<RecipeType<SawmillRecipe>> SAWMILL_TYPE = ModRecipes.registerType("sawmill");
    public static final Supplier<RecipeSerializer<?>> SAWMILL_SERIALIZER = SERIALIZERS.register("sawmill", SawmillRecipe.Serializer::new);
    public static final Supplier<RecipeType<SolidifierRecipe>> SOLIDIFIER_TYPE = ModRecipes.registerType("solidifier");
    public static final Supplier<RecipeSerializer<?>> SOLIDIFIER_SERIALIZER = SERIALIZERS.register("solidifier", SolidifierRecipe.Serializer::new);
    public static final Supplier<RecipeType<CrystalBallRecipe>> CRYSTAL_BALL_TYPE = ModRecipes.registerType("crystal_ball");
    public static final Supplier<RecipeSerializer<?>> CRYSTAL_BALL_SERIALIZER = SERIALIZERS.register("crystal_ball", CrystalBallRecipe.Serializer::new);
    public static final Supplier<RecipeType<HardmodeAnvilRecipe>> HARDMODE_ANVIL_TYPE = ModRecipes.registerType("hardmode_anvil");
    public static final Supplier<RecipeSerializer<?>> HARDMODE_ANVIL_SERIALIZER = SERIALIZERS.register("hardmode_anvil", HardmodeAnvilRecipe.Serializer::new);
    public static final Supplier<RecipeType<ItemTransmutationRecipe>> ITEM_TRANSMUTATION_TYPE = ModRecipes.registerType("item_transmutation");
    public static final Supplier<RecipeSerializer<?>> ITEM_TRANSMUTATION_SERIALIZER = SERIALIZERS.register("item_transmutation", ItemTransmutationRecipe.Serializer::new);
    public static final Supplier<RecipeType<HardmodeForgeRecipe>> HARDMODE_FORGE_TYPE = ModRecipes.registerType("hardmode_forge");
    public static final Supplier<RecipeSerializer<?>> HARDMODE_FORGE_SERIALIZER = SERIALIZERS.register("hardmode_forge", HardmodeForgeRecipe.Serializer::new);
    public static final Supplier<RecipeType<LoomRecipe>> LOOM_TYPE = ModRecipes.registerType("loom");
    public static final Supplier<RecipeSerializer<?>> LOOM_SERIALIZER = SERIALIZERS.register("loom", LoomRecipe.Serializer::new);
    public static final Supplier<RecipeType<DyeVatRecipe>> DYE_VAT_TYPE = ModRecipes.registerType("dye_vat");
    public static final Supplier<RecipeSerializer<?>> DYE_VAT_SERIALIZER = SERIALIZERS.register("dye_vat", DyeVatRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, BoomBunnyRecipe.Serializer> BOOM_BUNNY_SERIALIZER = SERIALIZERS.register("boom_bunny", BoomBunnyRecipe.Serializer::new);

    private static <R extends Recipe<?>> Supplier<RecipeType<R>> registerType(final String id) {
        return TYPES.register(id + "_type", () -> new RecipeType<R>(){

            public String toString() {
                return Confluence.asPlainId(id);
            }
        });
    }

    public static void register(IEventBus bus) {
        ShapedRecipePattern.setCraftingSize((int)4, (int)4);
        SERIALIZERS.register(bus);
        TYPES.register(bus);
    }

    public static final class Brewing {
        public static final Object2IntMap<Item> MATERIAL_ID_MAP = new Object2IntOpenHashMap();
        public static final Object2ObjectMap<int[], ItemStack> MATERIAL_TO_RESULT = new Object2ObjectOpenHashMap();

        public static void initialize() {
            if (!StartupConfigs.brewingStandRecipe()) {
                return;
            }
            Brewing.registerMaterial((Item)MaterialItems.WATERLEAF.get());
            Brewing.registerMaterial((Item)MaterialItems.FIREBLOSSOM.get());
            Brewing.registerMaterial((Item)MaterialItems.MOONGLOW.get());
            Brewing.registerMaterial((Item)MaterialItems.BLINKROOT.get());
            Brewing.registerMaterial((Item)MaterialItems.SHIVERTHORN.get());
            Brewing.registerMaterial((Item)MaterialItems.DAYBLOOM.get());
            Brewing.registerMaterial((Item)MaterialItems.DEATHWEED.get());
            Brewing.registerMaterial((Item)MaterialItems.LENS.get());
            Brewing.registerMaterial(Items.COBWEB);
            Brewing.registerMaterial((Item)FoodItems.ARMORED_CAVE_FISH.get());
            Brewing.registerMaterial(Items.FEATHER);
            Brewing.registerMaterial(DecorativeBlocks.CRISPY_HONEY_BLOCK.asItem());
            Brewing.registerMaterial(Items.FIRE_CORAL);
            Brewing.registerMaterial((Item)BaitItems.LADYBUG.get());
            Brewing.registerMaterial((Item)FoodItems.FLASHFIN_KOI.get());
            Brewing.registerMaterial((Item)FoodItems.OBSIDIFISH.get());
            Brewing.registerMaterial((Item)FoodItems.COLORFUL_MINERAL_FISH.get());
            Brewing.registerMaterial((Item)FoodItems.SCARLET_TIGER_FISH.get());
            Brewing.registerMaterial((Item)MaterialItems.ANTLION_MANDIBLE.get());
            Brewing.registerMaterial((Item)MaterialItems.PINK_PEARL.get());
            Brewing.registerMaterial((Item)MaterialItems.BLACK_PEARL.get());
            Brewing.registerMaterial((Item)MaterialItems.PEARL.get());
            Brewing.registerMaterial((Item)MaterialItems.SHARK_FIN.get());
            Brewing.registerMaterial((Item)MaterialItems.RAW_LEAD.get());
            Brewing.registerMaterial(Items.OBSIDIAN);
            Brewing.registerMaterial(Items.RAW_IRON);
            Brewing.registerMaterial(Items.RAW_GOLD);
            Brewing.registerMaterial(Items.BONE);
            Brewing.registerMaterial(Items.CACTUS);
            Brewing.registerMaterial((Item)FoodItems.PRINCESS_FISH.get());
            Brewing.registerMaterial((Item)FoodItems.BLOODY_PIRANHAS.get());
            Brewing.registerMaterial((Item)MaterialItems.RAW_PLATINUM.get());
            Brewing.registerMaterial((Item)MaterialItems.LIFE_MUSHROOM.get());
            Brewing.registerMaterial((Item)FoodItems.CHAOS_FISH.get());
            Brewing.registerMaterial((Item)FoodItems.MIRROR_FISH.get());
            Brewing.registerMaterial((Item)FoodItems.EBONY_KOI.get());
            Brewing.registerMaterial(NatureBlocks.GLOWING_MUSHROOM.asItem());
            Brewing.registerMaterial((Item)FoodItems.STINKY_FISH.get());
            Brewing.registerMaterial((Item)MaterialItems.AMBER.get());
            Brewing.registerMaterial((Item)FoodItems.MOTTLED_OILFISH.get());
            Brewing.registerMaterial((Item)MaterialItems.FALLING_STAR.get());
            Brewing.registerMaterial((Item)FoodItems.PISCES_FIN_COD.get());
            Brewing.registerMaterial((Item)ConsumableItems.DUNGEON_DEMON_BONE.get());
            Brewing.registerMaterial((Item)MaterialItems.AETHERIUM_GOLD.get());
            Brewing.registerMaterial((Item)MaterialItems.WORM_TOOTH.get());
            Brewing.registerMaterial((Item)MaterialItems.VERTEBRA.get());
            Brewing.registerMaterial((Item)MaterialItems.BLOOD_CLOT_POWDER.get());
            Brewing.registerMaterial((Item)MaterialItems.ROTTEN_BONE.get());
            Brewing.registerMaterial((Item)FoodItems.DAMSEL_FISH.get());
            Brewing.registerMaterial(NatureBlocks.AETHERIUM_BLOCK.asItem());
            Brewing.registerMaterial(FoodItems.RED_PLEATFISH.asItem());
            Brewing.registerMaterial(FoodItems.BROWN_STALKSPINE.asItem());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DAYBLOOM.get(), (Item)MaterialItems.LENS.get()}, PotionItems.ARCHERY_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.BLINKROOT.get(), (Item)MaterialItems.SHIVERTHORN.get(), (Item)MaterialItems.MOONGLOW.get()}, PotionItems.BUILDER_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.SHIVERTHORN.get(), Items.COBWEB}, PotionItems.DANGERSENSE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.ARMORED_CAVE_FISH.get(), (Item)MaterialItems.BLINKROOT.get()}, PotionItems.ENDURANCE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DAYBLOOM.get(), (Item)MaterialItems.BLINKROOT.get(), Items.FEATHER}, PotionItems.FEATHERFALL_POTION.toStack());
            Brewing.registerMix(new Item[]{DecorativeBlocks.CRISPY_HONEY_BLOCK.asItem(), (Item)MaterialItems.WATERLEAF.get()}, PotionItems.FISHING_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.SHIVERTHORN.get(), (Item)MaterialItems.WATERLEAF.get()}, PotionItems.FLIPPER_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.WATERLEAF.get(), Items.FIRE_CORAL}, PotionItems.GILLS_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.FIREBLOSSOM.get(), (Item)MaterialItems.DEATHWEED.get(), (Item)MaterialItems.BLINKROOT.get(), Items.FEATHER}, PotionItems.GRAVITATION_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.WATERLEAF.get(), (Item)BaitItems.LADYBUG.get(), (Item)MaterialItems.PINK_PEARL.get()}, PotionItems.GREATER_LUCK_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.WATERLEAF.get(), (Item)BaitItems.LADYBUG.get(), (Item)MaterialItems.BLACK_PEARL.get()}, PotionItems.LUCK_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.WATERLEAF.get(), (Item)BaitItems.LADYBUG.get(), (Item)MaterialItems.PEARL.get()}, PotionItems.LESSER_LUCK_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.SCARLET_TIGER_FISH.get(), (Item)MaterialItems.DAYBLOOM.get()}, PotionItems.HEART_REACH_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DAYBLOOM.get(), (Item)MaterialItems.BLINKROOT.get(), (Item)MaterialItems.SHARK_FIN.get()}, PotionItems.HUNTER_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.FLASHFIN_KOI.get(), (Item)FoodItems.OBSIDIFISH.get(), (Item)FoodItems.OBSIDIFISH.get(), (Item)MaterialItems.FIREBLOSSOM.get()}, PotionItems.INFERNO_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DAYBLOOM.get(), (Item)MaterialItems.RAW_LEAD.get()}, PotionItems.IRON_SKIN_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DAYBLOOM.get(), Items.RAW_IRON}, PotionItems.IRON_SKIN_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.COLORFUL_MINERAL_FISH.get(), (Item)MaterialItems.MOONGLOW.get(), (Item)MaterialItems.SHIVERTHORN.get(), (Item)MaterialItems.WATERLEAF.get()}, PotionItems.LIFEFORCE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.PRINCESS_FISH.get(), (Item)MaterialItems.SHIVERTHORN.get()}, PotionItems.LOVE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.MOONGLOW.get(), (Item)MaterialItems.DEATHWEED.get(), (Item)MaterialItems.FALLING_STAR.get()}, PotionItems.MAGIC_POWER_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.MOONGLOW.get(), (Item)MaterialItems.DAYBLOOM.get(), (Item)MaterialItems.FALLING_STAR.get()}, PotionItems.MANA_REGENERATION_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.ANTLION_MANDIBLE.get(), (Item)MaterialItems.BLINKROOT.get()}, PotionItems.MINING_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DAYBLOOM.get(), (Item)MaterialItems.BLINKROOT.get()}, PotionItems.NIGHT_OWL_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.FIREBLOSSOM.get(), (Item)MaterialItems.WATERLEAF.get(), Items.OBSIDIAN}, PotionItems.OBSIDIAN_SKIN_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.BLOODY_PIRANHAS.get(), (Item)MaterialItems.DEATHWEED.get()}, PotionItems.RAGE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DAYBLOOM.get(), (Item)MaterialItems.LIFE_MUSHROOM.get()}, PotionItems.REGENERATION_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DAYBLOOM.get(), NatureBlocks.GLOWING_MUSHROOM.asItem()}, PotionItems.SHINE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.BLINKROOT.get(), (Item)MaterialItems.MOONGLOW.get(), (Item)MaterialItems.RAW_PLATINUM.get()}, PotionItems.SPELUNKER_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.BLINKROOT.get(), (Item)MaterialItems.MOONGLOW.get(), Items.RAW_GOLD}, PotionItems.SPELUNKER_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.BLINKROOT.get(), Items.CACTUS}, PotionItems.SWIFTNESS_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DEATHWEED.get(), Items.CACTUS}, PotionItems.THORNS_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)ConsumableItems.DUNGEON_DEMON_BONE.get(), (Item)MaterialItems.DEATHWEED.get(), (Item)MaterialItems.SHIVERTHORN.get()}, PotionItems.TITAN_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.WATERLEAF.get(), (Item)MaterialItems.SHARK_FIN.get()}, PotionItems.WATER_WALKING_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.EBONY_KOI.get(), (Item)MaterialItems.DEATHWEED.get()}, PotionItems.WRATH_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.MIRROR_FISH.get(), (Item)MaterialItems.DAYBLOOM.get()}, PotionItems.RECALL_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.MIRROR_FISH.get(), (Item)MaterialItems.BLINKROOT.get()}, PotionItems.WORMHOLE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.BLINKROOT.get(), (Item)MaterialItems.MOONGLOW.get()}, PotionItems.INVISIBILITY_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.CHAOS_FISH.get(), (Item)MaterialItems.FIREBLOSSOM.get()}, PotionItems.RANDOM_TELEPORT_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.STINKY_FISH.get(), (Item)MaterialItems.DEATHWEED.get()}, PotionItems.STINK_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.AMBER.get(), (Item)MaterialItems.MOONGLOW.get(), (Item)MaterialItems.SHIVERTHORN.get(), (Item)MaterialItems.WATERLEAF.get()}, PotionItems.CRATE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.PISCES_FIN_COD.get(), (Item)MaterialItems.MOONGLOW.get()}, PotionItems.AMMO_RESERVATION_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.MOTTLED_OILFISH.get(), (Item)MaterialItems.MOONGLOW.get()}, PotionItems.SUMMONING_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DEATHWEED.get(), (Item)MaterialItems.ROTTEN_BONE.get()}, PotionItems.BATTLE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DEATHWEED.get(), (Item)MaterialItems.VERTEBRA.get()}, PotionItems.BATTLE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DEATHWEED.get(), (Item)MaterialItems.BLOOD_CLOT_POWDER.get()}, PotionItems.BATTLE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)MaterialItems.DEATHWEED.get(), (Item)MaterialItems.WORM_TOOTH.get()}, PotionItems.BATTLE_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.DAMSEL_FISH.get(), (Item)MaterialItems.DAYBLOOM.get()}, PotionItems.CALMING_POTION.toStack());
            Brewing.registerMix(new Item[]{(Item)FoodItems.RED_PLEATFISH.get(), (Item)FoodItems.BROWN_STALKSPINE.get()}, PotionItems.SATIETY_POTION.toStack());
        }

        private static void registerMaterial(Item material) {
            if (MATERIAL_ID_MAP.containsKey((Object)material)) {
                return;
            }
            MATERIAL_ID_MAP.put((Object)material, MATERIAL_ID_MAP.size());
        }

        private static void registerMix(Item[] materials, ItemStack result) {
            int[] ids = Arrays.stream(materials).mapToInt(material -> MATERIAL_ID_MAP.getOrDefault(material, -1)).filter(id -> id != -1).toArray();
            Arrays.sort(ids);
            MATERIAL_TO_RESULT.put((Object)ids, (Object)result);
        }

        public static void registerRecipes(Consumer<IBrewingRecipe> consumer) {
            consumer.accept(new IBrewingRecipe(){

                public boolean isInput(ItemStack input) {
                    return input.is(PotionItems.CHAOS_POTION) || input.is(PotionItems.BOTTLED_WATER);
                }

                public boolean isIngredient(ItemStack ingredient) {
                    return MATERIAL_ID_MAP.containsKey((Object)ingredient.getItem());
                }

                public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
                    if (!this.isIngredient(ingredient) || !this.isInput(input)) {
                        return ItemStack.EMPTY;
                    }
                    int addition = MATERIAL_ID_MAP.getOrDefault((Object)ingredient.getItem(), -1);
                    if (addition == -1) {
                        return ItemStack.EMPTY;
                    }
                    int[] materials = Brewing.append(Brewing.getMaterials(input), addition);
                    if (Arrays.stream(materials).anyMatch(i -> i < 0)) {
                        return ItemStack.EMPTY;
                    }
                    int length = materials.length;
                    boolean isorted = true;
                    block0: for (Map.Entry entry : MATERIAL_TO_RESULT.entrySet()) {
                        int[] ids = (int[])entry.getKey();
                        if (ids.length != length) continue;
                        if (isorted) {
                            Arrays.sort(materials);
                            isorted = false;
                        }
                        for (int i2 = 0; i2 < ids.length; ++i2) {
                            if (ids[i2] != materials[i2]) continue block0;
                        }
                        return ((ItemStack)entry.getValue()).copy();
                    }
                    ItemStack stack = PotionItems.CHAOS_POTION.toStack();
                    Brewing.setMaterials(stack, materials);
                    return stack;
                }
            });
            final int gel = -1;
            final int life_mushroom = -2;
            final int glowing_mushroom = -3;
            final int lesser_healing_potion = -4;
            final int lesser_mana_potion = -5;
            consumer.accept(new IBrewingRecipe(){

                public boolean isInput(ItemStack input) {
                    return input.is(PotionItems.CHAOS_POTION) || input.is(PotionItems.BOTTLE);
                }

                public boolean isIngredient(ItemStack ingredient) {
                    return ingredient.is(MaterialItems.GEL) || ingredient.is(MaterialItems.LIFE_MUSHROOM);
                }

                public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
                    int material;
                    if (!this.isIngredient(ingredient) || !this.isInput(input)) {
                        return ItemStack.EMPTY;
                    }
                    int[] materials = Brewing.getMaterials(input);
                    if (materials.length >= 2) {
                        return ItemStack.EMPTY;
                    }
                    if (ingredient.is(MaterialItems.GEL)) {
                        material = gel;
                    } else if (ingredient.is(MaterialItems.LIFE_MUSHROOM)) {
                        material = life_mushroom;
                    } else {
                        return ItemStack.EMPTY;
                    }
                    if (materials.length == 0) {
                        ItemStack stack = PotionItems.CHAOS_POTION.toStack();
                        Brewing.setMaterials(stack, new int[]{material});
                        return stack;
                    }
                    int first = materials[0];
                    if (first == gel && material == life_mushroom || first == life_mushroom && material == gel) {
                        return PotionItems.LESSER_HEALING_POTION.toStack();
                    }
                    ItemStack stack = PotionItems.CHAOS_POTION.toStack();
                    Brewing.setMaterials(stack, Brewing.append(materials, material));
                    return stack;
                }
            });
            consumer.accept(new IBrewingRecipe(){

                public boolean isInput(ItemStack input) {
                    return input.is(PotionItems.CHAOS_POTION) || input.is(PotionItems.LESSER_HEALING_POTION);
                }

                public boolean isIngredient(ItemStack ingredient) {
                    return ingredient.is(PotionItems.LESSER_HEALING_POTION) || ingredient.is(MaterialItems.GLOWING_MUSHROOM);
                }

                public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
                    int material;
                    if (!this.isIngredient(ingredient) || !this.isInput(input)) {
                        return ItemStack.EMPTY;
                    }
                    int[] materials = Brewing.getMaterials(input);
                    if (materials.length >= 3) {
                        return ItemStack.EMPTY;
                    }
                    if (ingredient.is(PotionItems.LESSER_HEALING_POTION)) {
                        material = lesser_healing_potion;
                    } else if (ingredient.is(MaterialItems.GLOWING_MUSHROOM)) {
                        material = glowing_mushroom;
                    } else {
                        return ItemStack.EMPTY;
                    }
                    if (materials.length == 0) {
                        ItemStack stack = PotionItems.CHAOS_POTION.toStack();
                        Brewing.setMaterials(stack, new int[]{material});
                        return stack;
                    }
                    materials = Brewing.append(materials, material);
                    boolean l = false;
                    boolean g = false;
                    for (int m : materials) {
                        if (m == lesser_healing_potion) {
                            l = true;
                            continue;
                        }
                        if (m != glowing_mushroom) continue;
                        g = true;
                    }
                    if (l && g) {
                        return PotionItems.HEALING_POTION.toStack();
                    }
                    ItemStack stack = PotionItems.CHAOS_POTION.toStack();
                    Brewing.setMaterials(stack, materials);
                    return stack;
                }
            });
            consumer.accept(new IBrewingRecipe(){

                public boolean isInput(ItemStack input) {
                    return input.is(PotionItems.CHAOS_POTION) || input.is(PotionItems.LESSER_MANA_POTION);
                }

                public boolean isIngredient(ItemStack ingredient) {
                    return ingredient.is(PotionItems.LESSER_MANA_POTION) || ingredient.is(MaterialItems.GLOWING_MUSHROOM);
                }

                public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
                    int material;
                    if (!this.isIngredient(ingredient) || !this.isInput(input)) {
                        return ItemStack.EMPTY;
                    }
                    int[] materials = Brewing.getMaterials(input);
                    if (materials.length >= 3) {
                        return ItemStack.EMPTY;
                    }
                    if (ingredient.is(PotionItems.LESSER_MANA_POTION)) {
                        material = lesser_mana_potion;
                    } else if (ingredient.is(MaterialItems.GLOWING_MUSHROOM)) {
                        material = glowing_mushroom;
                    } else {
                        return ItemStack.EMPTY;
                    }
                    if (materials.length == 0) {
                        ItemStack stack = PotionItems.CHAOS_POTION.toStack();
                        Brewing.setMaterials(stack, new int[]{material});
                        return stack;
                    }
                    materials = Brewing.append(materials, material);
                    boolean l = false;
                    boolean g = false;
                    for (int m : materials) {
                        if (m == lesser_mana_potion) {
                            l = true;
                            continue;
                        }
                        if (m != glowing_mushroom) continue;
                        g = true;
                    }
                    if (l && g) {
                        return PotionItems.MANA_POTION.toStack();
                    }
                    ItemStack stack = PotionItems.CHAOS_POTION.toStack();
                    Brewing.setMaterials(stack, materials);
                    return stack;
                }
            });
        }

        private static int[] append(int[] a, int addition) {
            int length = a.length;
            int[] materials = IntArrays.forceCapacity((int[])a, (int)(length + 1), (int)length);
            materials[length] = addition;
            return materials;
        }

        public static void addMaterials(ItemStack potion, Item ... materials) {
            LibUtils.updateItemStackNbt((ItemStack)potion, tag -> {
                int[] ids = tag.getIntArray("confluence:potion_materials");
                for (Item material : materials) {
                    int id = MATERIAL_ID_MAP.getOrDefault((Object)material, -1);
                    if (id == -1) continue;
                    ids = Brewing.append(ids, id);
                }
                Arrays.sort(ids);
                tag.putIntArray("confluence:potion_materials", ids);
            });
        }

        public static void setMaterials(ItemStack potion, Item[] materials) {
            LibUtils.updateItemStackNbt((ItemStack)potion, tag -> {
                int[] ids = Arrays.stream(materials).mapToInt(material -> MATERIAL_ID_MAP.getOrDefault(material, -1)).filter(id -> id != -1).toArray();
                Arrays.sort(ids);
                tag.putIntArray("confluence:potion_materials", ids);
            });
        }

        public static void setMaterials(ItemStack potion, int[] materials) {
            Arrays.sort(materials);
            LibUtils.updateItemStackNbt((ItemStack)potion, tag -> tag.putIntArray("confluence:potion_materials", materials));
        }

        public static int[] getMaterials(ItemStack potion) {
            CompoundTag tag = LibUtils.getItemStackNbtIfPresent((ItemStack)potion);
            if (tag == null) {
                return new int[0];
            }
            return tag.getIntArray("confluence:potion_materials");
        }
    }
}

