/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.init.item;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.natural.JungleHiveBlock;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.ArmorItems;
import org.confluence.mod.common.init.item.ArrowItems;
import org.confluence.mod.common.init.item.AxeItems;
import org.confluence.mod.common.init.item.BaitItems;
import org.confluence.mod.common.init.item.BoatItems;
import org.confluence.mod.common.init.item.BowItems;
import org.confluence.mod.common.init.item.ChainsawItems;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.mod.common.init.item.CrossbowItems;
import org.confluence.mod.common.init.item.DrillItems;
import org.confluence.mod.common.init.item.FishingPoleItems;
import org.confluence.mod.common.init.item.FlailItems;
import org.confluence.mod.common.init.item.FoodItems;
import org.confluence.mod.common.init.item.GunItems;
import org.confluence.mod.common.init.item.HamaxeItems;
import org.confluence.mod.common.init.item.HammerItems;
import org.confluence.mod.common.init.item.HoeItems;
import org.confluence.mod.common.init.item.HoeShovelItems;
import org.confluence.mod.common.init.item.HookItems;
import org.confluence.mod.common.init.item.IconItems;
import org.confluence.mod.common.init.item.LanceItems;
import org.confluence.mod.common.init.item.LightPetItems;
import org.confluence.mod.common.init.item.ManaWeaponItems;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.init.item.MinecartItems;
import org.confluence.mod.common.init.item.PaintItems;
import org.confluence.mod.common.init.item.PickaxeAxeItems;
import org.confluence.mod.common.init.item.PickaxeItems;
import org.confluence.mod.common.init.item.PotionItems;
import org.confluence.mod.common.init.item.QuestedFishes;
import org.confluence.mod.common.init.item.ShovelItems;
import org.confluence.mod.common.init.item.SpearItems;
import org.confluence.mod.common.init.item.SwordItems;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.init.item.TreasureBagItems;
import org.confluence.mod.common.init.item.VanityArmorItems;
import org.confluence.mod.common.item.GroupItem;
import org.confluence.mod.common.item.common.BestiaryItem;
import org.confluence.mod.common.item.common.BlockPlacingWandItem;
import org.confluence.mod.common.item.common.CoinItem;
import org.confluence.mod.common.item.common.EntityDisplayItem;
import org.confluence.mod.common.item.common.GrassSeedItem;
import org.confluence.mod.common.item.common.HardmodeConvertorItem;
import org.confluence.mod.common.item.sponsor.BoredomsPactFallingResolve;
import org.confluence.mod.common.item.sponsor.FailedSkullItem;
import org.confluence.mod.common.item.sponsor.IceTofuBrickItem;
import org.confluence.mod.common.item.sponsor.KindMisideRingItem;
import org.confluence.mod.common.item.sponsor.ParadoxInteractiveMedal;
import org.confluence.mod.integration.sodium.iris.IrisHelper;
import org.confluence.mod.util.DateUtils;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.jetbrains.annotations.NotNull;

public final class ModItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredRegister.Items HIDDEN = DeferredRegister.createItems((String)"confluence");
    public static final DeferredRegister.Items BLOCK_ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final Unbreakable UNBREAKABLE = new Unbreakable(true);
    public static final ResourceLocation BASE_ATTACK_KNOCKBACK_ID = Confluence.asResource("base_attack_knockback");
    public static final ResourceLocation BASE_CRITICAL_CHANCE_ID = Confluence.asResource("base_critical_chance");
    public static final ResourceLocation BASE_BLOCK_INTERACTION_RANGE_ID = Confluence.asResource("base_block_interaction_range");
    public static final ResourceLocation BASE_ENTITY_INTERACTION_RANGE_ID = Confluence.asResource("base_entity_interaction_range");
    public static final DeferredItem<Item> STAR = HIDDEN.register("star", () -> new CustomRarityItem(new Item.Properties().stacksTo(9999), ModRarity.MASTER));
    public static final DeferredItem<Item> SOUL_CAKE = HIDDEN.register("soul_cake", () -> new CustomRarityItem(new Item.Properties().stacksTo(9999), ModRarity.MASTER));
    public static final DeferredItem<Item> SUGAR_PLUM = HIDDEN.register("sugar_plum", () -> new CustomRarityItem(new Item.Properties().stacksTo(9999), ModRarity.MASTER));
    public static final DeferredItem<Item> HEART = HIDDEN.register("heart", () -> new CustomRarityItem(new Item.Properties().stacksTo(9999), ModRarity.MASTER));
    public static final DeferredItem<Item> CANDY_APPLE = HIDDEN.register("candy_apple", () -> new CustomRarityItem(new Item.Properties().stacksTo(9999), ModRarity.MASTER));
    public static final DeferredItem<Item> CANDY_CANE = HIDDEN.register("candy_cane", () -> new CustomRarityItem(new Item.Properties().stacksTo(9999), ModRarity.MASTER));
    public static final DeferredItem<EntityDisplayItem> ENTITY_DISPLAY = HIDDEN.register("entity_display", EntityDisplayItem::new);
    public static final DeferredItem<HardmodeConvertorItem> HARDMODE_CONVERTOR = HIDDEN.register("hardmode_convertor", HardmodeConvertorItem::new);
    public static final DeferredItem<BoredomsPactFallingResolve> BOREDOMS_PACT_FALLING_RESOLVE = HIDDEN.register(BoredomsPactFallingResolve.ID.getPath(), BoredomsPactFallingResolve::new);
    public static final DeferredItem<ParadoxInteractiveMedal> PARADOX_INTERACTIVE_MEDAL = HIDDEN.register("paradox_interactive_medal", ParadoxInteractiveMedal::new);
    public static final DeferredItem<TooltipItem> TOKYO_TEDDY_BEAR = HIDDEN.register("tokyo_teddy_bear", () -> new TooltipItem(new Item.Properties(), ModRarity.MASTER, TooltipItem.getTooltipsFromString((String)"tokyo_teddy_bear", (int)6, (ChatFormatting)ChatFormatting.GRAY)));
    public static final DeferredItem<IceTofuBrickItem> ICE_TOFU_BRICK = HIDDEN.register("ice_tofu_brick", IceTofuBrickItem::new);
    public static final DeferredItem<FailedSkullItem> FAILED_SKULL = HIDDEN.register("failed_skull", FailedSkullItem::new);
    public static final DeferredItem<KindMisideRingItem> KIND_MISIDE_RING = HIDDEN.register("kind_miside_ring", KindMisideRingItem::new);
    public static final DeferredItem<KindMisideRingItem> FERTILE_SINGULARITY = HIDDEN.register("fertile_singularity", KindMisideRingItem::new);
    public static final DeferredItem<KindMisideRingItem> PERPLEXED_CAT_MEDAL = HIDDEN.register("perplexed_cat_medal", KindMisideRingItem::new);
    public static final DeferredItem<KindMisideRingItem> PULSAR = HIDDEN.register("pulsar", KindMisideRingItem::new);
    public static final DeferredItem<Item> MYSTERIOUS_NOTE = HIDDEN.register("mysterious_note", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MYSTERIOUS_SLATE = HIDDEN.register("mysterious_slate", () -> new Item(new Item.Properties()));
    public static final DeferredItem<BestiaryItem> BESTIARY = HIDDEN.register("bestiary", BestiaryItem::new);
    public static final DeferredItem<GroupItem> GROUP = HIDDEN.register("group", GroupItem::new);
    public static final DeferredItem<CoinItem> COPPER_COIN = ITEMS.register("copper_coin", () -> new CoinItem((Block)ModBlocks.COPPER_COIN.get(), ModRarity.WHITE, (Supplier<CoinItem>)SILVER_COIN, 100));
    public static final DeferredItem<CoinItem> SILVER_COIN = ITEMS.register("silver_coin", () -> new CoinItem((Block)ModBlocks.SILVER_COIN.get(), ModRarity.ORANGE, (Supplier<CoinItem>)GOLD_COIN, 100));
    public static final DeferredItem<CoinItem> GOLD_COIN = ITEMS.register("gold_coin", () -> new CoinItem((Block)ModBlocks.GOLD_COIN.get(), ModRarity.LIGHT_PURPLE, (Supplier<CoinItem>)PLATINUM_COIN, 100));
    public static final DeferredItem<CoinItem> PLATINUM_COIN = ITEMS.register("platinum_coin", () -> new CoinItem((Block)ModBlocks.PLATINUM_COIN.get(), ModRarity.CYAN, null, 9999));
    public static final DeferredItem<Item> EMERALD_COIN = ITEMS.register("emerald_coin", () -> new BlockItem((Block)ModBlocks.EMERALD_COIN.get(), new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.PURPLE).stacksTo(9999)));
    public static final DeferredItem<Item> WHOOPIE_CUSHION = ITEMS.registerSimpleItem("whoopie_cushion", new Item.Properties().stacksTo(1));
    public static final DeferredItem<GrassSeedItem> GRASS_SEED = ITEMS.register("grass_seed", () -> new GrassSeedItem(Map.of(Blocks.DIRT, Blocks.GRASS_BLOCK, (Block)NatureBlocks.CRIMSON_GRASS_BLOCK.get(), Blocks.GRASS_BLOCK, (Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get(), Blocks.GRASS_BLOCK, (Block)NatureBlocks.HALLOW_GRASS_BLOCK.get(), Blocks.GRASS_BLOCK)));
    public static final DeferredItem<GrassSeedItem> JUNGLE_GRASS_SEED = ITEMS.register("jungle_grass_seed", () -> new GrassSeedItem(Map.of(Blocks.MUD, (Block)NatureBlocks.JUNGLE_GRASS_BLOCK.get())));
    public static final DeferredItem<GrassSeedItem> MUSHROOM_GRASS_SEED = ITEMS.register("mushroom_grass_seed", () -> new GrassSeedItem(Map.of(Blocks.MUD, (Block)NatureBlocks.MUSHROOM_GRASS_BLOCK.get())));
    public static final DeferredItem<GrassSeedItem> CORRUPT_SEED = ITEMS.register("corrupt_seed", () -> new GrassSeedItem(Map.of(Blocks.MUD, (Block)NatureBlocks.CORRUPT_JUNGLE_GRASS_BLOCK.get(), Blocks.DIRT, (Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get(), Blocks.GRASS_BLOCK, (Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get(), (Block)NatureBlocks.CRIMSON_GRASS_BLOCK.get(), (Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get(), (Block)NatureBlocks.HALLOW_GRASS_BLOCK.get(), (Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get())));
    public static final DeferredItem<GrassSeedItem> CRIMSON_SEED = ITEMS.register("crimson_seed", () -> new GrassSeedItem(Map.of(Blocks.MUD, (Block)NatureBlocks.CRIMSON_JUNGLE_GRASS_BLOCK.get(), Blocks.DIRT, (Block)NatureBlocks.CRIMSON_GRASS_BLOCK.get(), Blocks.GRASS_BLOCK, (Block)NatureBlocks.CRIMSON_GRASS_BLOCK.get(), (Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get(), (Block)NatureBlocks.CRIMSON_GRASS_BLOCK.get(), (Block)NatureBlocks.HALLOW_GRASS_BLOCK.get(), (Block)NatureBlocks.CRIMSON_GRASS_BLOCK.get())));
    public static final DeferredItem<GrassSeedItem> HALLOWED_SEED = ITEMS.register("hallowed_seed", () -> new GrassSeedItem(Map.of(Blocks.MUD, (Block)NatureBlocks.HALLOW_GRASS_BLOCK.get(), Blocks.DIRT, (Block)NatureBlocks.HALLOW_GRASS_BLOCK.get(), Blocks.GRASS_BLOCK, (Block)NatureBlocks.HALLOW_GRASS_BLOCK.get(), (Block)NatureBlocks.CRIMSON_GRASS_BLOCK.get(), (Block)NatureBlocks.HALLOW_GRASS_BLOCK.get(), (Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get(), (Block)NatureBlocks.HALLOW_GRASS_BLOCK.get())));
    public static final DeferredItem<GrassSeedItem> ASH_GRASS_SEED = ITEMS.register("ash_grass_seed", () -> new GrassSeedItem(Map.of((Block)NatureBlocks.ASH_BLOCK.get(), (Block)NatureBlocks.ASH_GRASS_BLOCK.get())));
    public static final DeferredItem<BlockItem> CATTAIL = BLOCK_ITEMS.register("cattail", () -> new BlockItem((Block)NatureBlocks.CATTAIL_BLOCK.get(), new Item.Properties().stacksTo(64)));
    public static final DeferredItem<BlockItem> JUNGLE_CATTAIL = BLOCK_ITEMS.register("jungle_cattail", () -> new BlockItem((Block)NatureBlocks.JUNGLE_CATTAIL_BLOCK.get(), new Item.Properties().stacksTo(64)));
    public static final DeferredItem<BlockItem> GLOWING_MUSHROOM_CATTAIL = BLOCK_ITEMS.register("glowing_mushroom_cattail", () -> new BlockItem((Block)NatureBlocks.GLOWING_MUSHROOM_CATTAIL_BLOCK.get(), new Item.Properties().stacksTo(64)));
    public static final DeferredItem<BlockItem> HALLOW_CATTAIL = BLOCK_ITEMS.register("hallow_cattail", () -> new BlockItem((Block)NatureBlocks.HALLOW_CATTAIL_BLOCK.get(), new Item.Properties().stacksTo(64)));
    public static final DeferredItem<BlockItem> EBONY_CATTAIL = BLOCK_ITEMS.register("ebony_cattail", () -> new BlockItem((Block)NatureBlocks.EBONY_CATTAIL_BLOCK.get(), new Item.Properties().stacksTo(64)));
    public static final DeferredItem<BlockItem> CRIMSON_CATTAIL = BLOCK_ITEMS.register("crimson_cattail", () -> new BlockItem((Block)NatureBlocks.CRIMSON_CATTAIL_BLOCK.get(), new Item.Properties().stacksTo(64)));
    public static final DeferredItem<BlockPlacingWandItem> LIVING_WOOD_WAND = ITEMS.register("living_wood_wand", () -> new BlockPlacingWandItem((TagKey<Block>)BlockTags.LOGS, (Block)NatureBlocks.LIVING_LOG_BLOCKS.LOG.get()));
    public static final DeferredItem<BlockPlacingWandItem> LEAF_WAND = ITEMS.register("leaf_wand", () -> new BlockPlacingWandItem((TagKey<Block>)BlockTags.LEAVES, (Block)NatureBlocks.LIVING_LOG_BLOCKS.LEAVES.get()));
    public static final DeferredItem<BlockPlacingWandItem> LIVING_MAHOGANY_WAND = ITEMS.register("living_mahogany_wand", () -> new BlockPlacingWandItem((TagKey<Block>)BlockTags.LOGS, (Block)NatureBlocks.LIVING_MAHOGANY_LOG_BLOCKS.LOG.get()));
    public static final DeferredItem<BlockPlacingWandItem> RICH_MAHOGANY_LEAF_WAND = ITEMS.register("rich_mahogany_leaf_wand", () -> new BlockPlacingWandItem((TagKey<Block>)BlockTags.LEAVES, (Block)NatureBlocks.LIVING_MAHOGANY_LOG_BLOCKS.LEAVES.get()));
    public static final DeferredItem<BlockPlacingWandItem> HIVE_WAND = ITEMS.register("hive_wand", () -> new BlockPlacingWandItem(null, (Block)NatureBlocks.JUNGLE_HIVE_BLOCK.get(), (context, state) -> (BlockState)state.setValue((Property)JungleHiveBlock.NATURAL, (Comparable)Boolean.valueOf(true))));
    public static final DeferredItem<Item> HUANG_LI = HIDDEN.register("huang_li", () -> new Item(new Item.Properties()){

        public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
            if (level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)("\u4eca\u65e5\u5b9c\uff1a" + DateUtils.getYi())).withStyle(ChatFormatting.GOLD), false);
                player.displayClientMessage((Component)Component.literal((String)("\u4eca\u65e5\u5fcc\uff1a" + DateUtils.getJi())).withStyle(ChatFormatting.GRAY), false);
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
    });

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
        HIDDEN.register(eventBus);
        BLOCK_ITEMS.register(eventBus);
        AccessoryItems.ITEMS.register(eventBus);
        ArmorItems.register(eventBus);
        ArrowItems.ITEMS.register(eventBus);
        AxeItems.ITEMS.register(eventBus);
        BaitItems.ITEMS.register(eventBus);
        BoatItems.register(eventBus);
        BowItems.ITEMS.register(eventBus);
        ChainsawItems.ITEMS.register(eventBus);
        ConsumableItems.ITEMS.register(eventBus);
        CrossbowItems.ITEMS.register(eventBus);
        DrillItems.ITEMS.register(eventBus);
        FishingPoleItems.ITEMS.register(eventBus);
        FlailItems.ITEMS.register(eventBus);
        FoodItems.ITEMS.register(eventBus);
        GunItems.ITEMS.register(eventBus);
        HamaxeItems.ITEMS.register(eventBus);
        HammerItems.ITEMS.register(eventBus);
        HoeItems.ITEMS.register(eventBus);
        HoeShovelItems.ITEMS.register(eventBus);
        HookItems.ITEMS.register(eventBus);
        IconItems.ITEMS.register(eventBus);
        LanceItems.ITEMS.register(eventBus);
        LightPetItems.ITEMS.register(eventBus);
        ManaWeaponItems.ITEMS.register(eventBus);
        MaterialItems.ITEMS.register(eventBus);
        MinecartItems.ITEMS.register(eventBus);
        PaintItems.ITEMS.register(eventBus);
        PickaxeAxeItems.ITEMS.register(eventBus);
        PickaxeItems.ITEMS.register(eventBus);
        PotionItems.ITEMS.register(eventBus);
        QuestedFishes.ITEMS.register(eventBus);
        ShovelItems.ITEMS.register(eventBus);
        SpearItems.ITEMS.register(eventBus);
        SwordItems.ITEMS.register(eventBus);
        ToolItems.ITEMS.register(eventBus);
        TreasureBagItems.ITEMS.register(eventBus);
        VanityArmorItems.ITEMS.register(eventBus);
        if (LoadingModList.get().getModFileById("iris") != null) {
            IrisHelper.register(HIDDEN);
        }
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.Properties unbreakable() {
        return new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)UNBREAKABLE);
    }

    public static Consumer<ItemAttributeModifiers.Builder> attributes(double blockInteractionRange, double attackKnockback) {
        return builder -> {
            if (blockInteractionRange != 0.0) {
                builder.add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(BASE_BLOCK_INTERACTION_RANGE_ID, blockInteractionRange, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
            if (attackKnockback != 0.0) {
                builder.add(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(BASE_ATTACK_KNOCKBACK_ID, attackKnockback, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            }
            builder.add(TCAttributes.getCriticalChance(), new AttributeModifier(BASE_CRITICAL_CHANCE_ID, 0.04, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        };
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, float attackDamage, float attackSpeed, Consumer<ItemAttributeModifiers.Builder> consumer) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        consumer.accept(builder);
        return builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(attackDamage + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }
}

