/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.mixed.IClientItemStack;

public class GroupItem
extends Item {
    public static boolean enable = false;
    private static GroupItem instance;

    public GroupItem() {
        super(new Item.Properties().stacksTo(1));
        if (instance != null) {
            throw new UnsupportedOperationException("Group Item must be singleton instance");
        }
        instance = this;
    }

    public static GroupItem getInstance() {
        return instance;
    }

    public static ItemStack of(Component name, ItemStack ... stacks) {
        return GroupItem.of(name, Arrays.asList(stacks));
    }

    public static ItemStack of(Component name, List<ItemStack> stacks) {
        ItemStack itemStack = instance.getDefaultInstance();
        itemStack.set(ModDataComponentTypes.GROUP_STACKS, (Object)Stacks.of(false, stacks));
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)name);
        return itemStack;
    }

    public static void toggleVisibility(ItemStack group) {
        Stacks stacks = (Stacks)group.get(ModDataComponentTypes.GROUP_STACKS);
        if (stacks == null) {
            throw new NullPointerException("Stacks must non-null!");
        }
        group.set(ModDataComponentTypes.GROUP_STACKS, (Object)stacks.toggleVisibility());
    }

    public static class Stacks
    implements DataComponentType<Stacks> {
        public static final Stacks EMPTY = new Stacks(false, List.of());
        public static final Codec<Stacks> CODEC = Codec.unit((Object)EMPTY);
        public static final StreamCodec<ByteBuf, Stacks> STREAM_CODEC = StreamCodec.unit((Object)EMPTY);
        private static final AtomicInteger cachedId = new AtomicInteger();
        public transient long lastRenderTime;
        public transient int lastRenderIndex;
        public transient int id = -1;
        private final boolean visible;
        private final List<ItemStack> values;

        private Stacks(boolean visible, List<ItemStack> values) {
            this.visible = visible;
            this.values = values;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public List<ItemStack> getValues() {
            return this.values;
        }

        public Codec<Stacks> codec() {
            return CODEC;
        }

        public StreamCodec<ByteBuf, Stacks> streamCodec() {
            return STREAM_CODEC;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(Object o) {
            if (o == this) return true;
            if (!(o instanceof Stacks)) return false;
            Stacks stacks = (Stacks)o;
            if (stacks.visible != this.visible) return false;
            if (stacks.id != this.id) return false;
            if (!stacks.values.equals(this.values)) return false;
            return true;
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.visible);
            result = 31 * result + this.id;
            result = 31 * result + this.values.hashCode();
            return result;
        }

        public String toString() {
            return "Stacks{visible=" + this.visible + ", values=" + String.valueOf(this.values) + "}";
        }

        public Stacks toggleVisibility() {
            Stacks stacks = new Stacks(!this.visible, this.values);
            stacks.lastRenderTime = this.lastRenderTime;
            stacks.lastRenderIndex = this.lastRenderIndex;
            stacks.id = this.id;
            return stacks;
        }

        public static Stacks of(boolean visible, ItemStack ... stacks) {
            return Stacks.of(visible, Arrays.asList(stacks));
        }

        public static Stacks of(boolean visible, List<ItemStack> stacks) {
            int id = cachedId.getAndIncrement();
            Set set = ItemStackLinkedSet.createTypeAndComponentsSet();
            for (ItemStack stack : stacks) {
                if (LibUtils.isPhysicalClient()) {
                    IClientItemStack.of(stack).confluence$setGroupId(id);
                }
                set.add(stack);
            }
            Stacks stacks1 = new Stacks(visible, Lists.newArrayList((Iterable)set));
            stacks1.id = id;
            return stacks1;
        }
    }

    public static class DisplayItems
    implements Collection<ItemStack> {
        private final Collection<ItemStack> delegate;

        public DisplayItems(Collection<ItemStack> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<ItemStack> iterator() {
            final Iterator<ItemStack> unfiltered = this.delegate.iterator();
            return new AbstractIterator<ItemStack>(this){
                int index = 0;
                List<ItemStack> values = List.of();

                @CheckForNull
                protected ItemStack computeNext() {
                    if (this.index < this.values.size()) {
                        return this.values.get(this.index++);
                    }
                    if (unfiltered.hasNext()) {
                        ItemStack element = (ItemStack)unfiltered.next();
                        if (element.is((Item)instance)) {
                            this.index = 0;
                            Stacks stacks = (Stacks)element.getOrDefault(ModDataComponentTypes.GROUP_STACKS, (Object)Stacks.EMPTY);
                            this.values = stacks.visible ? stacks.values : List.of();
                            return element;
                        }
                        return element;
                    }
                    return (ItemStack)this.endOfData();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            return this.delegate.toArray(ts);
        }

        @Override
        public boolean add(ItemStack e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.delegate.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends ItemStack> collection) {
            return this.delegate.addAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.delegate.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.delegate.retainAll(collection);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }
    }
}

