/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.accessory;

import com.google.common.collect.Streams;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terraentity.entity.boss.wallofflesh.WallOfFlesh;
import org.confluence.terraentity.init.TESounds;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class GuideVooDooDollItem
extends BaseCurioItem {
    public static final String IS_WALL_KEY = "IsWall";
    public static final String DIRECTION_KEY = "Direction";

    public GuideVooDooDollItem(String name) {
        super(GuideVooDooDollItem.builder((String)name).tooltips(1).rarity(ModRarity.WHITE));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (!level.isClientSide) {
            LibUtils.updateItemStackNbt((ItemStack)stack, tag -> tag.putBoolean(IS_WALL_KEY, !GuideVooDooDollItem.isWall(tag)));
        }
        return stack;
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        Level level;
        if (damageSource.is(DamageTypes.LAVA) && (level = itemEntity.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (level2.dimension() != OverworldUtils.underworld()) {
                level2.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"message.confluence.guide_voo_doo_doll.fail").withStyle(ChatFormatting.RED), false);
                return;
            }
            CompoundTag tag = LibUtils.getItemStackNbtNoCopy((ItemStack)itemEntity.getItem());
            GuideVooDooDollItem.summon((Entity)itemEntity, level2, GuideVooDooDollItem.isWall(tag), () -> tag.contains(DIRECTION_KEY) ? Direction.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(DIRECTION_KEY)).result().orElse(Direction.WEST) : null);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (GuideVooDooDollItem.isWall(LibUtils.getItemStackNbtIfPresent((ItemStack)stack))) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.wall.0").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.wall.1").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.wall.2").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.wall.3").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.wall.4").withStyle(ChatFormatting.DARK_RED));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.hill.0").withStyle(ChatFormatting.DARK_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.hill.1").withStyle(ChatFormatting.DARK_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.hill.2").withStyle(ChatFormatting.DARK_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.hill.3").withStyle(ChatFormatting.DARK_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.guide_voodoo_doll.hill.4").withStyle(ChatFormatting.DARK_PURPLE));
        }
    }

    public static boolean isWall(@Nullable CompoundTag tag) {
        return tag == null || !tag.contains(IS_WALL_KEY) || tag.getBoolean(IS_WALL_KEY);
    }

    public static void summon(Entity entity, ServerLevel level, boolean isWall, Supplier<@Nullable Direction> forward) {
        EntityType wof = (EntityType)TEBossEntities.WALL_OF_FLESH.get();
        EntityType hof = (EntityType)TEBossEntities.HILL_OF_FLESH.get();
        if (Streams.stream((Iterable)level.getAllEntities()).anyMatch(entity1 -> {
            EntityType type = entity1.getType();
            return type == wof || type == hof;
        })) {
            return;
        }
        BlockPos blockPos = entity.blockPosition();
        if (isWall) {
            WallOfFlesh wallOfFlesh;
            Direction direction = forward.get();
            if (direction == null) {
                int x = blockPos.getX();
                int z = blockPos.getZ();
                if (Math.abs(x) >= Math.abs(z)) {
                    negative = x < 0;
                    for (ServerPlayer player : level.players()) {
                        int px = player.blockPosition().getX();
                        if (!negative) continue;
                        if (px < x) {
                            x = px;
                            continue;
                        }
                        if (px <= x) continue;
                        x = px;
                    }
                    direction = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(negative ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
                } else {
                    negative = z < 0;
                    for (ServerPlayer player : level.players()) {
                        int pz = player.blockPosition().getZ();
                        if (!negative) continue;
                        if (pz < z) {
                            z = pz;
                            continue;
                        }
                        if (pz <= x) continue;
                        x = pz;
                    }
                    direction = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(negative ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
                }
            }
            if ((wallOfFlesh = (WallOfFlesh)wof.spawn(level, blockPos.relative(direction, 64), MobSpawnType.MOB_SUMMONED)) != null) {
                wallOfFlesh.setForward(direction);
            }
        } else {
            hof.spawn(level, blockPos, MobSpawnType.MOB_SUMMONED);
        }
        for (ServerPlayer player : level.getServer().getPlayerList().getPlayers()) {
            player.connection.send((Packet)new ClientboundSoundPacket((Holder)TESounds.WALL_OF_FLESH_ROAR, SoundSource.HOSTILE, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, 0L));
        }
    }

    public static void setForward(Player player, ItemStack itemStack) {
        Tag nbt = Direction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)player.getDirection()).result().orElseGet(CompoundTag::new);
        LibUtils.updateItemStackNbt((ItemStack)itemStack, tag -> tag.put(DIRECTION_KEY, nbt));
    }
}

