/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.armor;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.renderer.item.MultiHeadArmorItemRenderer;
import org.confluence.mod.client.renderer.item.NormalArmorItemRenderer;
import org.confluence.mod.common.item.armor.NormalGeoArmorItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;

public class MultiHeadGeoArmorItem
extends NormalGeoArmorItem {
    private static final Map<String, MultiHeadGeoArmorItem[]> headMap = new HashMap<String, MultiHeadGeoArmorItem[]>();

    public MultiHeadGeoArmorItem(String name, ModRarity rarity, Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(name, rarity, material, type, properties);
        if (type == ArmorItem.Type.HELMET && LibUtils.isPhysicalClient()) {
            MultiHeadGeoArmorItem[] original = headMap.computeIfAbsent(name, k -> new MultiHeadGeoArmorItem[3]);
            int length = original.length;
            for (int i = 0; i < length; ++i) {
                if (original[i] == null) {
                    original[i] = this;
                    break;
                }
                if (i != length - 1) continue;
                MultiHeadGeoArmorItem[] copy = new MultiHeadGeoArmorItem[length + 1];
                System.arraycopy(original, 0, copy, 0, length);
                copy[length] = this;
                headMap.put(name, copy);
                break;
            }
        }
    }

    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private NormalArmorItemRenderer<NormalGeoArmorItem> renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    MultiHeadGeoArmorItem[] items = headMap.get(MultiHeadGeoArmorItem.this.name);
                    this.renderer = items == null || Minecraft.getInstance().getResourceManager().getResource(Confluence.asResource("textures/item/" + MultiHeadGeoArmorItem.this.name + ".png")).isEmpty() ? new NormalArmorItemRenderer("armor/cactus_armor") : new MultiHeadArmorItemRenderer(MultiHeadGeoArmorItem.this.name, (Item[])items);
                }
                return this.renderer;
            }
        });
    }
}

