/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.axe;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.tooltipcomponent.AltImageComponent;
import org.confluence.mod.util.ModUtils;
import org.jetbrains.annotations.Nullable;

public class BaseAxeItem
extends AxeItem {
    @Nullable
    private TooltipComponent component;
    private boolean hasImage;

    public BaseAxeItem(Tier tier, float rawDamage, float rawSpeed, ModRarity rarity) {
        this(tier, rawDamage, rawSpeed, new Item.Properties(), rarity);
    }

    public BaseAxeItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, ModRarity rarity) {
        super(tier, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)BaseAxeItem.createAttributes((Tier)tier, (float)(rawDamage - tier.getAttackDamageBonus() - 1.0f), (float)(rawSpeed - 4.0f))));
    }

    public BaseAxeItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, Consumer<ItemAttributeModifiers.Builder> consumer, ModRarity rarity) {
        super(tier, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ModItems.createAttributes(tier, rawDamage - tier.getAttackDamageBonus() - 1.0f, rawSpeed - 4.0f, consumer)));
    }

    public BaseAxeItem hasImage() {
        this.hasImage = true;
        return this;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null && this.hasImage) {
            this.component = AltImageComponent.of(stack.getItem());
        }
        return Optional.ofNullable(this.component);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }
}

