/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.axe;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.data.LucyTheAxeDialogCategory;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.axe.BaseAxeItem;
import org.confluence.mod.network.s2c.LucyTheAxeDialogPacketS2C;

public class LucyTheAxe
extends BaseAxeItem {
    public LucyTheAxe() {
        super((Tier)Tiers.IRON, 11.0f, 4.0f, ModItems.unbreakable(), ModItems.attributes(0.0, 0.5), ModRarity.GREEN);
    }

    public static void onDestroyBlock(ServerPlayer serverPlayer, BlockState state) {
        if (state.is(BlockTags.LOGS)) {
            LucyTheAxeDialogPacketS2C.checkAndBroadcast(serverPlayer, LucyTheAxeDialogCategory.CUTTING_DOWN_A_TREE);
        } else if (state.is(NatureBlocks.STONY_LOG)) {
            LucyTheAxeDialogPacketS2C.checkAndBroadcast(serverPlayer, LucyTheAxeDialogCategory.CUTTING_DOWN_A_GEM_TREE);
        } else if (state.is(ModTags.Blocks.CACTUS)) {
            LucyTheAxeDialogPacketS2C.checkAndBroadcast(serverPlayer, LucyTheAxeDialogCategory.CUTTING_DOWN_A_CACTUS);
        } else {
            LucyTheAxeDialogPacketS2C.checkAndBroadcast(serverPlayer, LucyTheAxeDialogCategory.DESTROY_WRONG_BLOCK);
        }
    }

    public static void onDamageLiving(ServerPlayer player, LivingEntity victim) {
        if (victim.isDeadOrDying()) {
            LucyTheAxeDialogPacketS2C.checkAndBroadcast(player, LucyTheAxeDialogCategory.KILL_ENTITY);
        } else {
            LucyTheAxeDialogPacketS2C.checkAndBroadcast(player, LucyTheAxeDialogCategory.ATTACK_ENTITY);
        }
    }

    public static void onToss(ServerPlayer player, ItemStack itemStack) {
        LucyTheAxeDialogPacketS2C.checkAndBroadcast(player, itemStack, LucyTheAxeDialogCategory.THROWN_ON_THE_GROUND);
    }

    public static void onIdle(ServerPlayer player, long gameTime) {
        if (gameTime % 1200L == 0L && player.getRandom().nextInt(5) == 0) {
            NonNullList items = player.getInventory().items;
            for (int i = 0; !(i >= items.size() || Inventory.isHotbarSlot((int)i) && LucyTheAxeDialogPacketS2C.checkAndBroadcast(player, (ItemStack)items.get(i), LucyTheAxeDialogCategory.IDLE)); ++i) {
            }
        }
    }

    public static void onPickup(ServerPlayer player, ItemStack itemStack) {
        LucyTheAxeDialogPacketS2C.checkAndBroadcast(player, itemStack, LucyTheAxeDialogCategory.PLACED_BACK_INTO_THE_INVENTORY);
    }

    public static void onSwap(ServerPlayer source, Slot slot, boolean invert) {
        if (slot.container == source.getInventory() != invert) {
            LucyTheAxeDialogPacketS2C.broadcast(source, LucyTheAxeDialogCategory.PLACED_BACK_INTO_THE_INVENTORY);
        } else {
            LucyTheAxeDialogPacketS2C.broadcast(source, LucyTheAxeDialogCategory.PLACED_IN_OTHER_CONTAINER);
        }
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer source = (ServerPlayer)player;
            LucyTheAxe.onSwap(source, slot, false);
        }
        return false;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(NatureBlocks.STONY_LOG) || super.isCorrectToolForDrops(stack, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.lucy_the_axe.0").withStyle(ChatFormatting.GRAY));
    }
}

