/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.bow;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.confluence.mod.api.ITerraArrowProjectileWeaponItem;
import org.confluence.mod.common.entity.projectile.range.arrow.BaseArrowEntity;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.item.arrow.BaseTerraArrowItem;
import org.confluence.mod.common.item.bow.ShortBowItem;
import org.confluence.mod.common.item.crossbow.BaseTerraRepeaterItem;
import org.confluence.mod.util.ModUtils;
import org.confluence.terraentity.attachment.WeaponStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class BaseTerraBowItem
extends BowItem
implements ITerraArrowProjectileWeaponItem<BaseTerraRepeaterItem> {
    private final float baseDamage;
    private final BaseArrowEntity.Builder arrowModifier;
    private final BaseTerraArrowItem.ModifyArrowBuilder modifyArrowBuilder;

    public BaseTerraBowItem(Item.Properties properties, float baseDamage, BaseTerraArrowItem.ModifyArrowBuilder modifyArrowBuilder) {
        super(modifyArrowBuilder.buildProperties(properties.stacksTo(1)));
        this.baseDamage = baseDamage;
        this.arrowModifier = new BaseArrowEntity.Builder();
        modifyArrowBuilder.modifyArrowBuilder.forEach(m -> m.accept(this.arrowModifier));
        this.modifyArrowBuilder = modifyArrowBuilder;
    }

    public BaseTerraBowItem(float baseDamage, BaseTerraArrowItem.ModifyArrowBuilder modifyArrowBuilder) {
        this(new Item.Properties(), baseDamage, modifyArrowBuilder);
    }

    @Override
    public BaseTerraArrowItem.ModifyArrowBuilder getModifyArrowBuilder() {
        return this.modifyArrowBuilder;
    }

    @Override
    public BaseArrowEntity.Builder getArrowModifier() {
        return this.arrowModifier;
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }

    @NotNull
    public AbstractArrow customArrow(@NotNull AbstractArrow arrow, @NotNull ItemStack projectileStack, @NotNull ItemStack weaponStack) {
        int multiShoot = this.modifyArrowBuilder.multiShoot;
        if (this.modifyArrowBuilder.canMultiShoot.test(projectileStack)) {
            float damage = this.baseDamage / (float)multiShoot;
            arrow.setBaseDamage((double)damage);
        } else {
            arrow.setBaseDamage((double)this.baseDamage);
        }
        return arrow;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        super.releaseUsing(stack, level, entity, timeLeft);
        if (!stack.is(ModTags.Items.FAST_BOW) || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        player.getCooldowns().addCooldown((Item)this, 5);
        ItemStack offHandItem = player.getOffhandItem();
        if (offHandItem.getItem() instanceof BowItem) {
            player.getCooldowns().addCooldown(offHandItem.getItem(), 5);
        }
    }

    protected void shoot(@NotNull ServerLevel level, @NotNull LivingEntity shooter, @NotNull InteractionHand hand, @NotNull ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
        float processProjectileSpread = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        float angleIncrement = projectileItems.size() == 1 ? 0.0f : 2.0f * processProjectileSpread / (float)(projectileItems.size() - 1);
        float initialAngleOffset = (float)((projectileItems.size() - 1) % 2) * angleIncrement / 2.0f;
        float signFactor = 1.0f;
        for (int itemstackIndex = 0; itemstackIndex < projectileItems.size(); ++itemstackIndex) {
            ItemStack itemstack = projectileItems.get(itemstackIndex);
            if (itemstack.isEmpty()) continue;
            float angleY = initialAngleOffset + signFactor * (float)((itemstackIndex + 1) / 2) * angleIncrement;
            signFactor = -signFactor;
            int multiShootCount = !this.modifyArrowBuilder.canMultiShoot.test(itemstack) ? 1 : this.modifyArrowBuilder.multiShoot;
            for (int projectileIndex = 0; projectileIndex < multiShootCount; ++projectileIndex) {
                Projectile projectile = this.createProjectile((Level)level, shooter, weapon, itemstack, isCrit);
                this.shootProjectile(shooter, projectile, itemstackIndex, velocity * 2.0f, inaccuracy + this.modifyArrowBuilder.inaccuracy, angleY, target);
                BaseTerraArrowItem.ModifyArrowBuilder.MultiShootOffsetFunction multiShootOffset = this.modifyArrowBuilder.multiShootOffset;
                if (multiShootOffset != null) {
                    BaseTerraBowItem.transformAndApplyOffsetToProjectile(projectile, multiShootOffset.apply(projectileIndex, multiShootCount));
                }
                BaseTerraBowItem.processArrowBaseEffects(shooter, hand, weapon, projectile, projectileIndex, multiShootCount);
                level.addFreshEntity((Entity)projectile);
            }
            weapon.hurtAndBreak(this.getDurabilityUse(itemstack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (weapon.isEmpty()) break;
        }
    }

    public static void processArrowBaseEffects(@NotNull LivingEntity shooter, @NotNull InteractionHand hand, @NotNull ItemStack weapon, Projectile projectile, int projectileIndex, int multiShootCount) {
        if (!(projectile instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow abstractArrow = (AbstractArrow)projectile;
        if (projectileIndex > 0) {
            abstractArrow.pickup = AbstractArrow.Pickup.DISALLOWED;
        }
        ShortBowItem.applyToArrow(weapon, abstractArrow);
        BaseTerraBowItem.processArrowSpecialEffects(shooter, abstractArrow, multiShootCount);
    }

    public static void processArrowSpecialEffects(@NotNull LivingEntity shooter, AbstractArrow abstractArrow, int multiShootCount) {
        if (!(abstractArrow instanceof BaseArrowEntity)) {
            return;
        }
        BaseArrowEntity terraArrow = (BaseArrowEntity)abstractArrow;
        if (multiShootCount > 1 && (terraArrow.modify.getType() & 4) == 0) {
            terraArrow.modify.setAutoDiscard(100);
        }
        WeaponStorage data = WeaponStorage.of((IAttachmentHolder)shooter);
        if (data.bowFullPull) {
            terraArrow.fullPull = true;
            data.bowFullPull = false;
        }
    }

    public static void transformAndApplyOffsetToProjectile(Projectile projectile, Vec3 offset) {
        Vec3 initDirection = projectile.getDeltaMovement();
        float yaw = (float)(-Math.atan2(initDirection.z, initDirection.x));
        float pitch = (float)Math.atan2(initDirection.y, Math.sqrt(initDirection.x * initDirection.x + initDirection.z * initDirection.z));
        Quaternionf q = new Quaternionf().rotateY(yaw).rotateZ(pitch);
        offset = new Vec3(q.transform(offset.toVector3f()));
        projectile.setPos(projectile.position().add(offset));
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int remainingUseDuration) {
        if (this.arrowModifier.fullPullHitEffects == null) {
            return;
        }
        float f = this.getUseDuration(stack, entity) - remainingUseDuration;
        if (f < 16.0f) {
            WeaponStorage.of((IAttachmentHolder)entity).bowFullPull = false;
            return;
        }
        if (f == 16.0f) {
            WeaponStorage.of((IAttachmentHolder)entity).bowFullPull = true;
            if (level.isClientSide) {
                entity.playSound((SoundEvent)ModSoundEvents.BOW_COOLDOWN_RECOVERY.get());
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        BaseTerraArrowItem.addDamageHoverText(tooltipComponents, this.modifyArrowBuilder, this.baseDamage);
        BaseTerraArrowItem.addHitEffectHoverText(stack, tooltipComponents);
        BaseTerraArrowItem.addFullPullHitEffectHoverText(stack, tooltipComponents);
        BaseTerraArrowItem.addEntityTransformHoverText(tooltipComponents, this.modifyArrowBuilder, this.arrowModifier);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static float getFastBowPowerForTime(int pCharge) {
        float f = (float)pCharge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f * 0.5f + 0.5f;
        f = Math.min(f, 1.0f);
        return f;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }
}

