/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.terra_curio.mixin.client.accessor.MinecraftAccessor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BaseDrillItem
extends PickaxeItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BaseDrillItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, ModRarity rarity) {
        super(tier, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)BaseDrillItem.createAttributes((Tier)tier, (float)(rawDamage - tier.getAttackDamageBonus() - 1.0f), (float)(rawSpeed - 4.0f))));
    }

    public BaseDrillItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, Consumer<ItemAttributeModifiers.Builder> consumer, ModRarity rarity) {
        super(tier, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ModItems.createAttributes(tier, rawDamage - tier.getAttackDamageBonus() - 1.0f, rawSpeed - 4.0f, consumer)));
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (level.isClientSide && LibUtils.isPhysicalClient()) {
            ((MinecraftAccessor)Minecraft.getInstance()).setMissTime(0);
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        RawAnimation work = RawAnimation.begin().thenLoop("work");
        controllers.add(new AnimationController((GeoAnimatable)this, "drill", 0, state -> state.setAndContinue(work)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private GeoItemRenderer<BaseDrillItem> renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GeoItemRenderer((GeoModel)new DefaultedItemGeoModel(BuiltInRegistries.ITEM.getKey((Object)BaseDrillItem.this).withPrefix("drill/")));
                }
                return this.renderer;
            }
        });
    }
}

