/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.mod.api.event.bestiary.ToBeBestiaryEntryEvent;
import org.confluence.mod.common.data.saved.Bestiary;
import org.confluence.mod.common.data.saved.BestiaryEntry;
import org.confluence.mod.network.s2c.BestiarySyncPacketS2C;

public class BestiaryItem
extends CustomRarityItem {
    public BestiaryItem() {
        super(new Item.Properties().stacksTo(1), ModRarity.MASTER);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!level.isClientSide) {
            LivingEntity living;
            Entity entity2;
            AABB aabb;
            double reach = Math.max(player.entityInteractionRange(), player.blockInteractionRange());
            double squared = Mth.square((double)reach);
            Vec3 from = player.getEyePosition(1.0f);
            HitResult hitResult = player.pick(reach, 1.0f, false);
            double sqr = hitResult.getLocation().distanceToSqr(from);
            if (hitResult.getType() != HitResult.Type.MISS) {
                squared = sqr;
                reach = Math.sqrt(sqr);
            }
            Vec3 viewVector = player.getViewVector(1.0f);
            Vec3 to = from.add(viewVector.x * reach, viewVector.y * reach, viewVector.z * reach);
            EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)from, (Vec3)to, (AABB)(aabb = player.getBoundingBox().expandTowards(viewVector.scale(reach)).inflate(1.0)), entity -> !entity.isSpectator() && entity.isPickable(), (double)squared);
            if (entityHitResult != null && entityHitResult.getLocation().distanceToSqr(from) < sqr && (entity2 = entityHitResult.getEntity()) instanceof LivingEntity && !((ToBeBestiaryEntryEvent)NeoForge.EVENT_BUS.post((Event)new ToBeBestiaryEntryEvent(living = (LivingEntity)entity2))).isCanceled()) {
                BestiaryEntry entry = Bestiary.INSTANCE.getOrCreateEntry(living);
                entry.killedByCount += 100;
                BestiarySyncPacketS2C.syncEntry(living, entry);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(usedHand), (boolean)level.isClientSide);
    }
}

