/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.function.Function;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.lib.util.LibUtils;

public class EntityDisplayItem
extends CustomRarityItem {
    public EntityDisplayItem() {
        super(new Item.Properties(), ModRarity.MASTER);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!level.isClientSide) {
            Entity entity;
            ItemStack itemStack = context.getItemInHand();
            CompoundTag tag = LibUtils.getItemStackNbtIfPresent((ItemStack)itemStack);
            if (tag != null && (entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, Function.identity())) != null) {
                entity.setPos(context.getClickLocation());
                Component customName = (Component)itemStack.get(DataComponents.CUSTOM_NAME);
                if (customName != null) {
                    entity.setCustomName(customName);
                }
                level.addFreshEntity(entity);
            }
            itemStack.shrink(1);
            if (itemStack.isEmpty() && context.getPlayer() != null) {
                context.getPlayer().setItemInHand(context.getHand(), ItemStack.EMPTY);
            }
            return InteractionResult.CONSUME_PARTIAL;
        }
        return InteractionResult.PASS;
    }

    public Component getName(ItemStack stack) {
        CompoundTag tag = LibUtils.getItemStackNbtIfPresent((ItemStack)stack);
        if (tag == null) {
            return super.getName(stack);
        }
        return EntityType.by((CompoundTag)tag).orElse(EntityType.PIG).getDescription();
    }
}

