/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class GrassSeedItem
extends Item {
    private final Map<Block, Block> blockMapping;
    private final Map<TagKey<Block>, Block> tagMapping;

    public GrassSeedItem(Map<Block, Block> blockMapping) {
        super(new Item.Properties());
        this.blockMapping = blockMapping;
        this.tagMapping = new HashMap<TagKey<Block>, Block>();
    }

    public GrassSeedItem(Map<Block, Block> blockMapping, Map<TagKey<Block>, Block> tagMapping) {
        super(new Item.Properties());
        this.blockMapping = new HashMap<Block, Block>(blockMapping);
        this.tagMapping = new HashMap<TagKey<Block>, Block>(tagMapping);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        BlockState state = level.getBlockState(pos);
        if (!level.isClientSide) {
            Block currentBlock = state.getBlock();
            Block newBlock = this.blockMapping.get(currentBlock);
            if (newBlock != null) {
                level.setBlockAndUpdate(pos, newBlock.defaultBlockState());
                ItemStack stack = pContext.getItemInHand();
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (!this.tagMapping.isEmpty()) {
                for (Map.Entry<TagKey<Block>, Block> entry : this.tagMapping.entrySet()) {
                    Block tagMappedBlock;
                    if (!state.is(entry.getKey()) || (tagMappedBlock = entry.getValue()) == null) continue;
                    level.setBlockAndUpdate(pos, tagMappedBlock.defaultBlockState());
                    ItemStack stack = pContext.getItemInHand();
                    stack.shrink(1);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }
}

