/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.entity.projectile.SpikyBallProjectile;
import org.confluence.terraentity.init.TESounds;

public class SpikyBallItem
extends Item {
    public SpikyBallItem() {
        super(new Item.Properties().stacksTo(9999));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)TESounds.WAVING.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            SpikyBallProjectile projectile = new SpikyBallProjectile((LivingEntity)player);
            projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.625f, 0.5f);
            level.addFreshEntity((Entity)projectile);
            player.getCooldowns().addCooldown((Item)this, 5);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.hasInfiniteMaterials()) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide);
    }
}

