/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.entity.projectile.ThrowableDropSelfProjectile;
import org.confluence.terraentity.init.TESounds;
import org.jetbrains.annotations.NotNull;

public class ThrowableDropSelfItem
extends Item {
    final EntityType<? extends ThrowableDropSelfProjectile> entityType;
    final boolean dropSelf;
    final float inaccuracy;
    final float power;
    final int cooldown;
    final float damage;
    final int flyTicks;

    public ThrowableDropSelfItem(@NotNull EntityType<? extends ThrowableDropSelfProjectile> entityType, float damage, float power, float inaccuracy, int cooldown, int flyTicks, boolean dropSelf) {
        super(new Item.Properties());
        this.entityType = entityType;
        this.dropSelf = dropSelf;
        this.inaccuracy = inaccuracy;
        this.power = power;
        this.cooldown = cooldown;
        this.damage = damage;
        this.flyTicks = flyTicks;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (!pLevel.isClientSide) {
            pLevel.playSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), (SoundEvent)TESounds.WAVING.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
            ThrowableDropSelfProjectile projectile = (ThrowableDropSelfProjectile)this.entityType.create(pLevel);
            if (projectile != null) {
                projectile.setOwner((Entity)pPlayer);
                if (this.dropSelf) {
                    projectile.setItem(this.getDefaultInstance());
                }
                projectile.setDamage(this.damage);
                projectile.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), 0.0f, this.power, this.inaccuracy);
                projectile.setFlyTicks(this.flyTicks);
                pLevel.addFreshEntity((Entity)projectile);
                pPlayer.getCooldowns().addCooldown((Item)this, this.cooldown);
            }
        }
        pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!pPlayer.hasInfiniteMaterials()) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide);
    }
}

