/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.component.LootComponent;
import org.confluence.mod.common.data.map.TreasureBagDrop;
import org.confluence.mod.common.entity.TreasureBagItemEntity;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModSoundEvents;

public class TreasureBagItem
extends CustomRarityItem {
    public final ResourceLocation lootTable;
    public final ModRarity innerRarity;
    public final BiFunction<ServerLevel, BlockPos, String> suffix;

    public TreasureBagItem(ResourceLocation lootTable, ModRarity innerRarity, BiFunction<ServerLevel, BlockPos, String> suffix) {
        super(new Item.Properties().fireResistant(), ModRarity.EXPERT);
        this.lootTable = lootTable;
        this.innerRarity = innerRarity;
        this.suffix = suffix;
    }

    public TreasureBagItem(ResourceLocation lootTable, ModRarity innerRarity) {
        this(lootTable, innerRarity, (level, pos) -> (String)LibUtils.switchByDifficulty((Level)level, (BlockPos)pos, (Object)"/classic", (Object)"/expert", (Object)"/master"));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level instanceof ServerLevel) {
            ResourceKey table;
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams lootparams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withLuck(player.getLuck()).create(LootContextParamSets.GIFT);
            LootComponent component = (LootComponent)itemStack.get(ModDataComponentTypes.LOOT);
            ResourceKey resourceKey = table = component == null ? null : component.value();
            if (table == null) {
                String string = LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack).getString("lootTable");
                table = string.isEmpty() || player.isCreative() ? ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable.withSuffix(this.suffix.apply(serverLevel, player.blockPosition()))) : ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)string));
            }
            LootTable loottable = serverLevel.getServer().reloadableRegistries().getLootTable(table);
            int count = 1;
            if (player.isCrouching()) {
                count = itemStack.getCount();
            }
            for (int i = 0; i < count; ++i) {
                ObjectArrayList items = loottable.getRandomItems(lootparams);
                this.collectItems(serverLevel, player, itemStack, (ObjectArrayList<ItemStack>)items);
                for (ItemStack loot : items) {
                    if (player.addItem(loot)) continue;
                    player.drop(loot, false, true);
                }
            }
            itemStack.shrink(count);
        } else {
            player.playSound((SoundEvent)ModSoundEvents.TERRA_OPERATION.get(), 0.5f, 1.0f);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    protected void collectItems(ServerLevel serverLevel, Player player, ItemStack itemStack, ObjectArrayList<ItemStack> items) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.right_click.common.0").withStyle(ChatFormatting.GRAY));
    }

    public static void createItemEntity(LivingEntity living, ServerPlayer owner) {
        ItemStack itemStack = TreasureBagDrop.getTreasureBag(living);
        if (itemStack != null) {
            living.level().addFreshEntity((Entity)new TreasureBagItemEntity(living.level(), living.position(), itemStack, (Player)owner));
        }
    }
}

