/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.PathService;
import org.confluence.mod.common.item.common.WrenchItem;

public class WireCutterItem
extends TooltipItem {
    public WireCutterItem() {
        super(new Item.Properties().stacksTo(1).attributes(new ItemAttributeModifiers(Collections.singletonList(new ItemAttributeModifiers.Entry(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(Confluence.asResource("wire_cutter"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)), true)), ModRarity.BLUE, "tooltip.item.confluence.wire_cutter.0");
    }

    public boolean isFoil(ItemStack pStack) {
        return WrenchItem.containsPos(pStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = pContext.getItemInHand();
        BlockPos pPos = pContext.getClickedPos();
        BlockEntity blockEntity = level.getBlockEntity(pPos);
        if (blockEntity instanceof INetworkEntity) {
            INetworkEntity entity = (INetworkEntity)blockEntity;
            BlockPos storedPos = WrenchItem.readBlockPos(itemStack);
            if (storedPos == BlockPos.ZERO) {
                WrenchItem.writeBlockPos(itemStack, pPos);
            } else {
                BlockEntity blockEntity2 = level.getBlockEntity(storedPos);
                if (blockEntity2 instanceof INetworkEntity) {
                    INetworkEntity entity1 = (INetworkEntity)blockEntity2;
                    entity.getConnectedPoses().int2ObjectEntrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(storedPos)).forEach(entry -> entity.disconnectWith(entry.getIntKey(), storedPos, entity1));
                    entity1.getConnectedPoses().int2ObjectEntrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(pPos)).forEach(entry -> entity1.disconnectWith(entry.getIntKey(), pPos, entity));
                    PathService.INSTANCE.onBlockEntityUnload(entity);
                    WrenchItem.removeBlockPos(itemStack);
                }
            }
            return InteractionResult.CONSUME;
        }
        WrenchItem.removeBlockPos(itemStack);
        return InteractionResult.PASS;
    }
}

