/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.crossbow;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.lib.util.DelayTaskHolder;
import org.confluence.lib.util.EnchantmentUtil;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.ITerraArrowProjectileWeaponItem;
import org.confluence.mod.common.component.RepeaterContents;
import org.confluence.mod.common.entity.projectile.range.arrow.BaseArrowEntity;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.item.arrow.BaseTerraArrowItem;
import org.confluence.mod.common.item.bow.BaseTerraBowItem;
import org.confluence.mod.common.item.crossbow.IRandomCount;
import org.confluence.mod.common.item.tooltipcomponent.RepeaterComponent;
import org.confluence.mod.mixed.IAbstractArrow;
import org.confluence.mod.network.s2c.RepeaterShootingPayloadS2C;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.RepeaterContentsComponentHandler;
import org.confluence.terraentity.api.item.ILeftClickStateItem;
import org.confluence.terraentity.attachment.WeaponStorage;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BaseTerraRepeaterItem
extends CrossbowItem
implements ITerraArrowProjectileWeaponItem<BaseTerraRepeaterItem>,
ILeftClickStateItem {
    public static final List<Component> TOOLTIP = TooltipItem.getTooltipsFromString((String)"repeater", (int)2, (ChatFormatting)ChatFormatting.GRAY);
    public static final String ATTACK_SPEED_TEXT = "attribute.name.repeater.attack_speed";
    public static final String KNOCKBACK_TEXT = "attribute.name.repeater.knockback";
    public static final String TORRENT_COUNT_TEXT = "attribute.name.repeater.torrent_count";
    public static final String CONCURRENCY_COUNT_TEXT = "attribute.name.repeater.concurrency_count";
    public static final String FIRING_INTERVAL_TEXT = "attribute.name.repeater.firing_interval";
    public static final String RELOAD_SPEED_TEXT = "attribute.name.repeater.reload_speed";
    public static final String ARROW_CAPACITY_TEXT = "attribute.name.repeater.arrow_capacity";
    public static final String REPEATER_CONTINUOUS_SHOOTING = "repeater.continuous_shooting";
    public static final String REPEATER_SHOOTING = "repeater.shooting";
    private static final ResourceLocation ID = Confluence.asResource(EquipmentSlotGroup.MAINHAND.getSerializedName());
    private static final CrossbowItem.ChargingSounds DEFAULT_SOUNDS = new CrossbowItem.ChargingSounds(Optional.of(SoundEvents.CROSSBOW_LOADING_START), Optional.of(SoundEvents.CROSSBOW_LOADING_MIDDLE), Optional.of(SoundEvents.CROSSBOW_LOADING_END));
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    private final float baseDamage;
    private final float baseKnockback;
    private final int baseReloadSpeed;
    private final int baseShootInterval;
    private final int baseCapacity;
    private final float baseArrowSpeed;
    private final IRandomCount baseBurstCount;
    private final IRandomCount baseConcurrentCount;
    private final IRandomCount baseConcurrentAngle;
    private final IRandomCount baseConcurrentInterval;
    private final AmmunitionRestrictions ammunitionRestrictions;
    private final BaseArrowEntity.Builder arrowModifier;
    private final BaseTerraArrowItem.ModifyArrowBuilder modifyArrowBuilder;

    public BaseTerraRepeaterItem(Item.Properties properties, float baseDamage, BaseTerraArrowItem.ModifyArrowBuilder modifyArrowBuilder, Builder repeaterBuilder) {
        super(modifyArrowBuilder.buildProperties(properties.stacksTo(1).component(ModDataComponentTypes.REPEATER_CONTENTS, (Object)RepeaterContents.fromItems(repeaterBuilder.capacity)).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(ID, (double)repeaterBuilder.knockback, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build())));
        this.baseReloadSpeed = repeaterBuilder.reloadSpeed;
        this.baseShootInterval = repeaterBuilder.shootInterval;
        this.baseCapacity = repeaterBuilder.capacity;
        this.baseArrowSpeed = repeaterBuilder.arrowSpeed;
        this.baseBurstCount = repeaterBuilder.burstCount;
        this.baseConcurrentCount = repeaterBuilder.concurrentCount;
        this.ammunitionRestrictions = repeaterBuilder.ammunitionRestrictions;
        this.baseKnockback = repeaterBuilder.knockback;
        this.baseConcurrentAngle = repeaterBuilder.concurrentAngle;
        this.baseConcurrentInterval = repeaterBuilder.concurrentInterval;
        this.baseDamage = baseDamage;
        this.arrowModifier = new BaseArrowEntity.Builder();
        modifyArrowBuilder.modifyArrowBuilder.forEach(m -> m.accept(this.arrowModifier));
        this.modifyArrowBuilder = modifyArrowBuilder;
    }

    public BaseTerraRepeaterItem(float baseDamage, BaseTerraArrowItem.ModifyArrowBuilder bowModifyArrowBuilder, Builder repeaterBuilder) {
        this(new Item.Properties(), baseDamage, bowModifyArrowBuilder, repeaterBuilder);
    }

    public int getReloadSpeed(LivingEntity shooter, InteractionHand hand) {
        return this.getReloadSpeed(shooter, shooter.getItemInHand(hand));
    }

    public int getReloadSpeed(LivingEntity shooter, ItemStack stack) {
        float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)stack, (LivingEntity)shooter, (float)((float)this.baseReloadSpeed / 20.0f));
        return Mth.floor((float)(f * 20.0f));
    }

    public int getShootInterval(LivingEntity shooter, InteractionHand hand) {
        return this.getShootInterval(shooter, shooter.getItemInHand(hand));
    }

    public int getShootInterval(LivingEntity shooter, ItemStack stack) {
        return this.baseShootInterval;
    }

    public int getCapacity() {
        return this.baseCapacity;
    }

    public float getArrowSpeed(LivingEntity shooter, InteractionHand hand) {
        return this.baseArrowSpeed;
    }

    public int getBurstCount(LivingEntity shooter, InteractionHand hand) {
        int processProjectileCount;
        Level level = shooter.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = shooter.getItemInHand(hand);
            int count = EnchantmentHelper.processProjectileCount((ServerLevel)serverLevel, (ItemStack)itemStack, (Entity)shooter, (int)1);
            int level2 = EnchantmentUtil.getEnchantmentLevel((ResourceKey)Enchantments.MULTISHOT, (ItemStack)itemStack);
            processProjectileCount = count - level2;
        } else {
            processProjectileCount = 0;
        }
        return Math.round(this.baseBurstCount.getCount(shooter.getRandom())) + processProjectileCount;
    }

    public int getConcurrentCount(LivingEntity shooter, InteractionHand hand) {
        return Math.round(this.baseConcurrentCount.getCount(shooter.getRandom()));
    }

    public float getConcurrentAngle(LivingEntity shooter, InteractionHand hand) {
        return this.baseConcurrentAngle.getCount(shooter.getRandom());
    }

    public float getConcurrentInterval(LivingEntity shooter, InteractionHand hand) {
        return this.baseConcurrentInterval.getCount(shooter.getRandom());
    }

    public float getDamage(LivingEntity shooter, InteractionHand hand) {
        return this.baseDamage;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        Object object = stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (!(object instanceof RepeaterContentsComponentHandler)) {
            return false;
        }
        RepeaterContentsComponentHandler handler = (RepeaterContentsComponentHandler)object;
        if (other.isEmpty()) {
            if (!handler.isEmpty() && action == ClickAction.SECONDARY) {
                ItemStack itemStack = handler.extractItem(0, handler.getStackInSlot(0).getCount(), false);
                boolean isEmpty = itemStack.isEmpty();
                if (!isEmpty) {
                    this.playRemoveSound((Entity)player);
                }
                return !isEmpty && access.set(itemStack);
            }
            return false;
        }
        if (!this.getAllSupportedProjectiles(stack).test(other)) {
            return false;
        }
        int stackCount = switch (action) {
            default -> throw new MatchException(null, null);
            case ClickAction.PRIMARY -> other.getCount();
            case ClickAction.SECONDARY -> 1;
        };
        ItemStack copy = other.copyWithCount(stackCount);
        boolean is = handler.insertItem(() -> copy, false);
        if (is) {
            this.playAerialShootingSound((Entity)player);
            other.setCount(other.getCount() - (stackCount - copy.getCount()));
        }
        return is;
    }

    public static boolean isCharged(ItemStack crossbowStack) {
        RepeaterContents contents = (RepeaterContents)crossbowStack.get(ModDataComponentTypes.REPEATER_CONTENTS);
        return contents != null && !contents.isEmpty();
    }

    protected static Vector3f getProjectileShotVector(LivingEntity shooter, Vec3 distance, float angle) {
        Vector3f vector3f = distance.toVector3f().normalize();
        Vector3f vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f1.lengthSquared() <= 1.0E-7) {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.toVector3f());
        }
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f1.x, vector3f1.y, vector3f1.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(angle * ((float)Math.PI / 180), vector3f2.x, vector3f2.y, vector3f2.z);
    }

    protected float getShootingPower(RepeaterContentsComponentHandler handler, Player player, InteractionHand hand) {
        return this.getArrowSpeed((LivingEntity)player, hand);
    }

    protected static float getShotPitch(RandomSource random, int index) {
        return index == 0 ? 1.0f : BaseTerraRepeaterItem.getRandomShotPitch((index & 1) == 1, random);
    }

    protected static float getRandomShotPitch(boolean isHighPitched, RandomSource random) {
        float f = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    protected CrossbowItem.ChargingSounds getChargingSounds(ItemStack stack) {
        return EnchantmentHelper.pickHighestLevel((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.CROSSBOW_CHARGING_SOUNDS).orElse(DEFAULT_SOUNDS);
    }

    @Nullable
    public RepeaterContentsComponentHandler getHandler(ItemStack stack) {
        Object object = stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (object instanceof RepeaterContentsComponentHandler) {
            RepeaterContentsComponentHandler handler = (RepeaterContentsComponentHandler)object;
            return handler;
        }
        return null;
    }

    private static InteractionHand getHand(Player player, ItemStack itemStack) {
        return player.getMainHandItem() == itemStack ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    private void playRemoveSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playAerialShootingSound(Entity entity) {
        entity.playSound((SoundEvent)ModSoundEvents.REPEATER_ITEM_AERIAL_SHOOTING.get());
    }

    public boolean shootingPerform(Level level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, float velocity, float inaccuracy, @Nullable LivingEntity target, boolean isConsume) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverlevel = (ServerLevel)level;
        List<ItemStack> itemStacks = RepeaterContentsComponentHandler.extractItemList(weapon, 1, !isConsume);
        this.shoot(serverlevel, shooter, hand, weapon, itemStacks, velocity, inaccuracy, true, target);
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)shooter;
            RepeaterShootingPayloadS2C.sendToClient(serverplayer);
            CriteriaTriggers.SHOT_CROSSBOW.trigger(serverplayer, weapon);
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)weapon.getItem()));
        }
        return true;
    }

    protected boolean shootingPerformContinuousShooting(Player player, ItemStack itemStack, int countCount, DelayTaskHolder delayTaskHolder, InteractionHand hand, Level level, float shootingPower) {
        if (delayTaskHolder.containsTask(hand, REPEATER_CONTINUOUS_SHOOTING)) {
            return false;
        }
        delayTaskHolder.addTask(hand, REPEATER_CONTINUOUS_SHOOTING, DelayTaskHolder.createTaskBilder().repeatCount(countCount - 1).removedTick(1).resultRun((tick, maxTick, task) -> {
            if (!this.shootingPerform(level, (LivingEntity)player, hand, itemStack, shootingPower, 1.0f, null, true)) {
                task.remove();
            }
            return 0;
        }).build());
        return true;
    }

    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
        float processProjectileSpread = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        int projectileItemsCount = projectileItems.size();
        float angleIncrement = projectileItemsCount == 1 ? 0.0f : 2.0f * processProjectileSpread / (float)(projectileItemsCount - 1);
        float initialAngleOffset = (float)((projectileItemsCount - 1) % 2) * angleIncrement / 2.0f;
        int signFactor = shooter.getRandom().nextBoolean() ? 1 : -1;
        for (int itemstackIndex = 0; itemstackIndex < projectileItemsCount; ++itemstackIndex) {
            ItemStack itemstack = projectileItems.get(itemstackIndex);
            if (itemstack.isEmpty()) continue;
            float projectileVelocity = itemstack.is(Items.FIREWORK_ROCKET) ? velocity * 0.507f : velocity;
            int i = (itemstackIndex % 2 == 0 ? itemstackIndex - 1 : -itemstackIndex) * signFactor;
            int concurrentCount = this.getConcurrentCount(shooter, hand);
            int multiShootCount = !this.modifyArrowBuilder.canMultiShoot.test(itemstack) ? 1 : concurrentCount;
            int signFactor1 = shooter.getRandom().nextBoolean() ? 1 : -1;
            for (int projectileIndex = 0; projectileIndex < concurrentCount; ++projectileIndex) {
                int i1 = (projectileIndex % 2 == 0 ? projectileIndex - 1 : -projectileIndex) * signFactor1;
                float angle = projectileIndex > 0 ? this.getConcurrentAngle(shooter, hand) * (float)i : 0.0f;
                float angleY = initialAngleOffset * angleIncrement + angle;
                Projectile projectile = this.createProjectile((Level)level, shooter, weapon, itemstack, isCrit);
                if (projectile instanceof AbstractArrow) {
                    AbstractArrow abstractArrow = (AbstractArrow)projectile;
                    abstractArrow.setBaseDamage((double)this.getDamage(shooter, hand));
                }
                this.shootProjectile(shooter, projectile, itemstackIndex, projectileVelocity, inaccuracy + this.modifyArrowBuilder.inaccuracy, angleY, target);
                float y = itemstackIndex > 0 ? this.getConcurrentInterval(shooter, hand) * (float)i : 0.0f;
                float z = projectileIndex > 0 ? this.getConcurrentInterval(shooter, hand) * (float)i1 : 0.0f;
                Vec3 offset = projectileItemsCount <= multiShootCount ? new Vec3(0.0, (double)y, (double)z) : new Vec3(0.0, (double)z, (double)y);
                BaseTerraBowItem.transformAndApplyOffsetToProjectile(projectile, offset);
                BaseTerraBowItem.processArrowBaseEffects(shooter, hand, weapon, projectile, itemstackIndex, multiShootCount);
                if (projectile instanceof IAbstractArrow) {
                    IAbstractArrow abstractArrow = (IAbstractArrow)projectile;
                    abstractArrow.confluence$setDamageNotAffectedBySpeedBonus(true);
                    if (itemstackIndex > 0 || projectileIndex > 0) {
                        abstractArrow.confluence$setDisappearingOnGround(true);
                    }
                }
                level.addFreshEntity((Entity)projectile);
            }
            weapon.hurtAndBreak(this.getDurabilityUse(itemstack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (weapon.isEmpty()) break;
        }
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        Vector3f vector3f;
        if (target != null) {
            double d0 = target.getX() - shooter.getX();
            double d1 = target.getZ() - shooter.getZ();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            double d3 = target.getY(0.3333333333333333) - projectile.getY() + d2 * (double)0.2f;
            vector3f = BaseTerraRepeaterItem.getProjectileShotVector(shooter, new Vec3(d0, d3, d1), angle);
        } else {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
            Vec3 vec31 = shooter.getViewVector(1.0f);
            vector3f = vec31.toVector3f().rotate((Quaternionfc)quaternionf);
        }
        projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
        float f = BaseTerraRepeaterItem.getShotPitch(shooter.getRandom(), index);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.CROSSBOW_SHOOT, shooter.getSoundSource(), 1.0f, f);
    }

    public void onLeftClick(Player player, ItemStack itemStack) {
        RepeaterContentsComponentHandler handler = this.getHandler(itemStack);
        if (handler == null) {
            return;
        }
        if (handler.isEmpty()) {
            this.playAerialShootingSound((Entity)player);
            return;
        }
        InteractionHand hand = BaseTerraRepeaterItem.getHand(player, itemStack);
        DelayTaskHolder delayTaskHolder = DelayTaskHolder.of((AttachmentHolder)player);
        Level level = player.level();
        if (!delayTaskHolder.containsTask(hand).isEmpty()) {
            return;
        }
        int countCount = this.getBurstCount((LivingEntity)player, hand);
        float shootingPower = this.getShootingPower(handler, player, hand);
        if (countCount > 1) {
            this.shootingPerformContinuousShooting(player, itemStack, countCount, delayTaskHolder, hand, level, shootingPower);
        }
        delayTaskHolder.addTask(hand, REPEATER_SHOOTING, DelayTaskHolder.createTaskBilder().repeatCount(-1).removedTick(this.getShootInterval((LivingEntity)player, hand)).resultRun((tick, maxTick, task) -> {
            RepeaterContentsComponentHandler projectiles = this.getHandler(itemStack);
            if (projectiles == null || projectiles.isEmpty()) {
                task.remove();
                return 0;
            }
            if (countCount > 1) {
                this.shootingPerformContinuousShooting(player, itemStack, countCount, delayTaskHolder, hand, level, shootingPower);
            }
            if (!this.shootingPerform(level, (LivingEntity)player, hand, itemStack, shootingPower, 1.0f, null, true)) {
                task.remove();
            }
            return 0;
        }).build());
    }

    public void onLeftRelease(Player player, ItemStack itemStack) {
        InteractionHand hand = BaseTerraRepeaterItem.getHand(player, itemStack);
        DelayTaskHolder delayTaskHolder = DelayTaskHolder.of((AttachmentHolder)player);
        delayTaskHolder.removeTask(hand, REPEATER_SHOOTING);
        delayTaskHolder.removeTask(hand, REPEATER_CONTINUOUS_SHOOTING);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        RepeaterContentsComponentHandler projectiles = this.getHandler(itemstack);
        if (projectiles == null || projectiles.isEmpty() && !player.getProjectile(itemstack).isEmpty()) {
            this.startSoundPlayed = false;
            this.midLoadSoundPlayed = false;
            player.startUsingItem(hand);
        }
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        return stack;
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        int i = this.getUseDuration(stack, entity) - count;
        float f = this.getPowerForTime(i, stack, entity);
        if (f < 1.0f || !this.tryLoadProjectiles(entity, stack)) {
            return;
        }
        Level level = entity.level();
        WeaponStorage.of((IAttachmentHolder)entity).bowFullPull = true;
        if (level.isClientSide) {
            entity.playSound((SoundEvent)ModSoundEvents.BOW_COOLDOWN_RECOVERY.get());
        }
        CrossbowItem.ChargingSounds crossbowitem$chargingsounds = this.getChargingSounds(stack);
        crossbowitem$chargingsounds.end().ifPresent(p_352852_ -> level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)p_352852_.value(), entity.getSoundSource(), 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
    }

    protected boolean tryLoadProjectiles(LivingEntity shooter, ItemStack weapon) {
        Player player;
        if (shooter.level().isClientSide) {
            return true;
        }
        return RepeaterContentsComponentHandler.insertItem(weapon, () -> shooter.getProjectile(weapon), shooter instanceof Player && (player = (Player)shooter).isCreative());
    }

    protected float getPowerForTime(int timeLeft, ItemStack stack, LivingEntity shooter) {
        float f = (float)timeLeft / (float)this.getReloadSpeed(shooter, stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int count) {
        if (level.isClientSide) {
            return;
        }
        float f = (float)(stack.getUseDuration(livingEntity) - count) / (float)this.getReloadSpeed(livingEntity, stack);
        if (f < 0.2f) {
            WeaponStorage.of((IAttachmentHolder)livingEntity).bowFullPull = false;
            this.startSoundPlayed = false;
            this.midLoadSoundPlayed = false;
        }
        CrossbowItem.ChargingSounds crossbowitem$chargingsounds = this.getChargingSounds(stack);
        if (f >= 0.2f && !this.startSoundPlayed) {
            this.startSoundPlayed = true;
            crossbowitem$chargingsounds.start().ifPresent(p_352849_ -> level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), (SoundEvent)p_352849_.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
        }
        if (f >= 0.5f && !this.midLoadSoundPlayed) {
            this.midLoadSoundPlayed = true;
            crossbowitem$chargingsounds.mid().ifPresent(p_352855_ -> level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), (SoundEvent)p_352855_.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
        }
        if (f >= 1.0f) {
            livingEntity.stopUsingItem();
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.getReloadSpeed(entity, stack) + 3;
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles(ItemStack stack) {
        return itemStack -> this.ammunitionRestrictions.test((ItemStack)itemStack, stack);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles(ItemStack stack) {
        return itemStack -> this.ammunitionRestrictions.test((ItemStack)itemStack, stack);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean canSwitchWithoutRelease(Player player, ItemStack itemStack) {
        return false;
    }

    @Override
    public BaseTerraArrowItem.ModifyArrowBuilder getModifyArrowBuilder() {
        return this.modifyArrowBuilder;
    }

    @Override
    public BaseArrowEntity.Builder getArrowModifier() {
        return this.arrowModifier;
    }

    public void appendHoverText(ItemStack weapon, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        BaseTerraArrowItem.addDamageHoverText(tooltipComponents, this.modifyArrowBuilder, this.baseDamage);
        tooltipComponents.add((Component)BaseTerraRepeaterItem.tooltip(ARROW_CAPACITY_TEXT).append(BaseTerraRepeaterItem.getTotalSize(weapon).getItemsTotalCount() + "/" + this.baseCapacity).withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)BaseTerraRepeaterItem.tooltip(ATTACK_SPEED_TEXT).append(String.valueOf(this.baseArrowSpeed)).withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)BaseTerraRepeaterItem.tooltip(KNOCKBACK_TEXT).append(String.valueOf(this.baseKnockback)).withStyle(ChatFormatting.DARK_GRAY));
        if (!IRandomCount.is(this.baseBurstCount, 1.0f)) {
            tooltipComponents.add((Component)BaseTerraRepeaterItem.tooltip(TORRENT_COUNT_TEXT).append(IRandomCount.getString(this.baseBurstCount)).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (!IRandomCount.is(this.baseConcurrentCount, 1.0f)) {
            tooltipComponents.add((Component)BaseTerraRepeaterItem.tooltip(CONCURRENCY_COUNT_TEXT).append(IRandomCount.getString(this.baseConcurrentCount)).withStyle(ChatFormatting.DARK_GRAY));
        }
        tooltipComponents.add((Component)BaseTerraRepeaterItem.tooltip(FIRING_INTERVAL_TEXT).append(String.valueOf((float)this.baseShootInterval / 20.0f)).withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)BaseTerraRepeaterItem.tooltip(RELOAD_SPEED_TEXT).append(String.valueOf((float)this.baseReloadSpeed / 20.0f)).withStyle(ChatFormatting.DARK_GRAY));
        BaseTerraArrowItem.addHitEffectHoverText(weapon, tooltipComponents);
        BaseTerraArrowItem.addFullPullHitEffectHoverText(weapon, tooltipComponents);
        BaseTerraArrowItem.addEntityTransformHoverText(tooltipComponents, this.modifyArrowBuilder, this.arrowModifier);
        tooltipComponents.addAll(TOOLTIP);
    }

    private static RepeaterContents getTotalSize(ItemStack weapon) {
        return (RepeaterContents)weapon.getComponents().getOrDefault(ModDataComponentTypes.REPEATER_CONTENTS.get(), (Object)RepeaterContents.EMPTY);
    }

    private static MutableComponent tooltip(String text) {
        return Component.translatable((String)text).append(": ");
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.ofNullable((RepeaterContents)stack.get(ModDataComponentTypes.REPEATER_CONTENTS)).map(RepeaterComponent::new);
    }

    public float getBaseKnockback() {
        return this.baseKnockback;
    }

    public static class Builder {
        public static final AmmunitionRestrictions DEFAULT_AMMUNITION_RESTRICTIONS = (ammunitionStack, weaponStack) -> ammunitionStack.is(ItemTags.ARROWS) || ammunitionStack.is(Items.FIREWORK_ROCKET);
        public static final AmmunitionRestrictions DEFAULT_AMMUNITION_RESTRICTIONS_ARROWS = (ammunitionStack, weaponStack) -> ammunitionStack.is(ItemTags.ARROWS) || ammunitionStack.is(Items.FIREWORK_ROCKET);
        public static final AmmunitionRestrictions DEFAULT_AMMUNITION_RESTRICTIONS_FIREWORK_ROCKET = (ammunitionStack, weaponStack) -> ammunitionStack.is(Items.FIREWORK_ROCKET);
        private int reloadSpeed = Mth.floor((float)25.0f);
        private int shootInterval = 5;
        private int capacity = 5;
        private float arrowSpeed = 3.15f;
        private float knockback = 0.0f;
        private IRandomCount burstCount = IRandomCount.DEFAULT;
        private IRandomCount concurrentCount = IRandomCount.DEFAULT;
        private IRandomCount concurrentAngle = IRandomCount.DEFAULT_EMPTY;
        private IRandomCount concurrentInterval = IRandomCount.DEFAULT_EMPTY;
        private AmmunitionRestrictions ammunitionRestrictions = DEFAULT_AMMUNITION_RESTRICTIONS;

        public Builder reloadTick(int reloadSpeed) {
            this.reloadSpeed = reloadSpeed;
            return this;
        }

        public Builder shootInterval(int shootInterval) {
            this.shootInterval = shootInterval;
            return this;
        }

        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder arrowSpeed(float arrowSpeed) {
            this.arrowSpeed = arrowSpeed;
            return this;
        }

        public Builder burstCount(IRandomCount burstCount) {
            this.burstCount = burstCount;
            return this;
        }

        public Builder burstCount(int burstCount) {
            this.burstCount = IRandomCount.create(burstCount);
            return this;
        }

        public Builder concurrentCount(IRandomCount concurrentCount) {
            this.concurrentCount = concurrentCount;
            return this;
        }

        public Builder concurrentCount(int concurrentCount) {
            this.concurrentCount = IRandomCount.create(concurrentCount);
            return this;
        }

        public Builder concurrentAngle(IRandomCount concurrentAngle) {
            this.concurrentAngle = concurrentAngle;
            return this;
        }

        public Builder concurrentAngle(float concurrentAngle) {
            this.concurrentAngle = IRandomCount.create(concurrentAngle);
            return this;
        }

        public Builder concurrentInterval(IRandomCount concurrentInterval) {
            this.concurrentInterval = this.concurrentAngle;
            return this;
        }

        public Builder concurrentInterval(float concurrentInterval) {
            this.concurrentInterval = IRandomCount.create(concurrentInterval);
            return this;
        }

        public Builder ammunitionRestrictions(AmmunitionRestrictions ammunitionRestrictions) {
            this.ammunitionRestrictions = ammunitionRestrictions;
            return this;
        }

        public Builder knockback(float knockback) {
            this.knockback = knockback;
            return this;
        }
    }

    @FunctionalInterface
    public static interface AmmunitionRestrictions {
        public boolean test(ItemStack var1, ItemStack var2);
    }
}

