/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.fishing;

import com.mojang.serialization.DynamicOps;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.entity.fishing.CurioFishingHook;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.BaitItems;
import org.confluence.mod.common.init.item.FishingPoleItems;
import org.confluence.mod.common.item.accessory.FishingBobber;
import org.confluence.mod.common.item.fishing.IBait;
import org.confluence.mod.mixed.IFishingHook;
import org.confluence.mod.mixed.IPlayer;
import org.confluence.mod.network.s2c.FishingPowerInfoPacketS2C;
import org.confluence.mod.util.ModUtils;
import org.confluence.terra_curio.util.CuriosUtils;
import org.confluence.terra_curio.util.TCUtils;

public abstract class AbstractFishingPole
extends FishingRodItem {
    public static final String BAIT_KEY = "Bait";
    public static final String HAS_BAIT_KEY = "HasBait";
    protected ItemAttributeModifiers modifiers;

    public AbstractFishingPole(Item.Properties properties) {
        super(properties);
    }

    public AbstractFishingPole(ModRarity rarity) {
        this(new Item.Properties().component((DataComponentType)ConfluenceMagicLib.MOD_RARITY.get(), (Object)rarity));
    }

    public AbstractFishingPole(Item.Properties properties, ModRarity rarity) {
        super(properties.component((DataComponentType)ConfluenceMagicLib.MOD_RARITY.get(), (Object)rarity));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.fishing != null) {
            if (!level.isClientSide) {
                this.consumeBait(player, stack);
                int i = player.fishing.retrieve(stack);
                ItemStack original = stack.copy();
                stack.hurtAndBreak(i, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                if (stack.isEmpty()) {
                    EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)original, (InteractionHand)hand);
                }
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), this.getRetrieveSound(), SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), this.getThrowSound(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int luckBonus = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverLevel, (ItemStack)stack, (Entity)player) + (int)FishingPowerInfoPacketS2C.sendAndGet((ServerPlayer)player);
                int speedBonus = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverLevel, (ItemStack)stack, (Entity)player) * 20.0f);
                FishingBobber curio = (FishingBobber)((Object)CuriosUtils.findCurio((LivingEntity)player, FishingBobber.class));
                Object fishingHook = curio == null ? this.getHook(stack, player, level, luckBonus, speedBonus) : new CurioFishingHook(player, level, luckBonus, speedBonus, curio.variant);
                ItemStack bait = IBait.getFirstBait(player.getInventory()).split(1);
                AbstractFishingPole.setBait((HolderLookup.Provider)level.registryAccess(), stack, bait);
                IPlayer.of(player).confluence$setCurrentBait(bait);
                if (this == FishingPoleItems.HOTLINE_FISHING_HOOK.get() || !bait.isEmpty() && bait.is(ModTags.Items.LAVA_PROOF_BAIT) || TCUtils.hasType((LivingEntity)player, AccessoryItems.LAVAPROOF$FISHING$HOOK)) {
                    IFishingHook.of(fishingHook).confluence$setIsLavaHook();
                }
                level.addFreshEntity((Entity)fishingHook);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IPlayer iPlayer = IPlayer.of(player);
            ItemStack bait = iPlayer.confluence$getCurrentBait();
            if (isSelected) {
                if (level.getGameTime() % 4L == 0L) {
                    iPlayer.confluence$setCurrentBait(AbstractFishingPole.getBait((HolderLookup.Provider)level.registryAccess(), stack));
                }
            } else if (!bait.isEmpty() && !(player.getMainHandItem().getItem() instanceof AbstractFishingPole)) {
                if (player.addItem(bait)) {
                    player.drop(bait, true);
                }
                AbstractFishingPole.setBait((HolderLookup.Provider)level.registryAccess(), stack, ItemStack.EMPTY);
                iPlayer.confluence$setCurrentBait(ItemStack.EMPTY);
            }
        }
    }

    protected SoundEvent getRetrieveSound() {
        return SoundEvents.FISHING_BOBBER_RETRIEVE;
    }

    protected SoundEvent getThrowSound() {
        return SoundEvents.FISHING_BOBBER_THROW;
    }

    public abstract FishingHook getHook(ItemStack var1, Player var2, Level var3, int var4, int var5);

    protected void addAttributeModifiers(Consumer<ItemAttributeModifiers.Builder> consumer) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        consumer.accept(builder);
        this.modifiers = builder.build();
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.modifiers == null ? super.getDefaultAttributeModifiers(stack) : this.modifiers;
    }

    public static ItemStack getBait(HolderLookup.Provider provider, ItemStack fishingPole) {
        CompoundTag tag = LibUtils.getItemStackNbtIfPresent((ItemStack)fishingPole);
        if (tag == null || !tag.getBoolean(HAS_BAIT_KEY)) {
            return ItemStack.EMPTY;
        }
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return ItemStack.OPTIONAL_CODEC.parse((DynamicOps)ops, (Object)tag.get(BAIT_KEY)).result().orElse(ItemStack.EMPTY);
    }

    public static void setBait(HolderLookup.Provider provider, ItemStack fishingPole, ItemStack bait) {
        LibUtils.updateItemStackNbt((ItemStack)fishingPole, tag -> {
            RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            tag.put(BAIT_KEY, ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)ops, (Object)bait).result().orElseGet(CompoundTag::new));
            tag.putBoolean(HAS_BAIT_KEY, !bait.isEmpty());
        });
    }

    public void consumeBait(Player player, ItemStack fishingPole) {
        RegistryAccess provider = player.registryAccess();
        ItemStack bait = AbstractFishingPole.getBait((HolderLookup.Provider)provider, fishingPole);
        if (bait.isEmpty()) {
            return;
        }
        boolean consume = false;
        if (bait.is(BaitItems.TRUFFLE_WORM)) {
            consume = true;
        } else if (bait.is(BaitItems.GOLD_WORM)) {
            if (player.getRandom().nextInt(20) == 0) {
                consume = true;
            }
        } else {
            float bonus;
            float factor = TCUtils.hasType((LivingEntity)player, AccessoryItems.TACKLE$BOX) ? 2.0f : 1.0f;
            IBait iBait = IBait.of(bait);
            float f = bonus = iBait == null ? 0.0f : iBait.getBaitBonus() * 100.0f;
            if (player.getRandom().nextFloat() < 1.0f / (factor + bonus / 6.0f)) {
                consume = true;
            }
        }
        if (!consume && player.addItem(bait)) {
            player.drop(bait, true);
        }
        AbstractFishingPole.setBait((HolderLookup.Provider)player.registryAccess(), fishingPole, ItemStack.EMPTY);
        IPlayer.of(player).confluence$setCurrentBait(ItemStack.EMPTY);
    }

    public static void resetCurrentBait(Player player) {
        ItemStack itemStack;
        IPlayer iPlayer = IPlayer.of(player);
        if (!(iPlayer.confluence$getCurrentBait().isEmpty() || !(itemStack = player.getMainHandItem()).isEmpty() && itemStack.getItem() instanceof AbstractFishingPole)) {
            iPlayer.confluence$setCurrentBait(ItemStack.EMPTY);
        }
    }
}

