/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.fishing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.item.fishing.IBait;
import org.jetbrains.annotations.Nullable;

public class BaitItem
extends Item
implements IBait {
    private final float bonus;
    @Nullable
    private final Supplier<? extends EntityType<?>> supplier;
    private final Consumer<Entity> consumer;
    private final List<Component> commonTooltips;

    public BaitItem(ModRarity rarity, float bonus, @Nullable Supplier<? extends EntityType<?>> supplier, Consumer<Entity> consumer) {
        super(new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).stacksTo(9999));
        this.bonus = bonus;
        this.supplier = supplier;
        this.consumer = consumer;
        this.commonTooltips = this.createCommonTooltips();
    }

    public InteractionResult useOn(UseOnContext context) {
        if (this.supplier != null) {
            Level level = context.getLevel();
            if (!(level instanceof ServerLevel)) {
                return InteractionResult.SUCCESS;
            }
            ServerLevel level2 = (ServerLevel)level;
            ItemStack itemstack = context.getItemInHand();
            BlockPos blockpos = context.getClickedPos();
            Direction direction = context.getClickedFace();
            BlockState blockstate = level2.getBlockState(blockpos);
            BlockEntity blockEntity = level2.getBlockEntity(blockpos);
            if (blockEntity instanceof Spawner) {
                Spawner spawner = (Spawner)blockEntity;
                EntityType<?> entitytype1 = this.supplier.get();
                spawner.setEntityId(entitytype1, level2.getRandom());
                level2.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
                level2.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, blockpos);
                itemstack.shrink(1);
            } else {
                BlockPos blockpos1 = blockstate.getCollisionShape((BlockGetter)level2, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
                EntityType<?> entitytype = this.supplier.get();
                Entity entity = entitytype.spawn(level2, itemstack, context.getPlayer(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
                if (entity != null) {
                    this.consumer.accept(entity);
                    itemstack.shrink(1);
                    level2.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
                }
            }
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (this.supplier != null) {
            ItemStack itemstack = player.getItemInHand(usedHand);
            BlockHitResult blockhitresult = BaitItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (blockhitresult.getType() != HitResult.Type.BLOCK) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (!(level instanceof ServerLevel)) {
                return InteractionResultHolder.success((Object)itemstack);
            }
            BlockPos blockpos = blockhitresult.getBlockPos();
            if (!(level.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos, blockhitresult.getDirection(), itemstack)) {
                EntityType<?> entitytype = this.supplier.get();
                Entity entity = entitytype.spawn((ServerLevel)level, itemstack, player, blockpos, MobSpawnType.SPAWN_EGG, false, false);
                if (entity == null) {
                    return InteractionResultHolder.pass((Object)itemstack);
                }
                this.consumer.accept(entity);
                itemstack.consume(1, (LivingEntity)player);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
                return InteractionResultHolder.consume((Object)itemstack);
            }
            return InteractionResultHolder.fail((Object)itemstack);
        }
        return super.use(level, player, usedHand);
    }

    private List<Component> createCommonTooltips() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)Component.translatable((String)"tooltip.item.confluence.bait.common.0").withStyle(ChatFormatting.GRAY));
        return tooltips;
    }

    @Override
    public float getBaitBonus() {
        return this.bonus;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(this.commonTooltips);
        tooltipComponents.add((Component)Component.translatable((String)"info.confluence.bait", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format((double)this.getBaitBonus() * 100.0)}).withStyle(style -> style.withColor(ChatFormatting.BLUE)));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

