/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.food;

import java.util.Arrays;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.level.ItemLike;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.item.food.ModFoodPropertiesBuilder;

public class ModFoodProperties {
    public static final FoodProperties GOLDEN_CARP = ModFoodPropertiesBuilder.Builder().nutrition(8).saturation(0.8f).fast().alwaysEdible().addEffect(new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, 24000, 2), 1.0f).addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1), 1.0f).addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 2400), 1.0f).build();
    public static final FoodProperties LIFE_MUSHROOM = ModFoodPropertiesBuilder.Builder().nutrition(2).saturation(0.0625f).fast().alwaysEdible().build();

    public static FoodProperties preparedMeatProperties(int nutrition, float saturation) {
        return ModFoodPropertiesBuilder.Builder().nutrition(nutrition).saturation(saturation).fast().alwaysEdible().addEffect(new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, 3000), 1.0f).build();
    }

    public static FoodProperties noEffectProperties(int nutrition, float saturation) {
        return ModFoodPropertiesBuilder.Builder().nutrition(nutrition).saturation(saturation).fast().alwaysEdible().build();
    }

    public static FoodProperties hasEffectProperties(int nutrition, float saturation, ModFoodPropertiesBuilder.EffectData ... effects) {
        ModFoodPropertiesBuilder builder = ModFoodPropertiesBuilder.Builder().nutrition(nutrition).saturation(saturation).fast().alwaysEdible();
        Arrays.stream(effects).forEach(e -> builder.addEffect(new MobEffectInstance(e.effect(), e.duration(), e.level()), e.probability()));
        return builder.build();
    }

    public static FoodProperties wellFedProperties(int duration, int nutrition, float saturation) {
        return ModFoodPropertiesBuilder.Builder().nutrition(nutrition).saturation(saturation).fast().alwaysEdible().addEffect(new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration), 1.0f).build();
    }

    public static FoodProperties plentySatisfiedProperties(int duration, int nutrition, float saturation) {
        return ModFoodPropertiesBuilder.Builder().nutrition(nutrition).saturation(saturation).fast().alwaysEdible().addEffect(new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration, 1), 1.0f).addEffect(new MobEffectInstance(ModEffects.HUNGER_DELAYED, duration / 6), 1.0f).build();
    }

    public static FoodProperties exquisitelyStuffedProperties(int duration, int nutrition, float saturation) {
        return ModFoodPropertiesBuilder.Builder().nutrition(nutrition).saturation(saturation).fast().alwaysEdible().addEffect(new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration, 2), 1.0f).addEffect(new MobEffectInstance(ModEffects.HUNGER_DELAYED, duration / 6, 1), 1.0f).build();
    }

    public static FoodProperties wellFedProperties(int duration, int nutrition, float saturation, ItemLike item) {
        return ModFoodPropertiesBuilder.Builder().nutrition(nutrition).saturation(saturation).fast().alwaysEdible().useCovertsTo(item).addEffect(new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration), 1.0f).build();
    }

    public static FoodProperties plentySatisfiedProperties(int duration, int nutrition, float saturation, ItemLike item) {
        return ModFoodPropertiesBuilder.Builder().nutrition(nutrition).saturation(saturation).fast().alwaysEdible().useCovertsTo(item).addEffect(new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration, 1), 1.0f).addEffect(new MobEffectInstance(ModEffects.HUNGER_DELAYED, duration / 6), 1.0f).build();
    }

    public static FoodProperties exquisitelyStuffedProperties(int duration, int nutrition, float saturation, ItemLike item) {
        return ModFoodPropertiesBuilder.Builder().nutrition(nutrition).saturation(saturation).fast().alwaysEdible().useCovertsTo(item).addEffect(new MobEffectInstance(ModEffects.EXQUISITELY_STUFFED, duration, 2), 1.0f).addEffect(new MobEffectInstance(ModEffects.HUNGER_DELAYED, duration / 6, 1), 1.0f).build();
    }
}

