/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.gun;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terra_guns.api.event.GunEvent;
import org.confluence.terra_guns.common.entity.bullet.BaseBulletEntity;
import org.confluence.terra_guns.common.init.TGItems;
import org.confluence.terra_guns.common.item.gun.BaseGun;

public class ManaGunItem
extends BaseGun {
    private final int manaCost;
    private final float damage;
    private final float knockback;
    private final float critical;
    private final float velocity;
    private final int penetrate;
    private final float inaccuracy;

    public ManaGunItem(Item.Properties properties, int cooldown, float damage, float velocity, float knockback, float critical, int penetrate, float inaccuracy, ModRarity rarity, int manaCost) {
        super(properties, cooldown, damage, velocity, knockback, critical, penetrate, inaccuracy, rarity);
        this.manaCost = manaCost;
        this.damage = damage;
        this.critical = critical;
        this.knockback = knockback;
        this.velocity = velocity;
        this.penetrate = penetrate;
        this.inaccuracy = inaccuracy;
    }

    public int getManaCost() {
        return this.manaCost;
    }

    public void shoot(ServerPlayer player, ItemStack bullet, ItemStack gunStack) {
        if (PlayerUtils.extractMana(player, gunStack, () -> this.manaCost)) {
            GunEvent.AmmoDataEvent ammoDataEvent = new GunEvent.AmmoDataEvent((Player)player, (BaseGun)this, gunStack, this.damage, this.critical, this.knockback, this.velocity, this.penetrate, this.inaccuracy);
            NeoForge.EVENT_BUS.post((Event)ammoDataEvent);
            this.prepareBulletEntity(this.baseBulletEntities, player, TGItems.EMPTY_BULLET.toStack(), gunStack, ammoDataEvent.getDamage(), ammoDataEvent.getKnockback(), ammoDataEvent.getVelocity(), ammoDataEvent.getPenetrate(), ammoDataEvent.getInaccuracy());
            this.baseBulletEntities.forEach(arg_0 -> ((ServerLevel)player.serverLevel()).addFreshEntity(arg_0));
            this.baseBulletEntities.clear();
        }
    }

    protected BaseBulletEntity createBulletEntity(List<Projectile> baseBulletEntities, ServerPlayer player, ItemStack bullet, ItemStack gun, float damage, float knockback, float velocity, int penetrate, float inaccuracy) {
        return new BaseBulletEntity(this, (LivingEntity)player, bullet){

            public DamageSource getDamageSource() {
                return ModDamageTypes.of(this.level(), ModDamageTypes.MAGICAL_PROJECTILE, (Entity)this, this.getOwner());
            }
        };
    }

    public float getDamage() {
        return this.damage;
    }

    public float getInaccuracy() {
        return this.inaccuracy;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public int getPenetrate() {
        return this.penetrate;
    }

    public float getKnockback() {
        return this.knockback;
    }

    public float getCritical() {
        return this.critical;
    }
}

