/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.hook;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.entity.hook.AbstractHookEntity;
import org.confluence.mod.common.entity.hook.LunarHookEntity;
import org.confluence.mod.common.item.hook.BaseHookItem;
import org.confluence.mod.common.item.hook.IHookFastThrow;

public class LunarHookItem
extends BaseHookItem
implements IHookFastThrow {
    public LunarHookItem() {
        super(ModRarity.RED, 4, 22.92f, 1.8f, BaseHookItem.HookType.SIMULTANEOUS, (itemStack, item, player, level) -> {
            ListTag list = LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack).getList("hooks", 10);
            AtomicBoolean nebula = new AtomicBoolean(true);
            AtomicBoolean solar = new AtomicBoolean(true);
            AtomicBoolean stardust = new AtomicBoolean(true);
            AtomicBoolean vortex = new AtomicBoolean(true);
            list.forEach(tag -> {
                AbstractHookEntity hookEntity = LunarHookItem.getHookEntity(tag, level);
                if (hookEntity instanceof LunarHookEntity) {
                    LunarHookEntity lunarHookEntity = (LunarHookEntity)hookEntity;
                    switch (lunarHookEntity.getVariant()) {
                        case NEBULA: {
                            nebula.set(false);
                            break;
                        }
                        case SOLAR: {
                            solar.set(false);
                            break;
                        }
                        case STARDUST: {
                            stardust.set(false);
                            break;
                        }
                        case VORTEX: {
                            vortex.set(false);
                        }
                    }
                }
            });
            if (nebula.get()) {
                return new LunarHookEntity(item, player, level, LunarHookEntity.Variant.NEBULA);
            }
            if (solar.get()) {
                return new LunarHookEntity(item, player, level, LunarHookEntity.Variant.SOLAR);
            }
            if (stardust.get()) {
                return new LunarHookEntity(item, player, level, LunarHookEntity.Variant.STARDUST);
            }
            if (vortex.get()) {
                return new LunarHookEntity(item, player, level, LunarHookEntity.Variant.VORTEX);
            }
            return new LunarHookEntity(item, player, level, LunarHookEntity.Variant.NEBULA);
        });
    }
}

