/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.mana;

import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.common.attachment.EverBeneficial;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.util.AchievementUtils;

public class ManaCrystalItem
extends TooltipItem {
    public ManaCrystalItem() {
        super(new Item.Properties().stacksTo(16), ModRarity.YELLOW, ManaCrystalItem.getTooltipsFromString((String)"mana_crystal", (int)1, (ChatFormatting)ChatFormatting.GREEN));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        level.playSound(player, player.blockPosition().above(), (SoundEvent)ModSoundEvents.MANA_STAR_USE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        ItemStack itemStack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            EverBeneficial data;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ManaStorage data1 = ManaStorage.of((LivingEntity)player);
            if (data1.addStar()) {
                CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemStack);
                if (!player.hasInfiniteMaterials()) {
                    itemStack.shrink(1);
                }
            }
            if (data1.isStarMaximum() && (data = EverBeneficial.of((LivingEntity)serverPlayer)).isLifeCrystalsMaximum() && data.isLifeFruitsMaximum()) {
                AchievementUtils.awardAchievement(serverPlayer, "topped_off");
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
    }
}

