/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.mana;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.entity.projectile.mana.HurtnadoProjectile;
import org.confluence.mod.common.item.mana.ManaStaffItem;
import org.confluence.mod.common.item.tooltipcomponent.AltImageComponent;
import org.confluence.terra_curio.common.init.TCAttributes;

public class WeatherPainItem
extends ManaStaffItem<HurtnadoProjectile> {
    private TooltipComponent component;

    public WeatherPainItem() {
        super(ModRarity.GREEN, HurtnadoProjectile::new, 6.5f, 30, 1.0f, 45, builder -> builder.add(TCAttributes.getCriticalChance(), new AttributeModifier(ID, 0.04, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add((Holder)TCAttributes.ARMOR_PENETRATION, new AttributeModifier(ID, 10.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null) {
            this.component = AltImageComponent.of(stack.getItem());
        }
        return Optional.of(this.component);
    }

    @Override
    protected void beforeShoot(ServerPlayer player, ItemStack itemStack, HurtnadoProjectile projectile) {
        super.beforeShoot(player, itemStack, projectile);
        projectile.addDeltaMovement(new Vec3(0.0, 0.4, 0.0));
    }

    @Override
    protected void afterShoot(ServerPlayer player, ItemStack itemStack, HurtnadoProjectile projectile) {
        super.afterShoot(player, itemStack, projectile);
        LibUtils.updateItemStackNbt((ItemStack)itemStack, tag -> {
            Entity patt0$temp;
            if (tag.hasUUID("UUID") && (patt0$temp = player.serverLevel().getEntity(tag.getUUID("UUID"))) instanceof HurtnadoProjectile) {
                HurtnadoProjectile projectile1 = (HurtnadoProjectile)patt0$temp;
                projectile1.discard();
            }
            tag.putUUID("UUID", projectile.getUUID());
        });
    }
}

