/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.potion;

import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.entity.projectile.EffectThrownPotion;
import org.confluence.mod.common.item.potion.EffectPotionItem;

public class EffectThrowablePotionItem
extends EffectPotionItem {
    public EffectThrowablePotionItem(Item.Properties properties, Holder<MobEffect> mobEffect, int duration, int amplifier) {
        super(properties, mobEffect, duration, amplifier);
    }

    public EffectThrowablePotionItem(ModRarity rarity, Holder<MobEffect> mobEffect, int duration) {
        super(rarity, mobEffect, duration);
    }

    public EffectThrowablePotionItem(ModRarity rarity, Holder<MobEffect> mobEffect, int duration, int amplifier) {
        super(rarity, mobEffect, duration, amplifier);
    }

    public EffectThrowablePotionItem(Holder<MobEffect> mobEffect, int duration) {
        super(mobEffect, duration);
    }

    public EffectThrowablePotionItem(Holder<MobEffect> mobEffect, int duration, int amplifier) {
        super(mobEffect, duration, amplifier);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        pLevel.playSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (!pLevel.isClientSide) {
            EffectThrownPotion thrownpotion = new EffectThrownPotion((LivingEntity)pPlayer, pLevel);
            thrownpotion.setItem(itemstack);
            thrownpotion.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), -20.0f, 0.5f, 1.0f);
            pLevel.addFreshEntity((Entity)thrownpotion);
        }
        pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!pPlayer.hasInfiniteMaterials()) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
    }
}

