/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.spear;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.entity.projectile.DamageSettableProjectile;
import org.confluence.mod.common.entity.projectile.StormSpearShotProjectile;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.item.spear.AbstractSpearItem;
import software.bernie.geckolib.animation.EasingType;

public class StormSpearItem
extends AbstractSpearItem {
    public static final double knockBackScale = 0.3;
    public static final double knockBackMotionY = 0.1;

    public StormSpearItem() {
        super(new Item.Properties().attributes(StormSpearItem.attributes(3.0f, 7.0f)), ModRarity.BLUE, 15, 5, StormSpearItem.createKeyframes(AbstractSpearItem.K.of(0.0, 0.0, EasingType.LINEAR), AbstractSpearItem.K.of(0.25, 6.0, EasingType.EASE_OUT_BACK), AbstractSpearItem.K.of(0.5, -16.0, EasingType.EASE_IN_EXPO), AbstractSpearItem.K.of(0.75, 0.0, EasingType.LINEAR)));
    }

    @Override
    protected void onHitEntity(DamageSource damageSource, LivingEntity owner, Entity victim) {
        this.hurtVictim(damageSource, owner, victim);
        VectorUtils.knockBackA2B((Entity)owner, (Entity)victim, (double)0.3, (double)0.1);
    }

    @Override
    protected void onStingTick(ItemStack stack, ServerLevel level, LivingEntity owner, Vec3 tipPos, boolean last) {
        if (last) {
            Vec3 viewVector = owner.getViewVector(1.0f);
            StormSpearShotProjectile projectile = new StormSpearShotProjectile((EntityType<? extends DamageSettableProjectile>)((EntityType)ModEntities.STORM_SPEAR_SHOT_PROJECTILE.get()), (Level)level);
            projectile.setPos(owner.getX(), owner.getEyeY() - 0.1, owner.getZ());
            projectile.setDamage((float)owner.getAttributeValue(Attributes.ATTACK_DAMAGE) * 1.5f);
            projectile.shoot(viewVector.x, viewVector.y, viewVector.z, 1.16f, 0.0f);
            projectile.setOwner((Entity)owner);
            level.addFreshEntity((Entity)projectile);
        }
    }
}

