/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.sponsor;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.common.init.block.ModBlocks;

public class FailedSkullItem
extends StandingAndWallBlockItem
implements Equipable {
    public FailedSkullItem() {
        super((Block)ModBlocks.FAILED_SKULL_BLOCK.get(), (Block)ModBlocks.FAILED_SKULL_WALL_BLOCK.get(), new Item.Properties().fireResistant(), Direction.DOWN);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide && stack.is((Item)this) && slotId == 39 && entity instanceof Player) {
            Player player = (Player)entity;
            player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 20, 0, false, false));
            if (level.dimension() == Level.NETHER && !player.isCreative() && player.isAlive()) {
                List piglinList = level.getEntitiesOfClass(Piglin.class, player.getBoundingBox().inflate(8.0));
                for (Piglin piglin : piglinList) {
                    piglin.setTarget((LivingEntity)player);
                }
            }
        }
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(TooltipItem.getTooltipsFromString((String)"failed_skull", (int)1, (ChatFormatting)ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

