/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Calendar;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.confluence.mod.api.lunar.Lunar;
import org.confluence.mod.common.data.saved.DateStamp;
import org.confluence.mod.common.init.ModLootTables;
import org.confluence.mod.util.DateUtils;

public record DateLootItemCondition(boolean isLunar, DateStamp fromInclusive, DateStamp toInclusive) implements LootItemCondition
{
    public static final DateLootItemCondition HALLOWEENS = new DateLootItemCondition(false, new DateStamp(9, 10), new DateStamp(10, 1));
    public static final DateLootItemCondition CHRISTMAS = new DateLootItemCondition(false, new DateStamp(11, 15), new DateStamp(11, 31));
    public static final MapCodec<DateLootItemCondition> CODEC = Codec.mapEither((MapCodec)Codec.STRING.xmap(string -> {
        if ("halloweens".equals(string)) {
            return HALLOWEENS;
        }
        if ("christmas".equals(string)) {
            return CHRISTMAS;
        }
        throw new IllegalArgumentException("Unknown date " + string);
    }, condition -> {
        if (condition == HALLOWEENS) {
            return "halloweens";
        }
        if (condition == CHRISTMAS) {
            return "christmas";
        }
        throw new IllegalArgumentException("Unknown date " + String.valueOf(condition));
    }).fieldOf("preset"), (MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.lenientOptionalFieldOf("is_lunar", (Object)false).forGetter(DateLootItemCondition::isLunar), (App)DateStamp.CODEC.fieldOf("from_inclusive").forGetter(DateLootItemCondition::fromInclusive), (App)DateStamp.CODEC.fieldOf("to_inclusive").forGetter(DateLootItemCondition::toInclusive)).apply((Applicative)instance, DateLootItemCondition::new))).xmap(Either::unwrap, Either::right);

    public LootItemConditionType getType() {
        return ModLootTables.ItemConditions.DATE.get();
    }

    public boolean test(LootContext lootContext) {
        int day;
        int month;
        if (this.isLunar) {
            Lunar lunar = DateUtils.getLunar();
            month = Math.abs(lunar.getMonth());
            day = lunar.getDay();
        } else {
            Calendar calendar = DateUtils.getCalendar();
            month = calendar.get(2);
            day = calendar.get(5);
        }
        return month >= this.fromInclusive.month() && month <= this.toInclusive.month() && day >= this.fromInclusive.day() && day <= this.toInclusive.day();
    }

    @Override
    public String toString() {
        return "DateLootItemCondition{isLunar=" + this.isLunar + ", fromInclusive=" + String.valueOf(this.fromInclusive) + ", toInclusive=" + String.valueOf(this.toInclusive) + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        DateStamp dateStamp;
        boolean isLunar1;
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateLootItemCondition)) return false;
        DateLootItemCondition dateLootItemCondition = (DateLootItemCondition)o;
        try {
            boolean bl2;
            isLunar1 = bl2 = dateLootItemCondition.isLunar();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        DateStamp fromInclusive1 = dateStamp = dateLootItemCondition.fromInclusive();
        DateStamp toInclusive1 = dateStamp = dateLootItemCondition.toInclusive();
        if (isLunar1 != this.isLunar) return false;
        if (!fromInclusive1.equals(this.fromInclusive)) return false;
        if (!toInclusive1.equals(this.toInclusive)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * (31 + Boolean.hashCode(this.isLunar)) + this.fromInclusive.hashCode()) + this.toInclusive.hashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private boolean isLunar;
        private DateStamp fromInclusive;
        private DateStamp toInclusive;

        public Builder lunar() {
            this.isLunar = true;
            return this;
        }

        public Builder from(int month, int day) {
            this.fromInclusive = new DateStamp(month, day);
            return this;
        }

        public Builder to(int month, int day) {
            this.toInclusive = new DateStamp(month, day);
            return this;
        }

        public DateLootItemCondition build() {
            return new DateLootItemCondition(this.isLunar, this.fromInclusive, this.toInclusive);
        }
    }
}

