/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.Block;
import org.confluence.lib.common.menu.AmountResultSlot;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.EnvironmentLevelAccess;
import org.confluence.lib.common.recipe.EnvironmentRecipeInput;
import org.confluence.lib.common.recipe.MenuRecipeInput;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.recipe.CrystalBallRecipe;

public class CrystalBallMenu
extends AbstractContainerMenu {
    private final EnvironmentLevelAccess access;
    private final Player player;
    private final EnvironmentRecipeInput input;
    private final ResultContainer result;
    private final AmountResultSlot<CrystalBallRecipe> resultSlot;

    public CrystalBallMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, EnvironmentLevelAccess.empty());
    }

    public CrystalBallMenu(int containerId, Inventory inventory, EnvironmentLevelAccess access) {
        super(ModMenuTypes.CRYSTAL_BALL.get(), containerId);
        this.access = access;
        this.player = inventory.player;
        access.initializeIfNeeded(this.player);
        this.input = new EnvironmentRecipeInput((AbstractContainerMenu)this, 4, access);
        this.result = new ResultContainer();
        this.resultSlot = new AmountResultSlot((MenuRecipeInput)this.input, (Container)this.result, 0, 103, 35);
        this.addSlot((Slot)this.resultSlot);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot((Container)this.input, j + i * 2, 26 + j * 18, 26 + i * 18));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + k * 9 + 9, 8 + l * 18, 84 + k * 18));
            }
        }
        for (int m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)inventory, m, 8 + m * 18, 142));
        }
    }

    public void slotsChanged(Container container) {
        this.access.execute((level, pos) -> {
            Player patt0$temp = this.player;
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ItemStack itemStack = ItemStack.EMPTY;
                CrystalBallRecipe recipe = level.getRecipeManager().getRecipeFor(ModRecipes.CRYSTAL_BALL_TYPE.get(), (RecipeInput)this.input, level).map(RecipeHolder::value).orElse(null);
                if (recipe != null) {
                    itemStack = recipe.getResultItem(null).copy();
                    this.resultSlot.setCurrentRecipe((AbstractAmountRecipe)recipe);
                }
                this.result.setItem(0, itemStack);
                this.setRemoteSlot(0, itemStack);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, itemStack));
            }
        });
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return CrystalBallMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)FunctionalBlocks.CRYSTAL_BALL.get()));
    }

    public void removed(Player player) {
        super.removed(player);
        this.result.removeItemNoUpdate(0);
        this.access.execute((level, blockPos) -> this.clearContainer(player, (Container)this.input));
    }
}

