/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.confluence.lib.common.menu.ToggleSlot;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.menu.DyeToggleSlot;
import org.confluence.mod.common.menu.ToggleCurioSlot;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class ExtraInventoryMenu
extends AbstractContainerMenu {
    public final ExtraInventory extraInventory;
    public final int invStart;
    private final int hotBar;
    private final int invEnd;

    public ExtraInventoryMenu(int containerId, Inventory inventory) {
        super(ModMenuTypes.EXTRA_INVENTORY.get(), containerId);
        ICurioStacksHandler accessory;
        Player player = inventory.player;
        this.extraInventory = ExtraInventory.of((LivingEntity)player);
        Optional optional = CuriosApi.getCuriosInventory((LivingEntity)player);
        int count = this.extraInventory.getContainerSize();
        for (int i = 0; i < count; ++i) {
            int y;
            int x;
            int j;
            if (i < 4) {
                this.addSlot((Slot)new ToggleSlot(this, this.extraInventory, i, 8, i * 18 + 8){

                    public boolean mayPlace(ItemStack stack) {
                        Item item = stack.getItem();
                        if (item instanceof ArmorItem) {
                            ArmorItem armorItem = (ArmorItem)item;
                            EquipmentSlot equipmentSlot = armorItem.getEquipmentSlot();
                            int slotIndex = this.getSlotIndex();
                            if (slotIndex == 0) {
                                return equipmentSlot == EquipmentSlot.HEAD;
                            }
                            if (slotIndex == 1) {
                                return equipmentSlot == EquipmentSlot.CHEST;
                            }
                            if (slotIndex == 2) {
                                return equipmentSlot == EquipmentSlot.LEGS;
                            }
                            if (slotIndex == 3) {
                                return equipmentSlot == EquipmentSlot.FEET;
                            }
                        }
                        return false;
                    }

                    public boolean mayPickup(Player player) {
                        ItemStack itemstack = this.getItem();
                        return (itemstack.isEmpty() || player.isCreative() || !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) && super.mayPickup(player);
                    }
                });
                continue;
            }
            if (i < 8) {
                this.addSlot((Slot)new DyeToggleSlot(this.extraInventory, i, 8, (i - 4) * 18 + 8));
                continue;
            }
            if (i < 12) {
                this.addSlot(new Slot(this, this.extraInventory, i, 81, (i - 8) * 18 + 8){

                    public boolean mayPlace(ItemStack stack) {
                        return stack.is(ModTags.Items.COINS);
                    }
                });
                continue;
            }
            if (i < 16) {
                this.addSlot(new Slot(this, this.extraInventory, i, 99, (i - 12) * 18 + 8){

                    public boolean mayPlace(ItemStack stack) {
                        return stack.is(ModTags.Items.AMMO);
                    }
                });
                continue;
            }
            if (i < 21) {
                j = i - 16;
                x = j == 4 ? 148 : 121;
                y = j == 4 ? 8 : j * 18 + 8;
                this.addSlot((Slot)new ToggleSlot(this, this.extraInventory, i, x, y){

                    public boolean mayPlace(ItemStack stack) {
                        return stack.is(switch (j) {
                            case 1 -> ModTags.Items.LIGHT_PET;
                            case 2 -> ModTags.Items.MINECART;
                            case 3 -> ModTags.Items.HOOK;
                            case 4 -> ModTags.Items.MOUNT;
                            default -> ModTags.Items.PET;
                        });
                    }
                });
                continue;
            }
            if (i < 26) {
                j = i - 21;
                x = j == 4 ? 148 : 121;
                y = j == 4 ? 8 : j * 18 + 8;
                this.addSlot((Slot)new DyeToggleSlot(this.extraInventory, i, x, y));
                continue;
            }
            if (i < 27) {
                this.addSlot(new Slot((Container)this.extraInventory, i, 152, 166));
                continue;
            }
            this.addSlot((Slot)new DyeToggleSlot(this.extraInventory, i, -25, (i - 27) * 18 + 8));
        }
        if (optional.isPresent() && (accessory = (ICurioStacksHandler)((ICuriosItemHandler)optional.get()).getCurios().get("accessory")) != null) {
            ToggleCurioSlot.WrappedContainer container = new ToggleCurioSlot.WrappedContainer(accessory);
            count += accessory.getSlots();
            for (int j = 0; j < accessory.getSlots(); ++j) {
                this.addSlot(new ToggleCurioSlot(player, container, j, -25, j * 18 + 8));
            }
        }
        this.invStart = count;
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + k * 9 + 9, 8 + l * 18, 84 + k * 18));
            }
        }
        this.hotBar = this.invStart + 27;
        for (int m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)inventory, m, 8 + m * 18, 142));
        }
        this.invEnd = this.hotBar + 9;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= this.invStart - this.extraInventory.getSizeAccessoryDye() && index < this.invStart ? !this.moveItemStackTo(itemstack1, this.invStart, this.invEnd, false) : (index < this.extraInventory.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.invStart, this.invEnd, true) : !this.moveItemStackTo(itemstack1, 0, this.invStart, false) && (index < this.hotBar ? !this.moveItemStackTo(itemstack1, this.hotBar, this.invEnd, false) : index < this.invEnd && !this.moveItemStackTo(itemstack1, 8, this.hotBar, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        if (startIndex <= 26 && endIndex >= 26) {
            return super.moveItemStackTo(stack, startIndex, 26, reverseDirection) || super.moveItemStackTo(stack, 27, endIndex, reverseDirection);
        }
        return super.moveItemStackTo(stack, startIndex, endIndex, reverseDirection);
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        boolean isThrow;
        boolean bl = isThrow = clickType == ClickType.THROW;
        if (slotId >= 0 && slotId < this.slots.size() && (slotId == 26 || isThrow)) {
            ClickAction action = button == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
            Slot slot = (Slot)this.slots.get(isThrow ? 26 : slotId);
            ItemStack carried = isThrow ? ((Slot)this.slots.get(slotId)).getItem() : this.getCarried();
            ItemStack slotItem = slot.getItem();
            if (this.tryItemClickBehaviourOverride(player, action, slot, slotItem, carried)) {
                return;
            }
            if (isThrow) {
                slot.setByPlayer(carried);
                ((Slot)this.slots.get(slotId)).setByPlayer(ItemStack.EMPTY);
            } else if (carried.isEmpty()) {
                int j3 = action == ClickAction.PRIMARY ? slotItem.getCount() : (slotItem.getCount() + 1) / 2;
                Optional optional = slot.tryRemove(j3, Integer.MAX_VALUE, player);
                if (optional.isPresent()) {
                    ItemStack itemStack = (ItemStack)optional.get();
                    this.setCarried(itemStack);
                    slot.onTake(player, itemStack);
                }
            } else if (ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)slotItem)) {
                slotItem.grow(Math.min(slot.getMaxStackSize(slotItem) - slotItem.getCount(), carried.getCount()));
                this.setCarried(ItemStack.EMPTY);
            } else {
                slot.setByPlayer(carried);
                this.setCarried(ItemStack.EMPTY);
            }
        } else {
            super.clicked(slotId, button, clickType, player);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

