/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.recipe.FletchingTableRecipe;
import org.jetbrains.annotations.Nullable;

public class FletchingTableMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Player player;
    public final FletchingTableRecipe.Input input = new FletchingTableRecipe.Input(this);
    private final ResultContainer result = new ResultContainer();

    public FletchingTableMenu(int pContainerId, Inventory inventory) {
        this(pContainerId, inventory, ContainerLevelAccess.NULL);
    }

    public FletchingTableMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super(ModMenuTypes.FLETCHING_TABLE.get(), pContainerId);
        this.player = pPlayerInventory.player;
        this.access = pAccess;
        this.addSlot(new ResultSlot(this.input, (Container)this.result, 0, 124, 35));
        this.addSlot(new Slot((Container)this.input, 0, 30, 53));
        this.addSlot(new Slot((Container)this.input, 1, 48, 35));
        this.addSlot(new Slot((Container)this.input, 2, 66, 17));
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)pPlayerInventory, l + k * 9 + 9, 8 + l * 18, 84 + k * 18));
            }
        }
        for (int m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)pPlayerInventory, m, 8 + m * 18, 142));
        }
    }

    public void slotsChanged(Container pInventory) {
        this.access.execute((level, pos) -> {
            Player patt0$temp = this.player;
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                List recipes = this.player.level().getRecipeManager().getRecipesFor(ModRecipes.FLETCHING_TABLE_TYPE.get(), (RecipeInput)this.input, this.player.level());
                ItemStack itemStack = ItemStack.EMPTY;
                if (!recipes.isEmpty()) {
                    FletchingTableRecipe recipe = (FletchingTableRecipe)((RecipeHolder)recipes.getFirst()).value();
                    itemStack = recipe.getResultItem(null).copy();
                    this.setCurrentRecipe(recipe);
                }
                this.result.setItem(0, itemStack);
                this.setRemoteSlot(0, itemStack);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, itemStack));
            }
        });
    }

    private void setCurrentRecipe(FletchingTableRecipe recipe) {
        Slot slot = this.getSlot(0);
        if (slot instanceof ResultSlot) {
            ResultSlot amountResultSlot = (ResultSlot)slot;
            amountResultSlot.setCurrentRecipe(recipe);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                item.onCraftedBy(itemstack1, player.level(), player);
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index < 4 ? !this.moveItemStackTo(itemstack1, 4, 40, false) : (itemstack1.is(ItemTags.ARROWS) ? !this.moveItemStackTo(itemstack1, 2, 3, false) : !this.moveItemStackTo(itemstack1, 1, 4, false) && (index < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : index < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return FletchingTableMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)Blocks.FLETCHING_TABLE);
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.result.removeItemNoUpdate(0);
        this.access.execute((level, blockPos) -> this.clearContainer(pPlayer, (Container)this.input));
    }

    private static class ResultSlot
    extends Slot {
        protected final FletchingTableRecipe.Input input;
        @Nullable
        protected FletchingTableRecipe recipe;

        public ResultSlot(FletchingTableRecipe.Input input, Container result, int pSlot, int pX, int pY) {
            super(result, pSlot, pX, pY);
            this.input = input;
        }

        public void setCurrentRecipe(@Nullable FletchingTableRecipe recipe) {
            this.recipe = recipe;
        }

        public boolean mayPlace(ItemStack pStack) {
            return false;
        }

        public void onTake(Player pPlayer, ItemStack pStack) {
            if (this.recipe != null) {
                AbstractAmountRecipe.consumeShapeless((RecipeInput)this.input, this.recipe.getIngredients());
                this.input.setChanged();
            }
        }

        public boolean isFake() {
            return true;
        }
    }

    public static class Provider
    implements MenuProvider {
        private final Level level;
        private final BlockPos pos;

        public Provider(Level level, BlockPos pos) {
            this.level = level;
            this.pos = pos;
        }

        public Component getDisplayName() {
            return Component.translatable((String)"container.confluence.fletching_table");
        }

        @Nullable
        public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
            return new FletchingTableMenu(containerId, inventory, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.pos));
        }
    }
}

