/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.confluence.mod.common.component.prefix.ModPrefix;
import org.confluence.mod.common.component.prefix.PrefixType;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.mod.util.PrefixUtils;

public class NPCReforgeMenu
extends AbstractContainerMenu {
    public static final int DATA_PREFIX_TYPE = 0;
    public static final int DATA_PREFIX_ID = 1;
    public static final int DATA_REFORGE_COST = 2;
    private final Player player;
    private final int[] data = new int[]{PrefixType.UNKNOWN.ordinal(), -1, 0x3F3F3F3F};
    public final SimpleContainer container = new SimpleContainer(1);

    public NPCReforgeMenu(int containerId, Inventory inventory) {
        super(ModMenuTypes.REFORGE_MENU.get(), containerId);
        this.player = inventory.player;
        this.container.addListener(this::slotsChanged);
        this.addSlot(new Slot(this, (Container)this.container, 0, 39, 44){

            public boolean mayPlace(ItemStack itemStack) {
                return PrefixUtils.couldReforge(itemStack);
            }

            public void setChanged() {
            }
        });
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + k * 9 + 9, 8 + l * 18, 84 + k * 18));
            }
        }
        for (int m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)inventory, m, 8 + m * 18, 142));
        }
        this.addDataSlot(DataSlot.shared((int[])this.data, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.data, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.data, (int)2));
    }

    public void slotsChanged(Container container) {
        if (!this.player.level().isClientSide) {
            ItemStack itemStack = this.getReforgeItem();
            if (PrefixUtils.couldReforge(itemStack)) {
                RandomSource randomSource = RandomSource.create((long)(itemStack.hashCode() | this.player.getRandom().nextInt()));
                PrefixType prefixType = PrefixUtils.getPrefixType(itemStack);
                this.data[0] = prefixType.ordinal();
                this.data[1] = (Integer)ModPrefix.ID_MAP.inverse().getOrDefault((Object)prefixType.randomPrefix(randomSource), (Object)-1);
                this.data[2] = PrefixUtils.getReforgeCost(this.player, itemStack);
            } else {
                this.data[0] = PrefixType.UNKNOWN.ordinal();
                this.data[1] = -1;
                this.data[2] = 0x3F3F3F3F;
            }
        }
        super.slotsChanged(container);
    }

    public boolean clickMenuButton(Player player, int id) {
        int cost = this.data[2];
        if (cost >= 0x3F3F3F3F) {
            return false;
        }
        PrefixType prefixType = PrefixType.byId(this.data[0]);
        if (prefixType == PrefixType.UNKNOWN) {
            return false;
        }
        ItemStack itemStack = this.getReforgeItem();
        if (PrefixUtils.couldReforge(itemStack)) {
            ModPrefix modPrefix = (ModPrefix)ModPrefix.ID_MAP.get((Object)this.data[1]);
            if (modPrefix == null) {
                return false;
            }
            if (!(player instanceof ServerPlayer)) {
                return PlayerUtils.getMoney(player, true) >= (long)cost;
            }
            if (!PlayerUtils.tryCostMoney(player, cost, true)) {
                return false;
            }
            PrefixUtils.setAndUpdate(itemStack, prefixType, modPrefix);
            this.setRemoteSlot(0, itemStack);
            ((ServerPlayer)player).connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, itemStack));
            this.slotsChanged((Container)this.container);
        }
        return true;
    }

    public ItemStack getReforgeItem() {
        return this.container.getItem(0);
    }

    public int getCost() {
        return this.data[2];
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0 ? !this.moveItemStackTo(itemstack1, 1, 37, false) : (PrefixUtils.couldReforge(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index >= 1 && index < 28 ? !this.moveItemStackTo(itemstack1, 28, 37, false) : index >= 28 && index < 38 && !this.moveItemStackTo(itemstack1, 1, 28, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, (Container)this.container);
    }
}

