/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.init.ModParticleTypes;
import org.confluence.mod.mixed.IDamageSource;
import org.confluence.terraentity.entity.boss.wallofflesh.WallOfFlesh;

public record DamageIndicatorOptions(Component text, boolean big, Type type) implements ParticleOptions
{
    public static final MapCodec<DamageIndicatorOptions> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("text").forGetter(DamageIndicatorOptions::text), (App)Codec.BOOL.fieldOf("big").forGetter(DamageIndicatorOptions::big), (App)Type.CODEC.fieldOf("type").forGetter(DamageIndicatorOptions::type)).apply((Applicative)instance, DamageIndicatorOptions::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DamageIndicatorOptions> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, DamageIndicatorOptions::text, (StreamCodec)ByteBufCodecs.BOOL, DamageIndicatorOptions::big, Type.STREAM_CODEC, DamageIndicatorOptions::type, DamageIndicatorOptions::new);

    public ParticleType<DamageIndicatorOptions> getType() {
        return ModParticleTypes.DAMAGE_INDICATOR.get();
    }

    public static void sendDamageParticle(ServerLevel level, DamageSource damageSource, float amount, LivingEntity victim) {
        double y;
        Vec3 pos;
        String text;
        if (damageSource.is(DamageTypes.GENERIC_KILL)) {
            return;
        }
        float roundedAmount = (float)Math.round(amount * 10.0f) / 10.0f;
        int intAmount = (int)roundedAmount;
        if (roundedAmount == 0.0f) {
            return;
        }
        String string = text = roundedAmount % 1.0f == 0.0f ? String.valueOf(intAmount) : String.valueOf(roundedAmount);
        if (victim instanceof WallOfFlesh) {
            Vec3 sourcePosition = Objects.requireNonNullElseGet(damageSource.getSourcePosition(), () -> ((LivingEntity)victim).position());
            if (damageSource.getEntity() == null) {
                pos = sourcePosition;
            } else {
                Vec3 directPos2AttackerPos = damageSource.getEntity().position().subtract(sourcePosition).normalize().scale(victim.getDeltaMovement().length() * 20.0);
                pos = sourcePosition.add(directPos2AttackerPos);
            }
            y = pos.y;
        } else {
            pos = victim.position();
            y = victim.getBoundingBoxForCulling().maxY;
        }
        boolean crit = ((IDamageSource)damageSource).confluence$isCritical();
        MutableComponent component = Component.literal((String)text).withStyle(new ChatFormatting[]{crit ? ChatFormatting.DARK_RED : ChatFormatting.GOLD, ChatFormatting.BOLD});
        level.sendParticles((ParticleOptions)new DamageIndicatorOptions((Component)component, crit, Type.DAMAGE), pos.x, y, pos.z, 1, 0.1, 0.1, 0.1, 0.0);
    }

    public static void sendHealParticle(float amount, ServerLevel level, LivingEntity living) {
        if (living.getHealth() < living.getMaxHealth()) {
            double y = living.getBoundingBoxForCulling().maxY;
            Vec3 pos = living.position();
            String text = (amount = (float)Math.round(amount * 10.0f) / 10.0f) % 1.0f == 0.0f ? Integer.toString((int)amount) : Float.toString(amount);
            MutableComponent component = Component.literal((String)text).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD});
            level.sendParticles((ParticleOptions)new DamageIndicatorOptions((Component)component, false, Type.HEAL), pos.x, y, pos.z, 1, 0.1, 0.1, 0.1, 0.0);
        }
    }

    public static enum Type {
        DAMAGE,
        HEAL,
        OTHER;

        public static final Codec<Type> CODEC;
        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;

        public static Type byId(byte i) {
            return i == 0 ? DAMAGE : (i == 1 ? HEAL : OTHER);
        }

        static {
            CODEC = Codec.BYTE.xmap(Type::byId, t -> (byte)t.ordinal());
            STREAM_CODEC = ByteBufCodecs.BYTE.map(Type::byId, t -> (byte)t.ordinal());
        }
    }
}

