/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.AmountIngredient;
import org.confluence.lib.common.recipe.SimpleRecipeSerializer;
import org.confluence.lib.util.LibStreamCodecUtils;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class CookingPotRecipe
extends AbstractAmountRecipe<Input> {
    private final Ingredient container;
    private final HeatSourcePredicate heatSource;
    private final int cookingTime;

    public CookingPotRecipe(ItemStack result, NonNullList<Ingredient> ingredients, Ingredient container, HeatSourcePredicate heatSource, int cookingTime) {
        super(result, ingredients);
        this.container = container;
        this.heatSource = heatSource;
        this.cookingTime = cookingTime;
    }

    public boolean matches(Input input, Level pLevel) {
        return this.heatSource.matches(input.heatSource) && this.container.test(input.container) && super.matches((RecipeInput)input, pLevel);
    }

    public Ingredient getContainer() {
        return this.container;
    }

    public HeatSourcePredicate getHeatSource() {
        return this.heatSource;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    protected int maxIngredientSize() {
        return 4;
    }

    public String getGroup() {
        return "cooking_pot";
    }

    public ItemStack getToastSymbol() {
        return FunctionalBlocks.COOKING_POT.toStack();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.COOKING_POT_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ModRecipes.COOKING_POT_TYPE.get();
    }

    public record HeatSourcePredicate(Optional<Either<TagKey<Block>, HolderSet<Block>>> blocks, Optional<StatePropertiesPredicate> properties, Optional<NbtPredicate> nbt) {
        public static final HeatSourcePredicate EMPTY = new HeatSourcePredicate(Optional.empty(), Optional.empty(), Optional.empty());
        public static final Codec<HeatSourcePredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)TagKey.codec((ResourceKey)Registries.BLOCK), (Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK, (boolean)true)).optionalFieldOf("blocks").forGetter(HeatSourcePredicate::blocks), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("state").forGetter(HeatSourcePredicate::properties), (App)NbtPredicate.CODEC.optionalFieldOf("nbt").forGetter(HeatSourcePredicate::nbt)).apply((Applicative)instance, HeatSourcePredicate::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, HeatSourcePredicate> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.either((StreamCodec)LibStreamCodecUtils.tagKey((ResourceKey)Registries.BLOCK), (StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BLOCK))), HeatSourcePredicate::blocks, (StreamCodec)ByteBufCodecs.optional((StreamCodec)StatePropertiesPredicate.STREAM_CODEC), HeatSourcePredicate::properties, (StreamCodec)ByteBufCodecs.optional((StreamCodec)NbtPredicate.STREAM_CODEC), HeatSourcePredicate::nbt, HeatSourcePredicate::new);

        public boolean matches(BlockInWorld block) {
            return this.matchesState(block.getState()) && this.matchesBlockEntity(block.getLevel(), block.getEntity());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean matchesState(BlockState state) {
            if (!this.blocks.isEmpty()) {
                if ((Boolean)this.blocks.get().map(arg_0 -> ((BlockState)state).is(arg_0), arg_0 -> ((BlockState)state).is(arg_0)) == false) return false;
            }
            if (this.properties.isEmpty()) return true;
            if (!this.properties.get().matches(state)) return false;
            return true;
        }

        private boolean matchesBlockEntity(LevelReader level, @Nullable BlockEntity blockEntity) {
            return this.nbt.isEmpty() || blockEntity != null && this.nbt.get().matches((Tag)blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess()));
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Optional<Either<TagKey<Block>, HolderSet<Block>>> blocks = Optional.empty();
            private Optional<StatePropertiesPredicate> properties = Optional.empty();
            private Optional<NbtPredicate> nbt = Optional.empty();

            private Builder() {
            }

            public Builder of(TagKey<Block> tag) {
                this.blocks = Optional.of(Either.left(tag));
                return this;
            }

            public Builder of(HolderSet<Block> set) {
                this.blocks = Optional.of(Either.right(set));
                return this;
            }

            public Builder of(Block ... set) {
                this.blocks = Optional.of(Either.right((Object)HolderSet.direct(Block::builtInRegistryHolder, (Object[])set)));
                return this;
            }

            public Builder hasNbt(CompoundTag nbt) {
                this.nbt = Optional.of(new NbtPredicate(nbt));
                return this;
            }

            public Builder setProperties(StatePropertiesPredicate.Builder properties) {
                this.properties = properties.build();
                return this;
            }

            public HeatSourcePredicate build() {
                return new HeatSourcePredicate(this.blocks, this.properties, this.nbt);
            }
        }
    }

    public static class Input
    implements RecipeInput {
        private final ItemStack[] items;
        final ItemStack container;
        final BlockInWorld heatSource;

        public Input(ItemStack[] items, ItemStack container, BlockInWorld heatSource) {
            this.items = items;
            this.container = container;
            this.heatSource = heatSource;
        }

        public ItemStack getItem(int index) {
            return this.items[index];
        }

        public int size() {
            return this.items.length;
        }
    }

    public static class Serializer
    extends SimpleRecipeSerializer<CookingPotRecipe> {
        protected MapCodec<CookingPotRecipe> getCodec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)AbstractAmountRecipe.INGREDIENTS_CODEC.forGetter(recipe -> recipe.ingredients), (App)Ingredient.CODEC.fieldOf("container").forGetter(recipe -> recipe.container), (App)HeatSourcePredicate.CODEC.fieldOf("heat_source").forGetter(recipe -> recipe.heatSource), (App)Codec.INT.fieldOf("cookingtime").forGetter(recipe -> recipe.cookingTime)).apply((Applicative)instance, CookingPotRecipe::new));
        }

        protected StreamCodec<RegistryFriendlyByteBuf, CookingPotRecipe> getStreamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, CookingPotRecipe>(this){

                public CookingPotRecipe decode(RegistryFriendlyByteBuf buffer) {
                    int size = buffer.readVarInt();
                    NonNullList nonnulllist = NonNullList.withSize((int)size, (Object)AmountIngredient.EMPTY);
                    nonnulllist.replaceAll(ignore -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
                    ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                    Ingredient container = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
                    HeatSourcePredicate heatSource = (HeatSourcePredicate)HeatSourcePredicate.STREAM_CODEC.decode((Object)buffer);
                    return new CookingPotRecipe(itemstack, (NonNullList<Ingredient>)nonnulllist, container, heatSource, buffer.readVarInt());
                }

                public void encode(RegistryFriendlyByteBuf buffer, CookingPotRecipe recipe) {
                    buffer.writeVarInt(recipe.ingredients.size());
                    for (Ingredient ingredient : recipe.ingredients) {
                        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
                    }
                    ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.container);
                    HeatSourcePredicate.STREAM_CODEC.encode((Object)buffer, (Object)recipe.heatSource);
                    buffer.writeVarInt(recipe.cookingTime);
                }
            };
        }
    }
}

