/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.mod.common.init.ModBiomes;
import org.confluence.mod.mixed.IMinecraftServer;

public class BannedBiomeMultiNoiseBiomeSource
extends MultiNoiseBiomeSource {
    private final ResourceKey<Biome> bannedBiome;
    private final ResourceKey<Biome> targetBiome;
    private Holder<Biome> target;
    private Holder<Biome> protection;

    public BannedBiomeMultiNoiseBiomeSource(MultiNoiseBiomeSource biomeSource, ResourceKey<Biome> bannedBiome, ResourceKey<Biome> targetBiome) {
        super(biomeSource.parameters);
        this.bannedBiome = bannedBiome;
        this.targetBiome = targetBiome;
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler) {
        Holder biome = super.getNoiseBiome(x, y, z, sampler);
        if (this.target == null || this.protection == null) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return biome;
            }
            if (this.targetBiome.equals(ModBiomes.THE_CORRUPTION)) {
                IMinecraftServer.of(server).confluence$updateSecretFlag(1L);
            } else if (this.targetBiome.equals(ModBiomes.THE_CRIMSON)) {
                IMinecraftServer.of(server).confluence$updateSecretFlag(2L);
            }
            this.target = server.registryAccess().holderOrThrow(this.targetBiome);
            this.protection = server.registryAccess().holderOrThrow(Biomes.PLAINS);
        }
        if (biome.is(this.bannedBiome)) {
            BlockPos spawnPos = ServerLifecycleHooks.getCurrentServer().getWorldData().overworldData().getSpawnPos();
            if (Math.abs((spawnPos.getX() >> 2) - x) <= 50 || Math.abs((spawnPos.getZ() >> 2) - z) <= 50) {
                return this.protection;
            }
            return this.target;
        }
        return biome;
    }

    public ResourceKey<Biome> getBannedBiome() {
        return this.bannedBiome;
    }
}

