/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.carver;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.block.natural.ShadowOrbBlock;
import org.confluence.mod.common.init.ModBiomes;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.joml.Vector3d;

public class DemonicCaveCarver
extends WorldCarver<Config> {
    public DemonicCaveCarver(Codec<Config> codec) {
        super(codec);
    }

    public boolean carve(CarvingContext context, Config config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> biomeAccessor, RandomSource random, Aquifer aquifer, ChunkPos chunkPos, CarvingMask carvingMask) {
        int z2;
        int y2;
        int z1;
        int y1;
        int x1 = chunkPos.getBlockX((int)config.verticalLength.sample(random) * (random.nextBoolean() ? -1 : 1));
        if (!biomeAccessor.apply(new BlockPos(x1, y1 = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x1, z1 = chunkPos.getBlockZ((int)config.verticalLength.sample(random) * (random.nextBoolean() ? -1 : 1))), z1)).is(ModBiomes.THE_CORRUPTION) || !chunk.getFluidState(new BlockPos(x1, chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x1, z1) - 1, z1)).isEmpty()) {
            return false;
        }
        int x2 = chunkPos.getBlockX((int)config.verticalLength.sample(random) * (random.nextBoolean() ? -1 : 1));
        if (!biomeAccessor.apply(new BlockPos(x2, y2 = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x2, z2 = chunkPos.getBlockZ((int)config.verticalLength.sample(random) * (random.nextBoolean() ? -1 : 1))), z2)).is(ModBiomes.THE_CORRUPTION) || !chunk.getFluidState(new BlockPos(x2, chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x2, z2) - 1, z2)).isEmpty()) {
            return false;
        }
        float yScale = config.yScale.sample(random);
        Aquifer noWater = new Aquifer(this){
            final BlockState air = Blocks.AIR.defaultBlockState();

            public BlockState computeSubstance(DensityFunction.FunctionContext context, double substance) {
                return this.air;
            }

            public boolean shouldScheduleFluidUpdate() {
                return true;
            }
        };
        ArrayList positions = Lists.newArrayList((Object[])new Vector3d[]{new Vector3d((double)x1, (double)y1, (double)z1), new Vector3d((double)x2, (double)y2, (double)z2)});
        VectorUtils.lightningPathList((List)positions, (double)2.5, (float)0.125f, (RandomSource)random);
        int size = positions.size();
        for (int i = 0; i < size; ++i) {
            Vector3d position = (Vector3d)positions.get(i);
            float delta = Math.abs((float)i - (float)size * 0.5f) / (float)size;
            for (int j = -4; j < 13; ++j) {
                int maxRadius = random.nextInt(9) + 4;
                int radius = maxRadius - Mth.lerpInt((float)delta, (int)8, (int)maxRadius);
                boolean b = this.carveEllipsoid(context, config, chunk, biomeAccessor, noWater, position.x, position.y - (double)((float)j * yScale), position.z, radius, yScale + 4.0f, carvingMask, (context1, relativeX, relativeY, relativeZ, y) -> false);
                if (!b || j != 12 || !(random.nextFloat() < 0.25f)) continue;
                position.add(0.0, (double)(-14.0f * yScale - 4.0f), 0.0);
                b = this.carveEllipsoid(context, config, chunk, biomeAccessor, noWater, position.x, position.y, position.z, 2.0, 2.0, carvingMask, (context1, relativeX, relativeY, relativeZ, y) -> relativeX * relativeX + relativeY * relativeY + relativeZ * relativeZ > 1.0);
                if (!b) continue;
                chunk.setBlockState(VectorUtils.fromVector3d((Vector3d)position).above(), ((ShadowOrbBlock)((Object)NatureBlocks.SHADOW_ORB.get())).defaultBlockState(), false);
            }
        }
        return true;
    }

    public boolean isStartChunk(Config config, RandomSource random) {
        return random.nextFloat() < config.probability;
    }

    public static class Config
    extends CarverConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CarverConfiguration.CODEC.forGetter(config -> config), (App)FloatProvider.codec((float)0.0f, (float)127.0f).fieldOf("vertical_length").forGetter(config -> config.verticalLength)).apply((Applicative)instance, Config::new));
        private final FloatProvider verticalLength;

        public Config(CarverConfiguration baseConfig, FloatProvider verticalLength) {
            super(baseConfig.probability, baseConfig.y, baseConfig.yScale, baseConfig.lavaLevel, baseConfig.debugSettings, baseConfig.replaceable);
            this.verticalLength = verticalLength;
        }
    }
}

