/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.carver;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.init.block.NatureBlocks;

public class DesertCaveCarver
extends WorldCarver<CarverConfiguration> {
    public DesertCaveCarver(Codec<CarverConfiguration> codec) {
        super(codec);
    }

    public boolean carve(CarvingContext context, CarverConfiguration config, final ChunkAccess chunk, Function<BlockPos, Holder<Biome>> biomeAccessor, RandomSource random, Aquifer aquifer, ChunkPos chunkPos, CarvingMask carvingMask) {
        float y = config.y.sample(random, (WorldGenerationContext)context);
        float yScale = config.yScale.sample(random);
        BlockPos position = chunkPos.getMiddleBlockPosition((int)y);
        BlockState blockState = chunk.getBlockState(position);
        if (blockState.isAir() || blockState.liquid()) {
            return false;
        }
        blockState = chunk.getBlockState(position.above((int)yScale));
        if (blockState.isAir() || blockState.liquid()) {
            return false;
        }
        Aquifer inner = new Aquifer(this){
            final BlockState air = Blocks.AIR.defaultBlockState();

            public BlockState computeSubstance(DensityFunction.FunctionContext context, double substance) {
                return this.air;
            }

            public boolean shouldScheduleFluidUpdate() {
                return true;
            }
        };
        Aquifer outer = new Aquifer(){
            final BlockState stone = ((Block)NatureBlocks.HARDENED_SAND_BLOCK.get()).defaultBlockState();
            final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

            public BlockState computeSubstance(DensityFunction.FunctionContext context, double substance) {
                if (chunk.getBlockState((BlockPos)this.pos.set(context.blockX(), context.blockY(), context.blockX())).isAir()) {
                    return null;
                }
                return context.getBlender().blendDensity(context, substance) < substance * 0.3 ? null : this.stone;
            }

            public boolean shouldScheduleFluidUpdate() {
                return false;
            }
        };
        WorldCarver.CarveSkipChecker ichecker = (context1, relativeX, relativeY, relativeZ, y1) -> relativeX * relativeX + relativeY * relativeY + relativeZ * relativeZ > 1.5;
        WorldCarver.CarveSkipChecker ochecker = (context1, relativeX, relativeY, relativeZ, y1) -> {
            double ry = Math.abs(relativeY);
            return ry > 1.0 && relativeX * relativeX + relativeZ * relativeZ > ry * 0.6;
        };
        int j = (int)((y - (float)context.getMinGenY()) / yScale);
        for (int k = 0; k < 4; ++k) {
            Vec2 vec2;
            Vec3 vec3;
            int i;
            ArrayList<Vec3> positions = new ArrayList<Vec3>();
            ArrayList<Vec2> radius = new ArrayList<Vec2>();
            for (i = 0; i < j; ++i) {
                vec3 = new Vec3((double)chunkPos.getMiddleBlockX() + Mth.nextDouble((RandomSource)random, (double)-16.0, (double)16.0), (double)(y - (float)i * yScale) - Mth.nextDouble((RandomSource)random, (double)(-yScale), (double)yScale), (double)chunkPos.getMiddleBlockZ() + Mth.nextDouble((RandomSource)random, (double)-16.0, (double)16.0));
                vec2 = new Vec2(Mth.nextFloat((RandomSource)random, (float)6.0f, (float)8.0f), Mth.nextFloat((RandomSource)random, (float)2.0f, (float)3.0f));
                positions.add(vec3);
                radius.add(vec2);
                this.carveEllipsoid(context, config, chunk, biomeAccessor, outer, vec3.x, vec3.y, vec3.z, vec2.x + 1.0f, vec2.y + 1.0f, new CarvingMask(chunk.getHeight(), chunk.getMinBuildHeight()), ochecker);
            }
            for (i = 0; i < j; ++i) {
                vec3 = (Vec3)positions.get(i);
                vec2 = (Vec2)radius.get(i);
                this.carveEllipsoid(context, config, chunk, biomeAccessor, inner, vec3.x, vec3.y, vec3.z, vec2.x - 1.0f, vec2.y, new CarvingMask(chunk.getHeight(), chunk.getMinBuildHeight()), ichecker);
            }
        }
        return true;
    }

    public boolean isStartChunk(CarverConfiguration config, RandomSource random) {
        return true;
    }
}

