/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class BranchTreeFeature
extends Feature<Config> {
    public BranchTreeFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        int i;
        RandomSource random = pContext.random();
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        BlockPos basePos = pContext.origin();
        BlockPos checkPos = basePos.offset(-3, 0, -3);
        BlockState trunkBlockState = config.trunk().getState(random, basePos);
        BlockState branchBlockState = config.branch().getState(random, basePos);
        int height = config.height + random.nextInt(3);
        int branchLength = config.branchHeight;
        boolean placed = true;
        boolean placeBranch = true;
        ArrayList<BlockPos> branchPos = new ArrayList<BlockPos>();
        for (i = 0; i < height; ++i) {
            placed = level.getBlockState(basePos.offset(0, i, 0)).isAir() && placed;
        }
        if (placed) {
            for (i = 0; i < height; ++i) {
                level.setBlock(basePos.offset(0, i, 0), trunkBlockState, 3);
            }
            BranchTreeFeature.branch(2, branchLength, placeBranch, branchPos, basePos.offset(0, height - 4, 0), branchBlockState, random, level);
            for (int x = 0; x < 7; ++x) {
                for (int z = 0; z < 7; ++z) {
                    for (int y = 0; y < height + branchLength + 6; ++y) {
                        BlockPos checkPosBranch = checkPos.offset(x, y, z);
                        if (!level.getBlockState(checkPosBranch).is(branchBlockState.getBlock())) continue;
                        if (level.getBlockState(checkPosBranch.offset(0, -1, 0)).is(branchBlockState.getBlock()) || level.getBlockState(checkPosBranch.offset(0, -1, 0)).is(trunkBlockState.getBlock())) {
                            level.setBlock(checkPosBranch, (BlockState)level.getBlockState(checkPosBranch).trySetValue((Property)PipeBlock.DOWN, (Comparable)Boolean.TRUE), 3);
                        } else {
                            if (level.getBlockState(checkPosBranch.offset(1, 0, 0)).is(branchBlockState.getBlock()) || level.getBlockState(checkPosBranch.offset(1, 0, 0)).is(trunkBlockState.getBlock())) {
                                level.setBlock(checkPosBranch, (BlockState)level.getBlockState(checkPosBranch).trySetValue((Property)PipeBlock.EAST, (Comparable)Boolean.TRUE), 3);
                                if (level.getBlockState(checkPosBranch.offset(1, 0, 0)).is(branchBlockState.getBlock())) {
                                    level.setBlock(checkPosBranch.offset(1, 0, 0), (BlockState)level.getBlockState(checkPosBranch.offset(1, 0, 0)).trySetValue((Property)PipeBlock.WEST, (Comparable)Boolean.TRUE), 3);
                                }
                            }
                            if (level.getBlockState(checkPosBranch.offset(0, 0, 1)).is(branchBlockState.getBlock()) || level.getBlockState(checkPosBranch.offset(0, 0, 1)).is(trunkBlockState.getBlock())) {
                                level.setBlock(checkPosBranch, (BlockState)level.getBlockState(checkPosBranch).trySetValue((Property)PipeBlock.SOUTH, (Comparable)Boolean.TRUE), 3);
                                if (level.getBlockState(checkPosBranch.offset(0, 0, 1)).is(branchBlockState.getBlock())) {
                                    level.setBlock(checkPosBranch.offset(0, 0, 1), (BlockState)level.getBlockState(checkPosBranch.offset(0, 0, 1)).trySetValue((Property)PipeBlock.NORTH, (Comparable)Boolean.TRUE), 3);
                                }
                            }
                            if (level.getBlockState(checkPosBranch.offset(-1, 0, 0)).is(branchBlockState.getBlock()) || level.getBlockState(checkPosBranch.offset(-1, 0, 0)).is(trunkBlockState.getBlock())) {
                                level.setBlock(checkPosBranch, (BlockState)level.getBlockState(checkPosBranch).trySetValue((Property)PipeBlock.WEST, (Comparable)Boolean.TRUE), 3);
                                if (level.getBlockState(checkPosBranch.offset(-1, 0, 0)).is(branchBlockState.getBlock())) {
                                    level.setBlock(checkPosBranch.offset(-1, 0, 0), (BlockState)level.getBlockState(checkPosBranch.offset(-1, 0, 0)).trySetValue((Property)PipeBlock.EAST, (Comparable)Boolean.TRUE), 3);
                                }
                            }
                            if (level.getBlockState(checkPosBranch.offset(0, 0, -1)).is(branchBlockState.getBlock()) || level.getBlockState(checkPosBranch.offset(0, 0, -1)).is(trunkBlockState.getBlock())) {
                                level.setBlock(checkPosBranch, (BlockState)level.getBlockState(checkPosBranch).trySetValue((Property)PipeBlock.NORTH, (Comparable)Boolean.TRUE), 3);
                                if (level.getBlockState(checkPosBranch.offset(0, 0, -1)).is(branchBlockState.getBlock())) {
                                    level.setBlock(checkPosBranch.offset(0, 0, -1), (BlockState)level.getBlockState(checkPosBranch.offset(0, 0, -1)).trySetValue((Property)PipeBlock.SOUTH, (Comparable)Boolean.TRUE), 3);
                                }
                            }
                        }
                        if (!level.getBlockState(checkPosBranch.offset(0, 1, 0)).is(branchBlockState.getBlock()) && !level.getBlockState(checkPosBranch.offset(0, 1, 0)).is(trunkBlockState.getBlock())) continue;
                        level.setBlock(checkPosBranch, (BlockState)level.getBlockState(checkPosBranch).trySetValue((Property)PipeBlock.UP, (Comparable)Boolean.TRUE), 3);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static void branch(int layer, int branchLength, boolean set, List<BlockPos> branchPos, BlockPos trunkPos, BlockState branchBlockState, RandomSource random, WorldGenLevel level) {
        int length = (int)Math.pow(2.0, layer - 1);
        if (layer > 0) {
            for (int j = 0; j < 4; ++j) {
                branchPos.clear();
                BlockPos lengthSet = trunkPos.offset((int)((float)length * Mth.cos((float)((float)j * (float)Math.PI / 2.0f))), random.nextInt(2), (int)((float)length * Mth.sin((float)((float)j * (float)Math.PI / 2.0f))));
                int x = trunkPos.getX() - lengthSet.getX();
                int y = branchLength + layer + random.nextInt(2);
                int z = trunkPos.getZ() - lengthSet.getZ();
                set = level.getBlockState(lengthSet).isAir() || level.getBlockState(lengthSet).is(branchBlockState.getBlock());
                branchPos.add(lengthSet);
                if (!set) continue;
                for (int xCheck = x; xCheck != 0; xCheck -= x / Math.abs(x)) {
                    if (x == xCheck) continue;
                    set = (level.getBlockState(lengthSet.offset(xCheck, 0, 0)).isAir() || level.getBlockState(lengthSet.offset(xCheck, 0, 0)).is(branchBlockState.getBlock())) && set;
                    branchPos.add(lengthSet.offset(xCheck, 0, 0));
                }
                for (int yCheck = y; yCheck != 0; yCheck -= y / Math.abs(y)) {
                    set = (level.getBlockState(lengthSet.offset(0, yCheck, 0)).isAir() || level.getBlockState(lengthSet.offset(0, yCheck, 0)).is(branchBlockState.getBlock())) && set;
                    branchPos.add(lengthSet.offset(0, yCheck, 0));
                }
                for (int zCheck = z; zCheck != 0; zCheck -= z / Math.abs(z)) {
                    if (z == zCheck) continue;
                    set = (level.getBlockState(lengthSet.offset(0, 0, zCheck)).isAir() || level.getBlockState(lengthSet.offset(0, 0, zCheck)).is(branchBlockState.getBlock())) && set;
                    branchPos.add(lengthSet.offset(0, 0, zCheck));
                }
                if (!set) continue;
                for (int k = 0; k < branchPos.size(); ++k) {
                    level.setBlock(branchPos.get(k), branchBlockState, 3);
                }
                BranchTreeFeature.branch(layer - 1, branchLength, set, branchPos, lengthSet, branchBlockState, random, level);
            }
        }
    }

    public record Config(BlockStateProvider trunk, BlockStateProvider branch, int height, int branchHeight) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("trunk_block").forGetter(Config::trunk), (App)BlockStateProvider.CODEC.fieldOf("branch_block").forGetter(Config::branch), (App)Codec.INT.fieldOf("height").forGetter(Config::height), (App)Codec.INT.fieldOf("branch_height").forGetter(Config::branchHeight)).apply((Applicative)instance, Config::new));
    }
}

