/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.confluence.mod.common.block.natural.CattailBlock;

public class CattailsFeature
extends Feature<Config> {
    public CattailsFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        RandomSource random = context.random();
        Config config = (Config)context.config();
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        BlockState cattailState = config.cattail.getState(random, origin);
        if (!(cattailState.getBlock() instanceof CattailBlock)) {
            return false;
        }
        int placed = 0;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        Direction dir = Direction.WEST;
        Direction.Axis axis = dir.getAxis();
        int lx = dir.getStepX();
        int lz = dir.getStepZ();
        int x = 0;
        int z = 0;
        int s = 1;
        for (int i = 0; i < config.maxCheck; ++i) {
            if (random.nextFloat() > config.chance) continue;
            currentPos.setWithOffset((Vec3i)origin, x, 0, z);
            if (level.getFluidState((BlockPos)currentPos).is(FluidTags.WATER)) {
                while (level.getFluidState((BlockPos)currentPos).is(FluidTags.WATER) && currentPos.getY() > level.getMinBuildHeight()) {
                    currentPos.move(Direction.DOWN);
                }
                BlockPos basePos = currentPos.above();
                if (cattailState.canSurvive((LevelReader)level, basePos)) {
                    BlockPos.MutableBlockPos buildPos = basePos.mutable();
                    int plantMaxAirHeight = random.nextInt(1, 4);
                    while (level.getFluidState((BlockPos)buildPos).is(FluidTags.WATER)) {
                        level.setBlock((BlockPos)buildPos, (BlockState)((BlockState)((BlockState)((BlockState)cattailState.setValue(CattailBlock.PART, (Comparable)((Object)CattailBlock.CattailPart.SUBMERGED))).setValue((Property)CattailBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)CattailBlock.AIR_HEIGHT, (Comparable)Integer.valueOf(0))).setValue((Property)CattailBlock.MAX_AIR_HEIGHT, (Comparable)Integer.valueOf(plantMaxAirHeight)), 2);
                        buildPos.move(Direction.UP);
                    }
                    if (level.isEmptyBlock((BlockPos)buildPos)) {
                        boolean isOnlyOne = plantMaxAirHeight == 1;
                        level.setBlock((BlockPos)buildPos, (BlockState)((BlockState)((BlockState)((BlockState)cattailState.setValue(CattailBlock.PART, (Comparable)((Object)(isOnlyOne ? CattailBlock.CattailPart.TOP : CattailBlock.CattailPart.TRANSITION)))).setValue((Property)CattailBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)CattailBlock.AIR_HEIGHT, (Comparable)Integer.valueOf(1))).setValue((Property)CattailBlock.MAX_AIR_HEIGHT, (Comparable)Integer.valueOf(plantMaxAirHeight)), 2);
                        if (!isOnlyOne) {
                            buildPos.move(Direction.UP);
                            for (int h = 2; h <= plantMaxAirHeight && level.isEmptyBlock((BlockPos)buildPos); ++h) {
                                boolean isTop = h == plantMaxAirHeight;
                                level.setBlock((BlockPos)buildPos, (BlockState)((BlockState)((BlockState)((BlockState)cattailState.setValue(CattailBlock.PART, (Comparable)((Object)(isTop ? CattailBlock.CattailPart.TOP : CattailBlock.CattailPart.STEM)))).setValue((Property)CattailBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)CattailBlock.AIR_HEIGHT, (Comparable)Integer.valueOf(h))).setValue((Property)CattailBlock.MAX_AIR_HEIGHT, (Comparable)Integer.valueOf(plantMaxAirHeight)), 2);
                                if (isTop) break;
                                buildPos.move(Direction.UP);
                            }
                        }
                    }
                    ++placed;
                }
            }
            if ((x += dir.getStepX()) != lx || (z += dir.getStepZ()) != lz) continue;
            dir = dir.getClockWise();
            lx += dir.getStepX() * s;
            lz += dir.getStepZ() * s;
            if (dir.getAxis() != axis) continue;
            s += 2;
        }
        return placed > 0;
    }

    public record Config(BlockStateProvider cattail, int radius, float chance, int maxCheck) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("cattail").forGetter(Config::cattail), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("radius").forGetter(Config::radius), (App)Codec.FLOAT.fieldOf("chance").forGetter(Config::chance), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("max_check").forGetter(Config::maxCheck)).apply((Applicative)instance, Config::new));
    }
}

