/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.confluence.mod.common.block.natural.MeteoriteOre;
import org.confluence.mod.common.init.block.OreBlocks;
import org.mesdag.particlestorm.data.curve.SplineCurve;

public class MeteoriteFeature
extends Feature<Config> {
    private static final int BEDROCK = 5;
    private static final SplineCurve.CatMullRom CURVE = new SplineCurve.CatMullRom(new float[]{0.0f, 0.0f, 0.4f, 1.0f, 0.4f, 0.0f, 0.0f});

    public MeteoriteFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        Config config = (Config)context.config();
        int radius = config.radius;
        float sparse = config.sparse;
        float lava = config.lava;
        float fire = config.fire;
        float dense = 1.0f - sparse;
        int length = radius + radius + 1;
        int max = level.getMaxBuildHeight() - length;
        int min = level.getMinBuildHeight() + length + 5;
        BlockPos.MutableBlockPos chunkCenter = new ChunkPos(origin).getBlockAt(7, max, 7).mutable();
        while (chunkCenter.getY() > min && level.getBlockState((BlockPos)chunkCenter).canBeReplaced()) {
            chunkCenter.move(0, -1, 0);
        }
        BlockState air = Blocks.AIR.defaultBlockState();
        BlockState meteorite = ((MeteoriteOre)((Object)OreBlocks.METEORITE_ORE.get())).defaultBlockState();
        float c = (float)length - 3.0f;
        float invRadius = 1.0f / (float)radius;
        float outer = (float)radius / 2.0f + 0.5f;
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos offset;
                    float dist = Mth.sqrt((float)(x * x + y * y + z * z));
                    if (dist > (float)radius || level.getBlockState(offset = chunkCenter.offset(x, y, z)).canBeReplaced()) continue;
                    float point = CURVE.getPoint((1.0f + dist * invRadius * c) / (c + 2.0f));
                    float v = random.nextFloat();
                    if (point < sparse) {
                        if (dist > outer) {
                            if (!(v > point + sparse)) continue;
                            MeteoriteFeature.setBlock(level, offset, meteorite, random, lava, fire);
                            continue;
                        }
                        MeteoriteFeature.setBlock(level, offset, v + sparse > point ? air : meteorite, random, lava, fire);
                        continue;
                    }
                    MeteoriteFeature.setBlock(level, offset, v + dense < point ? air : meteorite, random, lava, fire);
                }
            }
        }
        return true;
    }

    private static void setBlock(WorldGenLevel level, BlockPos pos, BlockState state, RandomSource random, float lava, float fire) {
        boolean b = state.is(OreBlocks.METEORITE_ORE);
        level.setBlock(pos, b && random.nextFloat() < lava ? Blocks.LAVA.defaultBlockState() : state, 3);
        if (b && level.getBlockState(pos.above()).canBeReplaced() && random.nextFloat() < fire) {
            level.setBlock(pos.above(), Blocks.FIRE.defaultBlockState(), 3);
        }
    }

    public record Config(int radius, float sparse, float lava, float fire) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.intRange((int)1, (int)7).lenientOptionalFieldOf("radius", (Object)7).forGetter(Config::radius), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("sparse", (Object)Float.valueOf(0.4f)).forGetter(Config::sparse), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("lava", (Object)Float.valueOf(0.1f)).forGetter(Config::lava), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("fire", (Object)Float.valueOf(0.15f)).forGetter(Config::fire)).apply((Applicative)instance, Config::new));
    }
}

