/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class PlantPatchFeature
extends Feature<Config> {
    public PlantPatchFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        Config config = (Config)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        int successCount = 0;
        int radius = config.radius();
        int tries = config.tries();
        BlockStateProvider plantProvider = config.plant();
        int protectRadius = config.protectRadius();
        Block protectBlock = config.protectBlock();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        HashSet<BlockPos> protectCenters = new HashSet<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    mutablePos.setWithOffset((Vec3i)origin, x, y, z);
                    if (!level.getBlockState((BlockPos)mutablePos).is(protectBlock)) continue;
                    protectCenters.add(mutablePos.immutable());
                }
            }
        }
        HashSet allowedBiomeKeys = null;
        if (!config.biomes().isEmpty()) {
            allowedBiomeKeys = new HashSet();
            for (Holder<Biome> biomeHolder : config.biomes()) {
                biomeHolder.unwrapKey().ifPresent(allowedBiomeKeys::add);
            }
        }
        for (int attempt = 0; attempt < tries; ++attempt) {
            BlockState plantToPlace;
            Holder currentBiome;
            Optional currentKey;
            mutablePos.setWithOffset((Vec3i)origin, random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius);
            if (allowedBiomeKeys != null && ((currentKey = (currentBiome = level.getBiome((BlockPos)mutablePos)).unwrapKey()).isEmpty() || !allowedBiomeKeys.contains(currentKey.get())) || !level.isEmptyBlock((BlockPos)mutablePos) || !level.getBlockState(mutablePos.below()).isSolid()) continue;
            boolean inProtectedArea = false;
            Iterator iterator = protectCenters.iterator();
            while (iterator.hasNext()) {
                BlockPos protectPos = (BlockPos)iterator.next();
                if (!level.getBlockState(protectPos).is(protectBlock)) {
                    iterator.remove();
                    continue;
                }
                int dx = Math.abs(mutablePos.getX() - protectPos.getX());
                int dz = Math.abs(mutablePos.getZ() - protectPos.getZ());
                int dy = Math.abs(mutablePos.getY() - protectPos.getY());
                if (dx > protectRadius || dz > protectRadius || dy > protectRadius) continue;
                inProtectedArea = true;
                break;
            }
            if (inProtectedArea || !(plantToPlace = plantProvider.getState(random, (BlockPos)mutablePos)).canSurvive((LevelReader)level, (BlockPos)mutablePos)) continue;
            if (plantToPlace.is(protectBlock)) {
                boolean canPlace = true;
                for (int x = -protectRadius; x <= protectRadius && canPlace; ++x) {
                    for (int z = -protectRadius; z <= protectRadius && canPlace; ++z) {
                        BlockPos nearbyPos;
                        if (x == 0 && z == 0 || level.isEmptyBlock(nearbyPos = mutablePos.offset(x, 0, z))) continue;
                        canPlace = false;
                    }
                }
                if (!canPlace) continue;
                protectCenters.add(mutablePos.immutable());
            }
            level.setBlock((BlockPos)mutablePos, plantToPlace, 2);
            ++successCount;
        }
        return successCount > 0;
    }

    public record Config(BlockStateProvider plant, Block protectBlock, int protectRadius, int radius, int tries, List<Holder<Biome>> biomes) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("plant").forGetter(Config::plant), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("protect_block").forGetter(Config::protectBlock), (App)Codec.INT.fieldOf("protect_radius").orElse((Object)1).forGetter(Config::protectRadius), (App)Codec.INT.fieldOf("radius").orElse((Object)7).forGetter(Config::radius), (App)Codec.INT.fieldOf("tries").orElse((Object)64).forGetter(Config::tries), (App)Biome.CODEC.listOf().fieldOf("biomes").orElse(List.of()).forGetter(Config::biomes)).apply((Applicative)instance, Config::new));
    }
}

