/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.confluence.lib.util.FeatureUtils;
import org.confluence.mod.common.block.functional.InstantExplosionBlock;
import org.confluence.mod.common.init.ModFeatures;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.NotNull;

public class SculkSensorWithTNTFeature
extends Feature<Config> {
    public SculkSensorWithTNTFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<Config> context) {
        BlockPos blockPos;
        Config config = (Config)context.config();
        WorldGenLevel level = context.level();
        if (!FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)(blockPos = context.origin()))) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = blockPos.mutable();
        for (int v = 1; v <= config.maxSearchDown && FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)mutablePos); ++v) {
            mutablePos.move(0, -1, 0);
        }
        if (FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)mutablePos.above(), (BlockState)Blocks.SCULK_SENSOR.defaultBlockState(), ModFeatures.IS_REPLACEABLE)) {
            return FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)mutablePos, (BlockState)((InstantExplosionBlock)FunctionalBlocks.INSTANTANEOUS_EXPLOSION_TNT.get()).defaultBlockState(), ModFeatures.IS_REPLACEABLE) && FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)mutablePos.below(), (BlockState)Blocks.TNT.defaultBlockState(), ModFeatures.IS_REPLACEABLE);
        }
        return false;
    }

    public record Config(int maxSearchDown) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_search_down", (Object)64).forGetter(Config::maxSearchDown)).apply((Applicative)instance, Config::new));
    }
}

