/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.secret_seed;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.client.handler.ClientPacketHandler;
import org.confluence.mod.mixed.IMinecraftServer;

public abstract class SecretSeed {
    private final long flag;
    private final ResourceLocation id;

    public SecretSeed(long flag, ResourceLocation id) {
        this.flag = flag;
        this.id = id;
    }

    public abstract boolean match(String var1);

    public long getFlag() {
        return this.flag;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean match(MinecraftServer server) {
        return IMinecraftServer.of(server).confluence$matchesSecretFlag(this);
    }

    public boolean match(ServerLevel serverLevel) {
        return this.match(serverLevel.getServer());
    }

    public boolean match() {
        if (LibUtils.isLogicalClient()) {
            return this.match(ClientPacketHandler.getSecretFlag());
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server != null && this.match(server);
    }

    public boolean match(long secretFlag) {
        return (secretFlag & this.flag) != 0L;
    }
}

