/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.common.worldgen.structure.SimpleTemplatePiece;
import org.confluence.lib.util.BooleanStorage4;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.StructureUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.block.common.CrackedBricksBlock;
import org.confluence.mod.common.block.common.EnchantedFragileBricksBlock;
import org.confluence.mod.common.block.functional.InstantExplosionBlock;
import org.confluence.mod.common.block.functional.SignalPressurePlateBlock;
import org.confluence.mod.common.block.functional.SpikeBlock;
import org.confluence.mod.common.block.functional.StepOnTrapBlock;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.mixed.IStructureStart;
import org.confluence.mod.util.ModUtils;
import org.confluence.terraentity.entity.boss.AbstractTerraBossBase;
import org.confluence.terraentity.entity.boss.DungeonGuardian;
import org.confluence.terraentity.init.TESounds;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.joml.Vector3d;

public class DungeonStructure
extends Structure {
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNGEON_LOST_PAPER = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "dungeon_lost_paper");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNGEON_POT = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "dungeon_pot");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNGEON_REMAINS = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "dungeon_remains");
    public static final String[] TYPES = new String[]{"dungeon/blue", "dungeon/green", "dungeon/pink"};
    public static final String TYPE = TYPES[0];
    public static final MapCodec<DungeonStructure> CODEC = DungeonStructure.simpleCodec(DungeonStructure::new);
    public static final String[] HOUSES = new String[]{TYPE + "_house_0", TYPE + "_house_1", TYPE + "_house_2", TYPE + "_house_3", TYPE + "_house_4", TYPE + "_house_5", TYPE + "_house_6"};
    public static final String[] CORNERS = new String[]{TYPE + "_house_corner_0", TYPE + "_house_corner_1"};
    public static final String[] CORNERS_IN = new String[]{TYPE + "_house_corner_in_0", TYPE + "_house_corner_in_1", TYPE + "_house_corner_in_2", TYPE + "_house_corner_in_3", TYPE + "_house_corner_in_4", TYPE + "_house_corner_in_5"};
    public static final String[] BRIDGE = new String[]{TYPE + "_bridge_0", TYPE + "_bridge_1"};
    public static final String STAIRS = TYPE + "_stairs";
    public static final String STAIRS_DOWN = TYPE + "_stairs_down";
    public static final String GATE = TYPE + "_dungeon_gate";
    private static final ResourceLocation[] GROUND_FEATURE = new ResourceLocation[]{DUNGEON_LOST_PAPER.location(), DUNGEON_POT.location(), DUNGEON_REMAINS.location()};
    public static final String UG_0_1 = TYPE + "_dungeon_underground_0_1";
    public static final String UG_0_2 = TYPE + "_dungeon_underground_0_2";
    public static final String UG_0_3 = TYPE + "_dungeon_underground_0_3";
    public static final String UG_1_0 = TYPE + "_dungeon_underground_1_0";
    public static final String UG_1_1 = TYPE + "_dungeon_underground_1_1";
    public static final String UG_1_2 = TYPE + "_dungeon_underground_1_2";
    public static final String UG_1_3 = TYPE + "_dungeon_underground_1_3";
    public static final String UG_1_4 = TYPE + "_dungeon_underground_1_4";
    public static final String UG_2_0 = TYPE + "_dungeon_underground_2_0";
    public static final String UG_2_1 = TYPE + "_dungeon_underground_2_1";
    public static final String UG_2_2 = TYPE + "_dungeon_underground_2_2";
    public static final String UG_2_3 = TYPE + "_dungeon_underground_2_3";
    public static final String UG_2_4 = TYPE + "_dungeon_underground_2_4";
    public static final String UG_3_0 = TYPE + "_dungeon_underground_3_0";
    public static final String UG_3_1 = TYPE + "_dungeon_underground_3_1";
    public static final String UG_3_2 = TYPE + "_dungeon_underground_3_2";
    public static final String UG_3_3 = TYPE + "_dungeon_underground_3_3";
    public static final String UG_3_4 = TYPE + "_dungeon_underground_3_4";
    public static final String UG_4_1 = TYPE + "_dungeon_underground_4_1";
    public static final String UG_4_2 = TYPE + "_dungeon_underground_4_2";
    public static final String UG_4_3 = TYPE + "_dungeon_underground_4_3";

    public DungeonStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 5760000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return DungeonStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            int houseValue;
            BlockPos houseKey;
            int i;
            WorldgenRandom random = context.random();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(lowestY);
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            BooleanStorage4 valueB = new BooleanStorage4();
            Object2IntOpenHashMap houseMap = new Object2IntOpenHashMap();
            Object2IntOpenHashMap cornersInMap = new Object2IntOpenHashMap();
            Object2IntOpenHashMap bridgeMap = new Object2IntOpenHashMap();
            BlockPos.MutableBlockPos mazeRotatePos = new BlockPos.MutableBlockPos();
            int outRoomSizeHeight = 24;
            int stairsFacing = 0;
            HashMap<BlockPos, ResourceLocation> featureMap = new HashMap<BlockPos, ResourceLocation>();
            Rotation rotation = (Rotation)Util.getRandom((Object[])Rotation.values(), (RandomSource)random);
            ArrayList<Vector3d> firstChannel = new ArrayList<Vector3d>();
            IntArrayList housesList = new IntArrayList();
            int goldenCount = random.nextInt(7, 9);
            int commonCount = random.nextInt(5, 7);
            int clockCount = random.nextInt(4, 7);
            for (i = 0; i < goldenCount; ++i) {
                housesList.add(2);
            }
            for (i = 0; i < commonCount; ++i) {
                housesList.add(random.nextInt(housesList.size()), 0);
            }
            for (i = 0; i < clockCount; ++i) {
                housesList.add(random.nextInt(housesList.size()), 1);
            }
            firstChannel.add(new Vector3d((double)centerPos.getX(), (double)(centerPos.getY() - 4), (double)centerPos.getZ()));
            Vector3d vct = new Vector3d((double)centerPos.getX(), (double)random.nextInt(-15, -10), (double)centerPos.getZ());
            firstChannel.add(new Vector3d(vct.x, vct.y + (double)outRoomSizeHeight + 10.0, vct.z));
            VectorUtils.lightningPathList(firstChannel, (double)2.0, (float)0.125f, (RandomSource)random);
            StructureUtils.lineSet(firstChannel, (double)5.5, (double)5.5, (int)1, (boolean)true, (Object2IntMap)blockMap);
            BlockPos underCenter = new BlockPos(centerPos.getX(), Mth.floor((double)vct.y), centerPos.getZ());
            Map mazeMap = VectorUtils.mazePos((Vector3d)new Vector3d((double)underCenter.getX(), (double)underCenter.getY(), (double)underCenter.getZ()), (double)40.0, (int)2, (WorldgenRandom)random, (float)1.0f);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-103, -4, -103), (BlockPos)underCenter.offset(103, 51, 103), (int)1, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-99, 47, -99), (BlockPos)underCenter.offset(99, 47, 99), (int)15, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-99, 46, -99), (BlockPos)underCenter.offset(99, 46, 99), (int)2, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-10, 46, -10), (BlockPos)underCenter.offset(10, 55, 10), (int)1, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-99, 0, -99), (BlockPos)underCenter.offset(99, 45, 99), (int)0, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-6, 45, -6), (BlockPos)underCenter.offset(6, 51, 6), (int)0, (Object2IntMap)blockMap, (int)0);
            List groundFeaturePos = VectorUtils.rectangularPos((BlockPos)underCenter.offset(-99, 0, -99), (BlockPos)underCenter.offset(99, 0, 99), (float)0.03f, (WorldgenRandom)random);
            for (Vector3d vector3d : groundFeaturePos) {
                featureMap.put(VectorUtils.fromVector3d((Vector3d)vector3d), (ResourceLocation)Util.getRandom((Object[])GROUND_FEATURE, (RandomSource)random));
            }
            for (Map.Entry entry : mazeMap.entrySet()) {
                Vector3d key = (Vector3d)entry.getKey();
                BooleanStorage4 value = (BooleanStorage4)entry.getValue();
                valueB.set(~value.getValue());
                mazeRotatePos.set(Mth.floor((double)key.x), Mth.floor((double)key.y), Mth.floor((double)key.z));
                if (mazeRotatePos.getX() == underCenter.getX() && mazeRotatePos.getZ() == underCenter.getZ()) {
                    stairsFacing = VectorUtils.listRandom((BooleanStorage4)valueB, (WorldgenRandom)random);
                }
                StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-6, -1, -6), (BlockPos)mazeRotatePos.offset(6, -1, 6), (int)4, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-6, -1, -6), (BlockPos)mazeRotatePos.offset(6, -1, 6), (int)16, (Object2IntMap)blockMap, (int)0, (float)0.03f, (WorldgenRandom)random);
                StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-5, -1, -5), (BlockPos)mazeRotatePos.offset(5, -1, 5), (int)5, (Object2IntMap)blockMap, (int)0);
                if (value.get(0)) {
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(7, -1, -6), (BlockPos)mazeRotatePos.offset(20, -1, 6), (int)4, (Object2IntMap)blockMap, (int)0);
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(7, -1, -6), (BlockPos)mazeRotatePos.offset(20, -1, 6), (int)16, (Object2IntMap)blockMap, (int)0, (float)0.03f, (WorldgenRandom)random);
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(6, -1, -5), (BlockPos)mazeRotatePos.offset(20, -1, 5), (int)5, (Object2IntMap)blockMap, (int)0);
                }
                if (value.get(1)) {
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-6, -1, 7), (BlockPos)mazeRotatePos.offset(6, -1, 20), (int)4, (Object2IntMap)blockMap, (int)0);
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-6, -1, 7), (BlockPos)mazeRotatePos.offset(6, -1, 20), (int)16, (Object2IntMap)blockMap, (int)0, (float)0.03f, (WorldgenRandom)random);
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-5, -1, 6), (BlockPos)mazeRotatePos.offset(5, -1, 20), (int)5, (Object2IntMap)blockMap, (int)0);
                }
                if (value.get(2)) {
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-7, -1, -6), (BlockPos)mazeRotatePos.offset(-20, -1, 6), (int)4, (Object2IntMap)blockMap, (int)0);
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-7, -1, -6), (BlockPos)mazeRotatePos.offset(-20, -1, 6), (int)16, (Object2IntMap)blockMap, (int)0, (float)0.03f, (WorldgenRandom)random);
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-6, -1, -5), (BlockPos)mazeRotatePos.offset(-20, -1, 5), (int)5, (Object2IntMap)blockMap, (int)0);
                }
                if (value.get(3)) {
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-6, -1, -7), (BlockPos)mazeRotatePos.offset(6, -1, -20), (int)4, (Object2IntMap)blockMap, (int)0);
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-6, -1, -7), (BlockPos)mazeRotatePos.offset(6, -1, -20), (int)16, (Object2IntMap)blockMap, (int)0, (float)0.03f, (WorldgenRandom)random);
                    StructureUtils.rectangular((BlockPos)mazeRotatePos.offset(-5, -1, -6), (BlockPos)mazeRotatePos.offset(5, -1, -20), (int)5, (Object2IntMap)blockMap, (int)0);
                }
                if (!value.get(0)) {
                    houseMap.put((Object)mazeRotatePos.offset(12, -1, -4), 0);
                    houseMap.put((Object)mazeRotatePos.offset(12, -1, -12), 0);
                    houseMap.put((Object)mazeRotatePos.offset(12, -1, 4), 0);
                }
                if (!value.get(1)) {
                    houseMap.put((Object)mazeRotatePos.offset(-4, -1, 12), 1);
                    houseMap.put((Object)mazeRotatePos.offset(12, -1, 12), 1);
                    houseMap.put((Object)mazeRotatePos.offset(4, -1, 12), 1);
                }
                if (!value.get(2)) {
                    houseMap.put((Object)mazeRotatePos.offset(-12, -1, -4), 2);
                    houseMap.put((Object)mazeRotatePos.offset(-12, -1, 12), 2);
                    houseMap.put((Object)mazeRotatePos.offset(-12, -1, 4), 2);
                }
                if (!value.get(3)) {
                    houseMap.put((Object)mazeRotatePos.offset(-4, -1, -12), 3);
                    houseMap.put((Object)mazeRotatePos.offset(-12, -1, -12), 3);
                    houseMap.put((Object)mazeRotatePos.offset(4, -1, -12), 3);
                }
                if (!value.get(0) && value.get(1)) {
                    houseMap.put((Object)mazeRotatePos.offset(12, -1, 12), 0);
                }
                if (!value.get(0) && value.get(3)) {
                    houseMap.put((Object)mazeRotatePos.offset(12, -1, -20), 0);
                }
                if (!value.get(1) && value.get(2)) {
                    houseMap.put((Object)mazeRotatePos.offset(-12, -1, 12), 1);
                }
                if (!value.get(1) && value.get(0)) {
                    houseMap.put((Object)mazeRotatePos.offset(20, -1, 12), 1);
                }
                if (!value.get(2) && value.get(3)) {
                    houseMap.put((Object)mazeRotatePos.offset(-12, -1, -12), 2);
                }
                if (!value.get(2) && value.get(1)) {
                    houseMap.put((Object)mazeRotatePos.offset(-12, -1, 20), 2);
                }
                if (!value.get(3) && value.get(0)) {
                    houseMap.put((Object)mazeRotatePos.offset(12, -1, -12), 3);
                }
                if (!value.get(3) && value.get(2)) {
                    houseMap.put((Object)mazeRotatePos.offset(-20, -1, -12), 3);
                }
                if (value.get(0) && value.get(1)) {
                    houseMap.put((Object)mazeRotatePos.offset(12, -1, 12), 4);
                }
                if (value.get(1) && value.get(2)) {
                    houseMap.put((Object)mazeRotatePos.offset(-12, -1, 12), 5);
                }
                if (value.get(2) && value.get(3)) {
                    houseMap.put((Object)mazeRotatePos.offset(-12, -1, -12), 6);
                }
                if (value.get(3) && value.get(0)) {
                    houseMap.put((Object)mazeRotatePos.offset(12, -1, -12), 7);
                }
                if (!value.get(0) && !value.get(1)) {
                    cornersInMap.put((Object)mazeRotatePos.offset(12, -1, 12), 0);
                }
                if (!value.get(1) && !value.get(2)) {
                    cornersInMap.put((Object)mazeRotatePos.offset(-12, -1, 12), 1);
                }
                if (!value.get(2) && !value.get(3)) {
                    cornersInMap.put((Object)mazeRotatePos.offset(-12, -1, -12), 2);
                }
                if (!value.get(3) && !value.get(0)) {
                    cornersInMap.put((Object)mazeRotatePos.offset(12, -1, -12), 3);
                }
                if (!(value.get(0) || value.get(2) || value.get(0) && value.get(2) && value.get(1) && value.get(3) || !random.nextBoolean() || mazeRotatePos.getX() == underCenter.getX() && mazeRotatePos.getX() == underCenter.getX())) {
                    bridgeMap.put((Object)mazeRotatePos.offset(13, -1, 5), 1);
                }
                if (value.get(1) || value.get(3) || value.get(0) && value.get(2) && value.get(1) && value.get(3) || !random.nextBoolean() || mazeRotatePos.getX() == underCenter.getX() && mazeRotatePos.getX() == underCenter.getX()) continue;
                bridgeMap.put((Object)mazeRotatePos.offset(-5, 0, 13), 0);
            }
            for (Object2IntMap.Entry entry : houseMap.object2IntEntrySet()) {
                if (entry.getIntValue() >= 4 || housesList.size() >= houseMap.size()) continue;
                housesList.add(random.nextInt(housesList.size() + 1), random.nextInt(3, HOUSES.length));
            }
            StructureTemplateManager manager = context.structureTemplateManager();
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_4_3, underCenter.offset(-96, -41, -70), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_4_2, underCenter.offset(-96, -41, -23), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_4_1, underCenter.offset(-96, -41, 24), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_3_4, underCenter.offset(-70, -41, -96), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_3_3, underCenter.offset(-70, -41, -70), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_3_2, underCenter.offset(-70, -41, -23), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_3_1, underCenter.offset(-70, -41, 24), true, false, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_3_0, underCenter.offset(-70, -41, 71), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_2_4, underCenter.offset(-23, -41, -96), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_2_3, underCenter.offset(-23, -41, -70), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_2_2, underCenter.offset(-23, -41, -23), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_2_1, underCenter.offset(-23, -41, 24), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_2_0, underCenter.offset(-23, -41, 71), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_1_4, underCenter.offset(24, -41, -96), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_1_3, underCenter.offset(24, -41, -70), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_1_2, underCenter.offset(24, -41, -23), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_1_1, underCenter.offset(24, -41, 24), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_1_0, underCenter.offset(24, -41, 71), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_0_3, underCenter.offset(71, -41, -70), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_0_2, underCenter.offset(71, -41, -23), true, true, Rotation.NONE));
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, UG_0_1, underCenter.offset(71, -41, 24), true, true, Rotation.NONE));
            StructureUtils.lineSet(firstChannel, (double)2.5, (double)2.5, (int)0, (boolean)true, (Object2IntMap)blockMap);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-2, 48, -2), (BlockPos)underCenter.offset(2, 48, 2), (int)6, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-1, 48, -1), (BlockPos)underCenter.offset(1, 48, 1), (int)1, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-6, -1, -6), (BlockPos)underCenter.offset(6, -5, 6), (int)7, (Object2IntMap)blockMap, (int)0);
            blockMap.put((Object)underCenter.offset(22, -26, 22), 14);
            blockMap.put((Object)underCenter.offset(22, -26, -22), 14);
            blockMap.put((Object)underCenter.offset(-22, -26, 22), 14);
            blockMap.put((Object)underCenter.offset(-22, -26, -22), 14);
            blockMap.put((Object)underCenter.offset(0, -26, 31), 14);
            blockMap.put((Object)underCenter.offset(0, -26, -31), 14);
            blockMap.put((Object)underCenter.offset(31, -26, 0), 14);
            blockMap.put((Object)underCenter.offset(-31, -26, 0), 14);
            StructureUtils.rectangular((BlockPos)underCenter.offset(32, -26, 0), (BlockPos)underCenter.offset(35, -26, 0), (int)13, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(1, -26, 31), (BlockPos)underCenter.offset(1, -26, 35), (int)13, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(1, -26, -31), (BlockPos)underCenter.offset(1, -26, -35), (int)13, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(23, -26, 22), (BlockPos)underCenter.offset(24, -26, 23), (int)13, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(23, -26, -22), (BlockPos)underCenter.offset(24, -26, -23), (int)13, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(24, -26, 23), (BlockPos)underCenter.offset(25, -26, 24), (int)13, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(24, -26, -23), (BlockPos)underCenter.offset(25, -26, -24), (int)13, (Object2IntMap)blockMap, (int)0);
            blockMap.put((Object)underCenter.offset(-21, -26, 23), 13);
            blockMap.put((Object)underCenter.offset(-21, -26, -23), 13);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-32, -26, 0), (BlockPos)underCenter.offset(-35, -26, 0), (int)12, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-1, -26, 31), (BlockPos)underCenter.offset(-1, -26, 35), (int)12, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-1, -26, -31), (BlockPos)underCenter.offset(-1, -26, -35), (int)12, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-23, -26, 22), (BlockPos)underCenter.offset(-24, -26, 23), (int)12, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-23, -26, -22), (BlockPos)underCenter.offset(-24, -26, -23), (int)12, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-24, -26, 23), (BlockPos)underCenter.offset(-25, -26, 24), (int)12, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-24, -26, -23), (BlockPos)underCenter.offset(-25, -26, -24), (int)12, (Object2IntMap)blockMap, (int)0);
            blockMap.put((Object)underCenter.offset(21, -26, 23), 12);
            blockMap.put((Object)underCenter.offset(21, -26, -23), 12);
            StructureUtils.rectangular((BlockPos)underCenter.offset(0, -26, 32), (BlockPos)underCenter.offset(0, -26, 35), (int)11, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(31, -26, 1), (BlockPos)underCenter.offset(35, -26, 1), (int)11, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-31, -26, 1), (BlockPos)underCenter.offset(-35, -26, 1), (int)11, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(22, -26, 23), (BlockPos)underCenter.offset(23, -26, 24), (int)11, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-22, -26, 23), (BlockPos)underCenter.offset(-23, -26, 24), (int)11, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(23, -26, 24), (BlockPos)underCenter.offset(24, -26, 25), (int)11, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-23, -26, 24), (BlockPos)underCenter.offset(-24, -26, 25), (int)11, (Object2IntMap)blockMap, (int)0);
            blockMap.put((Object)underCenter.offset(23, -26, -21), 11);
            blockMap.put((Object)underCenter.offset(-23, -26, -21), 11);
            StructureUtils.rectangular((BlockPos)underCenter.offset(0, -26, -32), (BlockPos)underCenter.offset(0, -26, -35), (int)10, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(31, -26, -1), (BlockPos)underCenter.offset(35, -26, -1), (int)10, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-31, -26, -1), (BlockPos)underCenter.offset(-35, -26, -1), (int)10, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(22, -26, -23), (BlockPos)underCenter.offset(23, -26, -24), (int)10, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-22, -26, -23), (BlockPos)underCenter.offset(-23, -26, -24), (int)10, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(23, -26, -24), (BlockPos)underCenter.offset(24, -26, -25), (int)10, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-23, -26, -24), (BlockPos)underCenter.offset(-24, -26, -25), (int)10, (Object2IntMap)blockMap, (int)0);
            blockMap.put((Object)underCenter.offset(23, -26, 21), 10);
            blockMap.put((Object)underCenter.offset(-23, -26, 21), 10);
            StructureUtils.rectangular((BlockPos)underCenter.offset(32, -25, 1), (BlockPos)underCenter.offset(35, -23, -1), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-32, -25, 1), (BlockPos)underCenter.offset(-35, -23, -1), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(1, -25, 32), (BlockPos)underCenter.offset(-1, -23, 35), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(1, -25, -32), (BlockPos)underCenter.offset(-1, -23, -35), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(31, -25, 1), (BlockPos)underCenter.offset(31, -23, 1), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-31, -25, 1), (BlockPos)underCenter.offset(-31, -23, 1), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(1, -25, 31), (BlockPos)underCenter.offset(1, -23, 31), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(1, -25, -31), (BlockPos)underCenter.offset(1, -23, -31), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(31, -25, -1), (BlockPos)underCenter.offset(31, -23, -1), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-31, -25, -1), (BlockPos)underCenter.offset(-31, -23, -1), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-1, -25, 31), (BlockPos)underCenter.offset(-1, -23, 31), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-1, -25, -31), (BlockPos)underCenter.offset(-1, -23, -31), (int)9, (Object2IntMap)blockMap, (int)0);
            blockMap.put((Object)underCenter.offset(31, -23, 0), 9);
            blockMap.put((Object)underCenter.offset(-31, -23, 0), 9);
            blockMap.put((Object)underCenter.offset(0, -23, 31), 9);
            blockMap.put((Object)underCenter.offset(0, -23, -31), 9);
            blockMap.put((Object)underCenter.offset(22, -23, 22), 9);
            blockMap.put((Object)underCenter.offset(-22, -23, -22), 9);
            blockMap.put((Object)underCenter.offset(-22, -23, 22), 9);
            blockMap.put((Object)underCenter.offset(22, -23, -22), 9);
            blockMap.put((Object)underCenter.offset(31, -24, 0), 12);
            blockMap.put((Object)underCenter.offset(-31, -24, 0), 13);
            blockMap.put((Object)underCenter.offset(0, -24, 31), 10);
            blockMap.put((Object)underCenter.offset(0, -24, -31), 11);
            blockMap.put((Object)underCenter.offset(22, -24, 22), 12);
            blockMap.put((Object)underCenter.offset(-22, -24, -22), 13);
            blockMap.put((Object)underCenter.offset(-22, -24, 22), 10);
            blockMap.put((Object)underCenter.offset(22, -24, -22), 11);
            StructureUtils.rectangular((BlockPos)underCenter.offset(23, -25, 22), (BlockPos)underCenter.offset(24, -23, 25), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(22, -25, 23), (BlockPos)underCenter.offset(25, -23, 24), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(23, -25, -22), (BlockPos)underCenter.offset(24, -23, -25), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(22, -25, -23), (BlockPos)underCenter.offset(25, -23, -24), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-23, -25, 22), (BlockPos)underCenter.offset(-24, -23, 25), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-22, -25, 23), (BlockPos)underCenter.offset(-25, -23, 24), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-23, -25, -22), (BlockPos)underCenter.offset(-24, -23, -25), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-22, -25, -23), (BlockPos)underCenter.offset(-25, -23, -24), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(21, -25, 23), (BlockPos)underCenter.offset(21, -23, 23), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(23, -25, 21), (BlockPos)underCenter.offset(23, -23, 21), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(21, -25, -23), (BlockPos)underCenter.offset(21, -23, -23), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(23, -25, -21), (BlockPos)underCenter.offset(23, -23, -21), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-21, -25, 23), (BlockPos)underCenter.offset(-21, -23, 23), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-23, -25, 21), (BlockPos)underCenter.offset(-23, -23, 21), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-21, -25, -23), (BlockPos)underCenter.offset(-21, -23, -23), (int)9, (Object2IntMap)blockMap, (int)0);
            StructureUtils.rectangular((BlockPos)underCenter.offset(-23, -25, -21), (BlockPos)underCenter.offset(-23, -23, -21), (int)9, (Object2IntMap)blockMap, (int)0);
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), ((Block)DecorativeBlocks.BLUE_BRICKS.get()).defaultBlockState(), ((CrackedBricksBlock)((Object)((Object)DecorativeBlocks.CRACKED_BLUE_BRICKS.get()))).defaultBlockState(), Blocks.LAVA.defaultBlockState(), Blocks.POLISHED_DEEPSLATE.defaultBlockState(), Blocks.DEEPSLATE_TILES.defaultBlockState(), ((Block)DecorativeBlocks.CHISELED_BLUE_BRICKS.get()).defaultBlockState(), Blocks.WATER.defaultBlockState(), (BlockState)((BlockState)((EnchantedFragileBricksBlock)((Object)((Object)FunctionalBlocks.ENCHANTED_FRAGILE_BLUE_BRICKS.get()))).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)StateProperties.IS_SUPPORTING, (Comparable)Boolean.valueOf(false)), (BlockState)((BlockState)((EnchantedFragileBricksBlock)((Object)((Object)FunctionalBlocks.ENCHANTED_FRAGILE_BLUE_BRICKS.get()))).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN)).setValue((Property)StateProperties.IS_SUPPORTING, (Comparable)Boolean.valueOf(false)), (BlockState)((BlockState)((EnchantedFragileBricksBlock)((Object)((Object)FunctionalBlocks.ENCHANTED_FRAGILE_BLUE_BRICKS.get()))).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH)).setValue((Property)StateProperties.IS_SUPPORTING, (Comparable)Boolean.valueOf(false)), (BlockState)((BlockState)((EnchantedFragileBricksBlock)((Object)((Object)FunctionalBlocks.ENCHANTED_FRAGILE_BLUE_BRICKS.get()))).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)StateProperties.IS_SUPPORTING, (Comparable)Boolean.valueOf(false)), (BlockState)((BlockState)((EnchantedFragileBricksBlock)((Object)((Object)FunctionalBlocks.ENCHANTED_FRAGILE_BLUE_BRICKS.get()))).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST)).setValue((Property)StateProperties.IS_SUPPORTING, (Comparable)Boolean.valueOf(false)), (BlockState)((BlockState)((EnchantedFragileBricksBlock)((Object)((Object)FunctionalBlocks.ENCHANTED_FRAGILE_BLUE_BRICKS.get()))).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST)).setValue((Property)StateProperties.IS_SUPPORTING, (Comparable)Boolean.valueOf(false)), (BlockState)((BlockState)((EnchantedFragileBricksBlock)((Object)((Object)FunctionalBlocks.ENCHANTED_FRAGILE_BLUE_BRICKS.get()))).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)StateProperties.IS_SUPPORTING, (Comparable)Boolean.valueOf(true)), ((SpikeBlock)((Object)((Object)FunctionalBlocks.SPIKE.get()))).defaultBlockState(), ((StepOnTrapBlock)((Object)((Object)FunctionalBlocks.GRAVITATION_TRAP.get()))).defaultBlockState(), ((SignalPressurePlateBlock)FunctionalBlocks.DEEPSLATE_PRESSURE_PLATE.get()).defaultBlockState(), ((InstantExplosionBlock)FunctionalBlocks.INSTANTANEOUS_EXPLOSION_TNT.get()).defaultBlockState()}), featureMap, (StructurePiecesBuilder)builder);
            switch (rotation) {
                case CLOCKWISE_90: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, GATE, centerPos.offset(15, -3, -23), true, false, Rotation.CLOCKWISE_90));
                    break;
                }
                case CLOCKWISE_180: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, GATE, centerPos.offset(23, -3, 15), true, false, Rotation.CLOCKWISE_180));
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, GATE, centerPos.offset(-15, -3, 23), true, false, Rotation.COUNTERCLOCKWISE_90));
                    break;
                }
                default: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, GATE, centerPos.offset(-23, -3, -15), true, false, Rotation.NONE));
                }
            }
            boolean bl = false;
            block34: for (Object2IntMap.Entry entry : houseMap.object2IntEntrySet()) {
                void var28_33;
                houseKey = (BlockPos)entry.getKey();
                houseValue = entry.getIntValue();
                switch (houseValue) {
                    case 0: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, HOUSES[housesList.getInt((int)var28_33)], houseKey.offset(-1, 0, -1), false, false, Rotation.NONE));
                        ++var28_33;
                        continue block34;
                    }
                    case 1: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, HOUSES[housesList.getInt((int)var28_33)], houseKey.offset(1, 0, -1), false, false, Rotation.CLOCKWISE_90));
                        ++var28_33;
                        continue block34;
                    }
                    case 2: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, HOUSES[housesList.getInt((int)var28_33)], houseKey.offset(1, 0, 1), false, false, Rotation.CLOCKWISE_180));
                        ++var28_33;
                        continue block34;
                    }
                    case 4: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS, (RandomSource)random), houseKey.offset(-1, 0, -1), false, false, Rotation.NONE));
                        continue block34;
                    }
                    case 5: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS, (RandomSource)random), houseKey.offset(1, 0, -1), false, false, Rotation.CLOCKWISE_90));
                        continue block34;
                    }
                    case 6: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS, (RandomSource)random), houseKey.offset(1, 0, 1), false, false, Rotation.CLOCKWISE_180));
                        continue block34;
                    }
                    case 7: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS, (RandomSource)random), houseKey.offset(-1, 0, 1), false, false, Rotation.COUNTERCLOCKWISE_90));
                        continue block34;
                    }
                    case 8: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 0, -1), true, false, Rotation.NONE));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 6, -1), true, false, Rotation.NONE));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 12, -1), true, false, Rotation.NONE));
                        continue block34;
                    }
                    case 9: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 0, -1), true, false, Rotation.CLOCKWISE_90));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 6, -1), true, false, Rotation.CLOCKWISE_90));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 12, -1), true, false, Rotation.CLOCKWISE_90));
                        continue block34;
                    }
                    case 10: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 0, 1), true, false, Rotation.CLOCKWISE_180));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 6, 1), true, false, Rotation.CLOCKWISE_180));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 12, 1), true, false, Rotation.CLOCKWISE_180));
                        continue block34;
                    }
                    case 11: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 0, 1), true, false, Rotation.COUNTERCLOCKWISE_90));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 6, 1), true, false, Rotation.COUNTERCLOCKWISE_90));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 12, 1), true, false, Rotation.COUNTERCLOCKWISE_90));
                        continue block34;
                    }
                }
                builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, HOUSES[housesList.getInt((int)var28_33)], houseKey.offset(-1, 0, 1), false, false, Rotation.COUNTERCLOCKWISE_90));
                ++var28_33;
            }
            block35: for (Object2IntMap.Entry entry : cornersInMap.object2IntEntrySet()) {
                houseKey = (BlockPos)entry.getKey();
                houseValue = entry.getIntValue();
                switch (houseValue) {
                    case 0: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 18, -1), true, false, Rotation.NONE));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 12, -1), true, false, Rotation.NONE));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 6, -1), true, false, Rotation.NONE));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 0, -1), true, false, Rotation.NONE));
                        continue block35;
                    }
                    case 1: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 18, -1), true, false, Rotation.CLOCKWISE_90));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 12, -1), true, false, Rotation.CLOCKWISE_90));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 6, -1), true, false, Rotation.CLOCKWISE_90));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 0, -1), true, false, Rotation.CLOCKWISE_90));
                        continue block35;
                    }
                    case 2: {
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 18, 1), true, false, Rotation.CLOCKWISE_180));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 12, 1), true, false, Rotation.CLOCKWISE_180));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 6, 1), true, false, Rotation.CLOCKWISE_180));
                        builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(1, 0, 1), true, false, Rotation.CLOCKWISE_180));
                        continue block35;
                    }
                }
                builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 18, 1), true, false, Rotation.COUNTERCLOCKWISE_90));
                builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 12, 1), true, false, Rotation.COUNTERCLOCKWISE_90));
                builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 6, 1), true, false, Rotation.COUNTERCLOCKWISE_90));
                builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])CORNERS_IN, (RandomSource)random), houseKey.offset(-1, 0, 1), true, false, Rotation.COUNTERCLOCKWISE_90));
            }
            for (Object2IntMap.Entry entry : bridgeMap.object2IntEntrySet()) {
                houseKey = (BlockPos)entry.getKey();
                houseValue = entry.getIntValue();
                if (houseValue == 0) {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])BRIDGE, (RandomSource)random), houseKey.offset(0, 3 + 6 * random.nextInt(1, 3), 0), true, true, Rotation.COUNTERCLOCKWISE_90));
                    continue;
                }
                builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, (String)Util.getRandom((Object[])BRIDGE, (RandomSource)random), houseKey.offset(0, 3 + 6 * random.nextInt(1, 3), 0), true, true, Rotation.CLOCKWISE_180));
            }
            switch (stairsFacing) {
                case 0: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, STAIRS, underCenter.offset(13, 0, 13), false, true, Rotation.CLOCKWISE_180));
                    break;
                }
                case 1: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, STAIRS, underCenter.offset(-13, 0, 13), false, true, Rotation.COUNTERCLOCKWISE_90));
                    break;
                }
                case 2: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, STAIRS, underCenter.offset(-13, 0, -13), false, true, Rotation.NONE));
                    break;
                }
                default: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, STAIRS, underCenter.offset(13, 0, -13), false, true, Rotation.CLOCKWISE_90));
                }
            }
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.DUNGEON.get();
    }

    public static void checkSkeletronDefeated(ServerPlayer player, ServerLevel level) {
        if (player.isAlive() && player.gameMode.getGameModeForPlayer().isSurvival() && level.getGameTime() % 100L == 1L && !KillBoard.INSTANCE.isDefeated((EntityType)TEBossEntities.SKELETRON.get())) {
            DungeonStructure.iterateDungeon(level, player.chunkPosition(), structureStart -> {
                BoundingBox boundingBox = IStructureStart.of(structureStart).confluence$cachedBoundingBox();
                boolean shouldAlert = (Boolean)CommonConfigs.ALERT_PLAYER_IN_DUNGEON.get();
                if (boundingBox.isInside((Vec3i)player.blockPosition()) && player.getY() <= (double)(boundingBox.minY() + DungeonStructure.getUpperBoundsFloor1())) {
                    level.playSound(null, player.blockPosition(), (SoundEvent)TESounds.ROAR.get(), SoundSource.HOSTILE);
                    if (shouldAlert) {
                        byte alert = LibUtils.getOrCreatePersistedData((Player)player).getByte("confluence:dungeon_guardian_alert");
                        LibUtils.getOrCreatePersistedData((Player)player).putByte("confluence:dungeon_guardian_alert", (byte)(alert + 1));
                        if (alert < 3) {
                            return true;
                        }
                    }
                    ModUtils.summonBoss(level, player.blockPosition(), (AbstractTerraBossBase)new DungeonGuardian((EntityType)TEBossEntities.DUNGEON_GUARDIAN.get(), (Level)level));
                }
                if (shouldAlert) {
                    LibUtils.getOrCreatePersistedData((Player)player).putByte("confluence:dungeon_guardian_alert", (byte)0);
                }
                return true;
            });
        }
    }

    public static boolean skipSpawn(Mob mob, ServerLevel level) {
        if (mob.getType().is(ModTags.EntityTypes.SPAWN_AT_DUNGEON)) {
            return DungeonStructure.iterateDungeon(level, mob.chunkPosition(), structureStart -> mob.getY() >= (double)(IStructureStart.of(structureStart).confluence$cachedBoundingBox().minY() + DungeonStructure.getUpperBoundsFloor1()));
        }
        return false;
    }

    public static boolean iterateDungeon(ServerLevel level, ChunkPos chunkPos, Predicate<StructureStart> consumer) {
        Structure structure = (Structure)level.registryAccess().registryOrThrow(Registries.STRUCTURE).get(ModStructures.Keys.DUNGEON);
        if (structure == null) {
            return false;
        }
        LongSet structureRefs = level.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.STRUCTURE_REFERENCES).getReferencesForStructure(structure);
        LongIterator longIterator = structureRefs.iterator();
        while (longIterator.hasNext()) {
            long packed = (Long)longIterator.next();
            SectionPos sectionPos = SectionPos.of((int)ChunkPos.getX((long)packed), (int)level.getMinSection(), (int)ChunkPos.getZ((long)packed));
            StructureStart structureStart = level.structureManager().getStartForStructure(sectionPos, structure, (StructureAccess)level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_STARTS));
            if (structureStart == null || !structureStart.isValid() || !consumer.test(structureStart)) continue;
            return true;
        }
        return false;
    }

    public static int getUpperBoundsFloor1() {
        return 90;
    }

    public static int getUpperBoundsFloor2() {
        return 32;
    }
}

